/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.predicate;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionBiValue;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionType;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionTypes;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionValue;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class ComparisonPredicateIntegrationTest
extends ExpressionTestSupport {
    static final int RES_EQ = 0;
    static final int RES_LT = -1;
    static final int RES_GT = 1;
    static final Integer RES_NULL = null;
    static final ZoneId DEFAULT_TIME_ZONE = ZoneId.systemDefault();
    @Parameterized.Parameter
    public Mode mode;
    protected static final Object[][] CMP_QUICK = new Object[][]{{Mode.EQ}, {Mode.LT}, {Mode.GT}};
    protected static final Object[][] CMP_SLOW = new Object[][]{{Mode.EQ}, {Mode.LT}, {Mode.LTE}, {Mode.GT}, {Mode.GTE}};
    protected static final Object[] NUMERICS_QUICK = new Object[]{Integer.MIN_VALUE, Integer.MAX_VALUE, Long.MIN_VALUE, Long.MAX_VALUE, BigDecimal.ONE.negate(), BigDecimal.ONE, Double.MIN_VALUE, Double.MAX_VALUE};
    protected static final Object[] NUMERICS_SLOW = new Object[]{(byte)-128, (byte)-1, (byte)0, (byte)1, (byte)127, (short)Short.MIN_VALUE, (short)-1, (short)0, (short)1, (short)Short.MAX_VALUE, Integer.MIN_VALUE, -1, 0, 1, Integer.MAX_VALUE, Long.MIN_VALUE, -1L, 0L, 1L, Long.MAX_VALUE, BigInteger.ONE.negate(), BigInteger.ZERO, BigInteger.ONE, BigDecimal.ONE.negate(), BigDecimal.ZERO, BigDecimal.ONE, Float.valueOf(Float.MIN_VALUE), Float.valueOf(-1.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(Float.MAX_VALUE), Double.MIN_VALUE, -1.0, 0.0, 1.0, Double.MAX_VALUE};
    private static final Literal LITERAL_BOOLEAN = new Literal("true", SqlColumnType.BOOLEAN);
    private static final Literal LITERAL_VARCHAR = new Literal("'true'", SqlColumnType.VARCHAR);
    private static final Literal LITERAL_TINYINT = new Literal("1", SqlColumnType.TINYINT);
    private static final Literal LITERAL_DECIMAL = new Literal("1.1", SqlColumnType.DECIMAL);
    private static final Literal LITERAL_DOUBLE = new Literal("1.1E1", SqlColumnType.DOUBLE);

    @Parameterized.Parameters(name="mode:{0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList(CMP_QUICK);
    }

    @Test(timeout=600000L)
    public void testString() {
        this.putCheckCommute(ComparisonPredicateIntegrationTest.stringValue2("a", "a"), "field1", "field2", 0, new Object[0]);
        this.putCheckCommute(ComparisonPredicateIntegrationTest.stringValue2("a", "b"), "field1", "field2", -1, new Object[0]);
        this.putCheckCommute(ComparisonPredicateIntegrationTest.stringValue2("a", null), "field1", "field2", RES_NULL, new Object[0]);
        this.putCheckCommute(ComparisonPredicateIntegrationTest.stringValue2(null, null), "field1", "field2", RES_NULL, new Object[0]);
        this.checkUnsupportedColumnColumn(ExpressionTypes.STRING, ExpressionTypes.allExcept(ExpressionTypes.STRING, ExpressionTypes.CHARACTER));
        this.putCheckCommute(ComparisonPredicateIntegrationTest.stringValue1("a"), "field1", "'a'", 0, new Object[0]);
        this.putCheckCommute(ComparisonPredicateIntegrationTest.stringValue1("a"), "field1", "'b'", -1, new Object[0]);
        this.putCheckCommute(ComparisonPredicateIntegrationTest.stringValue1("a"), "field1", "null", RES_NULL, new Object[0]);
        this.putCheckCommute(ComparisonPredicateIntegrationTest.stringValue1(null), "field1", "'a'", RES_NULL, new Object[0]);
        this.putCheckCommute(ComparisonPredicateIntegrationTest.stringValue1(null), "field1", "null", RES_NULL, new Object[0]);
        this.checkUnsupportedColumnLiteral(Character.valueOf('a'), SqlColumnType.VARCHAR, LITERAL_BOOLEAN, LITERAL_TINYINT, LITERAL_DECIMAL, LITERAL_DOUBLE);
        this.putCheckCommute(ComparisonPredicateIntegrationTest.stringValue1("a"), "field1", "?", 0, "a");
        this.putCheckCommute(ComparisonPredicateIntegrationTest.stringValue1("a"), "field1", "?", -1, "b");
        this.putCheckCommute(ComparisonPredicateIntegrationTest.stringValue1("a"), "field1", "?", RES_NULL, new Object[]{null});
        this.putCheckCommute(ComparisonPredicateIntegrationTest.stringValue1(null), "field1", "?", RES_NULL, "a");
        this.putCheckCommute(ComparisonPredicateIntegrationTest.stringValue1(null), "field1", "?", RES_NULL, new Object[]{null});
        this.checkUnsupportedColumnParameter("a", SqlColumnType.VARCHAR, 0, ExpressionTypes.allExcept(ExpressionTypes.STRING, ExpressionTypes.CHARACTER));
        this.checkCommute("'a'", "'a'", 0, new Object[0]);
        this.checkCommute("'a'", "'b'", -1, new Object[0]);
        this.checkCommute("'a'", "null", RES_NULL, new Object[0]);
        this.checkCommute("null", "null", RES_NULL, new Object[0]);
        this.checkUnsupportedLiteralLiteral("'a'", SqlColumnType.VARCHAR, LITERAL_BOOLEAN, LITERAL_TINYINT, LITERAL_DECIMAL, LITERAL_DOUBLE);
        this.checkCommute("'a'", "?", 0, "a");
        this.checkCommute("'a'", "?", -1, "b");
        this.checkCommute("'a'", "?", RES_NULL, new Object[]{null});
        this.checkCommute("'a'", "?", RES_NULL, new Object[]{null});
        this.checkFailure("null", "?", 1008, ComparisonPredicateIntegrationTest.signatureErrorOperator(this.mode.token(), SqlTypeName.NULL, SqlTypeName.UNKNOWN), true);
    }

    @Test(timeout=600000L)
    public void testBoolean() {
        this.putCheckCommute(ComparisonPredicateIntegrationTest.booleanValue2(true, true), "field1", "field2", 0, new Object[0]);
        this.putCheckCommute(ComparisonPredicateIntegrationTest.booleanValue2(true, false), "field1", "field2", 1, new Object[0]);
        this.putCheckCommute(ComparisonPredicateIntegrationTest.booleanValue2(true, null), "field1", "field2", RES_NULL, new Object[0]);
        this.putCheckCommute(ComparisonPredicateIntegrationTest.booleanValue2(false, false), "field1", "field2", 0, new Object[0]);
        this.putCheckCommute(ComparisonPredicateIntegrationTest.booleanValue2(false, null), "field1", "field2", RES_NULL, new Object[0]);
        this.putCheckCommute(ComparisonPredicateIntegrationTest.booleanValue2(null, null), "field1", "field2", RES_NULL, new Object[0]);
        this.checkUnsupportedColumnColumn(ExpressionTypes.BOOLEAN, ExpressionTypes.allExcept(ExpressionTypes.BOOLEAN));
        this.putCheckCommute(ComparisonPredicateIntegrationTest.booleanValue1(true), "field1", "true", 0, new Object[0]);
        this.putCheckCommute(ComparisonPredicateIntegrationTest.booleanValue1(true), "field1", "false", 1, new Object[0]);
        this.putCheckCommute(ComparisonPredicateIntegrationTest.booleanValue1(true), "field1", "null", RES_NULL, new Object[0]);
        this.putCheckCommute(ComparisonPredicateIntegrationTest.booleanValue1(false), "field1", "true", -1, new Object[0]);
        this.putCheckCommute(ComparisonPredicateIntegrationTest.booleanValue1(false), "field1", "false", 0, new Object[0]);
        this.putCheckCommute(ComparisonPredicateIntegrationTest.booleanValue1(false), "field1", "null", RES_NULL, new Object[0]);
        this.putCheckCommute(ComparisonPredicateIntegrationTest.booleanValue1(null), "field1", "true", RES_NULL, new Object[0]);
        this.putCheckCommute(ComparisonPredicateIntegrationTest.booleanValue1(null), "field1", "false", RES_NULL, new Object[0]);
        this.putCheckCommute(ComparisonPredicateIntegrationTest.booleanValue1(null), "field1", "null", RES_NULL, new Object[0]);
        this.checkUnsupportedColumnLiteral(true, SqlColumnType.BOOLEAN, LITERAL_VARCHAR, LITERAL_TINYINT, LITERAL_DECIMAL, LITERAL_DOUBLE);
        this.putCheckCommute(ComparisonPredicateIntegrationTest.booleanValue1(true), "field1", "?", 0, true);
        this.putCheckCommute(ComparisonPredicateIntegrationTest.booleanValue1(true), "field1", "?", 1, false);
        this.putCheckCommute(ComparisonPredicateIntegrationTest.booleanValue1(true), "field1", "?", RES_NULL, new Object[]{null});
        this.putCheckCommute(ComparisonPredicateIntegrationTest.booleanValue1(false), "field1", "?", -1, true);
        this.putCheckCommute(ComparisonPredicateIntegrationTest.booleanValue1(false), "field1", "?", 0, false);
        this.putCheckCommute(ComparisonPredicateIntegrationTest.booleanValue1(false), "field1", "?", RES_NULL, new Object[]{null});
        this.putCheckCommute(ComparisonPredicateIntegrationTest.booleanValue1(null), "field1", "?", RES_NULL, true);
        this.putCheckCommute(ComparisonPredicateIntegrationTest.booleanValue1(null), "field1", "?", RES_NULL, false);
        this.putCheckCommute(ComparisonPredicateIntegrationTest.booleanValue1(null), "field1", "?", RES_NULL, new Object[]{null});
        this.checkUnsupportedColumnParameter(true, SqlColumnType.BOOLEAN, 0, ExpressionTypes.allExcept(ExpressionTypes.BOOLEAN));
        this.checkCommute("true", "true", 0, new Object[0]);
        this.checkCommute("true", "false", 1, new Object[0]);
        this.checkCommute("true", "null", RES_NULL, new Object[0]);
        this.checkCommute("false", "false", 0, new Object[0]);
        this.checkCommute("false", "null", RES_NULL, new Object[0]);
        this.checkCommute("null", "null", RES_NULL, new Object[0]);
        this.checkUnsupportedLiteralLiteral("true", SqlColumnType.BOOLEAN, LITERAL_VARCHAR, LITERAL_TINYINT, LITERAL_DECIMAL, LITERAL_DOUBLE);
        this.checkCommute("true", "?", 0, true);
        this.checkCommute("true", "?", 1, false);
        this.checkCommute("true", "?", RES_NULL, new Object[]{null});
        this.checkCommute("false", "?", -1, true);
        this.checkCommute("false", "?", 0, false);
        this.checkCommute("false", "?", RES_NULL, new Object[]{null});
        this.checkFailure("null", "?", 1008, ComparisonPredicateIntegrationTest.signatureErrorOperator(this.mode.token(), SqlTypeName.NULL, SqlTypeName.UNKNOWN), true);
    }

    @Test(timeout=600000L)
    public void testNumeric() {
        Object[] values = this.getNumericValues();
        for (int i = 0; i < values.length; ++i) {
            for (int j = i; j < values.length; ++j) {
                this.checkNumeric(values[i], values[j]);
            }
        }
        for (ExpressionType<?> type : ExpressionTypes.numeric()) {
            this.checkUnsupportedColumnColumn(type, ExpressionTypes.allExcept(ExpressionTypes.numeric()));
            SqlColumnType columnType = type.getFieldConverterType().getTypeFamily().getPublicType();
            this.checkUnsupportedColumnLiteral(type.valueFrom(), columnType, LITERAL_VARCHAR, LITERAL_BOOLEAN);
            if (type.getFieldConverterType().getTypeFamily().getPrecedence() < QueryDataType.BIGINT.getTypeFamily().getPrecedence()) continue;
            this.checkUnsupportedColumnParameter(type.valueFrom(), columnType, 0, ExpressionTypes.allExcept(ExpressionTypes.numeric()));
        }
    }

    @Test
    public void testParameterParameter() {
        this.put(1);
        this.checkFailure("?", "?", 1008, ComparisonPredicateIntegrationTest.signatureErrorOperator(this.mode.token(), SqlTypeName.UNKNOWN, SqlTypeName.UNKNOWN), true, true);
    }

    @Test
    public void testUnsupported() {
        this.checkUnsupportedColumnColumn(ExpressionTypes.LOCAL_DATE, ExpressionTypes.allExcept(ExpressionTypes.LOCAL_DATE, ExpressionTypes.LOCAL_DATE_TIME, ExpressionTypes.OFFSET_DATE_TIME));
        this.checkUnsupportedColumnColumn(ExpressionTypes.LOCAL_TIME, ExpressionTypes.allExcept(ExpressionTypes.LOCAL_TIME, ExpressionTypes.LOCAL_DATE_TIME, ExpressionTypes.OFFSET_DATE_TIME));
        this.checkUnsupportedColumnColumn(ExpressionTypes.LOCAL_DATE_TIME, ExpressionTypes.allExcept(ExpressionTypes.LOCAL_DATE, ExpressionTypes.LOCAL_TIME, ExpressionTypes.LOCAL_DATE_TIME, ExpressionTypes.OFFSET_DATE_TIME));
        this.checkUnsupportedColumnColumn(ExpressionTypes.OFFSET_DATE_TIME, ExpressionTypes.allExcept(ExpressionTypes.LOCAL_DATE, ExpressionTypes.LOCAL_TIME, ExpressionTypes.LOCAL_DATE_TIME, ExpressionTypes.OFFSET_DATE_TIME));
        this.checkUnsupportedColumnColumn(ExpressionTypes.OBJECT, ExpressionTypes.allExcept(ExpressionTypes.OBJECT));
    }

    @Test
    public void testComparable_to_Comparable() {
        this.putBiValue(new ComparableImpl(1), new ComparableImpl(1), ExpressionTypes.OBJECT, ExpressionTypes.OBJECT);
        this.check("field1", "field2", new ComparableImpl(1).compareTo(new ComparableImpl(1)), new Object[0]);
        this.putBiValue(new ComparableImpl(1), new ComparableImpl(2), ExpressionTypes.OBJECT, ExpressionTypes.OBJECT);
        this.check("field1", "field2", new ComparableImpl(1).compareTo(new ComparableImpl(2)), new Object[0]);
        this.putBiValue(new ComparableImpl(2), new ComparableImpl(1), ExpressionTypes.OBJECT, ExpressionTypes.OBJECT);
        this.check("field1", "field2", new ComparableImpl(2).compareTo(new ComparableImpl(1)), new Object[0]);
    }

    @Test
    public void testComparable_and_NonComparable() {
        this.putBiValue(new ComparableImpl(1), new NonComparable(), ExpressionTypes.OBJECT, ExpressionTypes.OBJECT);
        this.checkFailure("field1", "field2", -1, "Cannot compare two OBJECT values, because left operand has " + String.valueOf(ComparableImpl.class) + " type and right operand has " + String.valueOf(NonComparable.class) + " type", new Object[0]);
        this.putBiValue(new NonComparable(), new ComparableImpl(1), ExpressionTypes.OBJECT, ExpressionTypes.OBJECT);
        this.checkFailure("field1", "field2", -1, "Cannot compare two OBJECT values, because left operand has " + String.valueOf(NonComparable.class) + " type and right operand has " + String.valueOf(ComparableImpl.class) + " type", new Object[0]);
    }

    @Test
    public void testDifferentClassThatImplementsComparableInterface() {
        this.putBiValue(new ComparableImpl(1), new ComparableImpl2(1), ExpressionTypes.OBJECT, ExpressionTypes.OBJECT);
        this.checkFailure("field1", "field2", -1, "Cannot compare two OBJECT values, because left operand has " + String.valueOf(ComparableImpl.class) + " type and right operand has " + String.valueOf(ComparableImpl2.class) + " type", new Object[0]);
    }

    @Test
    public void testNonComparableObjects() {
        this.putBiValue(new NonComparable(), new NonComparable(), ExpressionTypes.OBJECT, ExpressionTypes.OBJECT);
        this.checkFailure("field1", "field2", -1, "Cannot compare OBJECT value because " + String.valueOf(NonComparable.class) + " doesn't implement Comparable interface", new Object[0]);
    }

    @Test
    public void testCompare_LocalDate_with_LocalDate() {
        this.putBiValue(LocalDate.of(2020, 12, 30), LocalDate.of(2020, 12, 30), ExpressionTypes.LOCAL_DATE, ExpressionTypes.LOCAL_DATE);
        this.check("field1", "field2", LocalDate.of(2020, 12, 30).compareTo(LocalDate.of(2020, 12, 30)), new Object[0]);
    }

    @Test
    public void testCompare_LocalDate_with_String() {
        this.put(ExpressionValue.create(ExpressionValue.createClass(ExpressionTypes.LOCAL_DATE), LocalDate.of(2020, 12, 30)));
        this.check("field1", "'2020-12-30'", LocalDate.of(2020, 12, 30).compareTo(LocalDate.of(2020, 12, 30)), new Object[0]);
        this.check("'2020-12-30'", "field1", LocalDate.of(2020, 12, 30).compareTo(LocalDate.of(2020, 12, 30)), new Object[0]);
    }

    @Test
    public void testCompare_LocalTime_with_LocalTime() {
        this.putBiValue(LocalTime.of(14, 2, 0), LocalTime.of(14, 2, 0), ExpressionTypes.LOCAL_TIME, ExpressionTypes.LOCAL_TIME);
        this.check("field1", "field2", LocalTime.of(14, 2, 0).compareTo(LocalTime.of(14, 2, 0)), new Object[0]);
    }

    @Test
    public void testCompare_LocalTime_with_String() {
        this.put(ExpressionValue.create(ExpressionValue.createClass(ExpressionTypes.LOCAL_TIME), LocalTime.of(14, 2, 0)));
        this.check("field1", "'14:02:00'", LocalTime.of(14, 2, 0).compareTo(LocalTime.of(14, 2, 0)), new Object[0]);
        this.check("'14:02:00'", "field1", LocalTime.of(14, 2, 0).compareTo(LocalTime.of(14, 2, 0)), new Object[0]);
    }

    @Test
    public void testCompare_LocalDateTime_with_LocalDateTime() {
        this.putBiValue(LocalDateTime.of(2020, 12, 30, 14, 2, 0), LocalDateTime.of(2020, 12, 30, 14, 2, 0), ExpressionTypes.LOCAL_DATE_TIME, ExpressionTypes.LOCAL_DATE_TIME);
        this.check("field1", "field2", LocalDateTime.of(2020, 12, 30, 14, 2, 0).compareTo(LocalDateTime.of(2020, 12, 30, 14, 2, 0)), new Object[0]);
    }

    @Test
    public void testCompare_LocalDateTime_with_String() {
        this.put(ExpressionValue.create(ExpressionValue.createClass(ExpressionTypes.LOCAL_DATE_TIME), LocalDateTime.of(2020, 12, 30, 14, 2, 0)));
        this.check("field1", "'2020-12-30T14:02'", LocalDateTime.of(2020, 12, 30, 14, 2, 0).compareTo(LocalDateTime.of(2020, 12, 30, 14, 2, 0)), new Object[0]);
        this.check("'2020-12-30T14:02'", "field1", LocalDateTime.of(2020, 12, 30, 14, 2, 0).compareTo(LocalDateTime.of(2020, 12, 30, 14, 2, 0)), new Object[0]);
    }

    @Test
    public void testCompare_LocalDateTime_with_LocalDate() {
        this.putBiValue(LocalDateTime.of(2020, 12, 30, 14, 2, 0), LocalDate.of(2020, 12, 30), ExpressionTypes.LOCAL_DATE_TIME, ExpressionTypes.LOCAL_DATE);
        this.check("field1", "field2", LocalDateTime.of(2020, 12, 30, 14, 2, 0).compareTo(LocalDate.of(2020, 12, 30).atStartOfDay()), new Object[0]);
        this.putBiValue(LocalDate.of(2020, 12, 30), LocalDateTime.of(2020, 12, 30, 14, 2, 0), ExpressionTypes.LOCAL_DATE, ExpressionTypes.LOCAL_DATE_TIME);
        this.check("field1", "field2", LocalDate.of(2020, 12, 30).atStartOfDay().compareTo(LocalDateTime.of(2020, 12, 30, 14, 2, 0)), new Object[0]);
    }

    @Test
    public void testCompare_LocalDateTime_with_LocalTime() {
        this.putBiValue(LocalDateTime.of(2020, 12, 30, 14, 2, 0), LocalTime.of(14, 2, 0), ExpressionTypes.LOCAL_DATE_TIME, ExpressionTypes.LOCAL_TIME);
        this.check("cast (field1 as TIME)", "field2", LocalDateTime.of(2020, 12, 30, 14, 2, 0).toLocalTime().compareTo(LocalTime.of(14, 2, 0)), new Object[0]);
        this.check("field1", "field2", LocalDateTime.of(2020, 12, 30, 14, 2, 0).compareTo(LocalDateTime.of(LocalDate.now(), LocalTime.of(14, 2, 0))), new Object[0]);
        this.putBiValue(LocalTime.of(14, 2, 0), LocalDateTime.of(2020, 12, 30, 14, 2, 0), ExpressionTypes.LOCAL_TIME, ExpressionTypes.LOCAL_DATE_TIME);
        this.check("field1", "cast (field2 as TIME)", LocalTime.of(14, 2, 0).compareTo(LocalDateTime.of(2020, 12, 30, 14, 2, 0).toLocalTime()), new Object[0]);
        this.check("field1", "field2", LocalDateTime.of(LocalDate.now(), LocalTime.of(14, 2, 0)).compareTo(LocalDateTime.of(2020, 12, 30, 14, 2, 0)), new Object[0]);
    }

    @Test
    public void testCompare_LocalDateTimeWithTZ_with_LocalDateTimeWithTZ() {
        this.putBiValue(OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC), OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC), ExpressionTypes.OFFSET_DATE_TIME, ExpressionTypes.OFFSET_DATE_TIME);
        this.check("field1", "field2", OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC).compareTo(OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC)), new Object[0]);
    }

    @Test
    public void testCompare_LocalDateTimeWithTZ_with_String() {
        this.put(ExpressionValue.create(ExpressionValue.createClass(ExpressionTypes.OFFSET_DATE_TIME), OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC)));
        this.check("field1", "'2020-12-30T14:02Z'", OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC).compareTo(OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC)), new Object[0]);
        this.check("'2020-12-30T14:02Z'", "field1", OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC).compareTo(OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC)), new Object[0]);
    }

    @Test
    public void testCompare_LocalDateTimeWithTZ_with_LocalDateTime() {
        this.putBiValue(OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC), LocalDateTime.of(2020, 12, 30, 14, 2, 0), ExpressionTypes.OFFSET_DATE_TIME, ExpressionTypes.LOCAL_DATE_TIME);
        this.check("field1", "field2", OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC).compareTo(ZonedDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), DEFAULT_TIME_ZONE).toOffsetDateTime()), new Object[0]);
        this.putBiValue(LocalDateTime.of(2020, 12, 30, 14, 2, 0), OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC), ExpressionTypes.LOCAL_DATE_TIME, ExpressionTypes.OFFSET_DATE_TIME);
        this.check("field1", "field2", ZonedDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), DEFAULT_TIME_ZONE).toOffsetDateTime().compareTo(OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC)), new Object[0]);
    }

    @Test
    public void testCompare_LocalDateTimeWithTZ_with_LocalDate() {
        this.putBiValue(OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC), LocalDate.of(2020, 12, 30), ExpressionTypes.OFFSET_DATE_TIME, ExpressionTypes.LOCAL_DATE);
        this.check("field1", "field2", OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC).compareTo(ZonedDateTime.of(LocalDate.of(2020, 12, 30).atStartOfDay(), DEFAULT_TIME_ZONE).toOffsetDateTime()), new Object[0]);
        this.putBiValue(LocalDate.of(2020, 12, 30), OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC), ExpressionTypes.LOCAL_DATE, ExpressionTypes.OFFSET_DATE_TIME);
        this.check("field1", "field2", ZonedDateTime.of(LocalDate.of(2020, 12, 30).atStartOfDay(), DEFAULT_TIME_ZONE).toOffsetDateTime().compareTo(OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC)), new Object[0]);
    }

    @Test
    public void testCompare_LocalDateTimeWithTZ_with_LocalTime() {
        this.putBiValue(OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC), LocalTime.of(14, 2, 0), ExpressionTypes.OFFSET_DATE_TIME, ExpressionTypes.LOCAL_TIME);
        this.check("cast (field1 as TIME)", "field2", OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC).toLocalTime().compareTo(LocalTime.of(14, 2, 0)), new Object[0]);
        this.check("field1", "field2", OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC).compareTo(OffsetDateTime.of(LocalDateTime.of(LocalDate.now(), LocalTime.of(14, 2, 0)), ZoneOffset.UTC)), new Object[0]);
        this.putBiValue(LocalTime.of(14, 2, 0), OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC), ExpressionTypes.LOCAL_TIME, ExpressionTypes.OFFSET_DATE_TIME);
        this.check("field1", "cast (field2 as TIME)", LocalTime.of(14, 2, 0).compareTo(OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC).toLocalTime()), new Object[0]);
        this.check("field1", "field2", OffsetDateTime.of(LocalDateTime.of(LocalDate.now(), LocalTime.of(14, 2, 0)), ZoneOffset.UTC).compareTo(OffsetDateTime.of(LocalDateTime.of(2020, 12, 30, 14, 2, 0), ZoneOffset.UTC)), new Object[0]);
    }

    private void putBiValue(Object field1, Object field2, ExpressionType<?> type1, ExpressionType<?> type2) {
        Object value = ExpressionBiValue.createBiValue(ExpressionBiValue.createBiClass(type1, type2), field1, field2);
        this.put(value);
    }

    protected Object[] getNumericValues() {
        return NUMERICS_QUICK;
    }

    private void checkNumeric(Object value1, Object value2) {
        int res = ComparisonPredicateIntegrationTest.compareNumeric(value1, value2);
        if (res == 0 && (value1 instanceof Float || value1 instanceof Double || value2 instanceof Float || value2 instanceof Double)) {
            return;
        }
        ExpressionType<?> valueType1 = ExpressionTypes.resolve(value1);
        ExpressionType<?> valueType2 = ExpressionTypes.resolve(value2);
        Class<? extends ExpressionValue> class1 = ExpressionValue.createClass(valueType1);
        Class<? extends ExpressionValue> class2 = ExpressionValue.createClass(valueType2);
        Class<? extends ExpressionBiValue> biClass = ExpressionBiValue.createBiClass(valueType1, valueType2);
        String literal1 = value1.toString();
        String literal2 = value2.toString();
        QueryDataType type1 = QueryDataTypeUtils.resolveTypeForClass(value1.getClass());
        QueryDataType type2 = QueryDataTypeUtils.resolveTypeForClass(value2.getClass());
        SqlColumnType publicType1 = type1.getTypeFamily().getPublicType();
        SqlColumnType publicType2 = type2.getTypeFamily().getPublicType();
        int precedence1 = type1.getTypeFamily().getPrecedence();
        int precedence2 = type2.getTypeFamily().getPrecedence();
        this.putCheckCommute(ExpressionBiValue.createBiValue(biClass, value1, value2), "field1", "field2", res, new Object[0]);
        this.putCheckCommute(ExpressionBiValue.createBiValue(biClass, value1, null), "field1", "field2", RES_NULL, new Object[0]);
        this.putCheckCommute(ExpressionBiValue.createBiValue(biClass, null, value2), "field1", "field2", RES_NULL, new Object[0]);
        this.putCheckCommute(ExpressionValue.create(class1, value1), "field1", literal2, res, new Object[0]);
        this.putCheckCommute(ExpressionValue.create(class2, value2), literal1, "field1", res, new Object[0]);
        if (precedence1 >= precedence2) {
            this.putCheckCommute(ExpressionValue.create(class1, value1), "field1", "?", res, value2);
        } else if (precedence1 >= QueryDataType.BIGINT.getTypeFamily().getPrecedence()) {
            this.putAndCheckFailure(ExpressionValue.create(class1, value1), this.sql(this.mode.token(), "field1", "?"), 2000, ComparisonPredicateIntegrationTest.parameterError(0, publicType1, publicType2), value2);
        }
        if (precedence2 >= precedence1) {
            this.putCheckCommute(ExpressionValue.create(class2, value2), "?", "field1", res, value1);
        } else if (precedence2 >= QueryDataType.BIGINT.getTypeFamily().getPrecedence()) {
            this.putAndCheckFailure(ExpressionValue.create(class2, value2), this.sql(this.mode.token(), "?", "field1"), 2000, ComparisonPredicateIntegrationTest.parameterError(0, publicType2, publicType1), value1);
        }
        this.checkCommute(literal1, literal2, res, new Object[0]);
    }

    private static Integer compareNumeric(Object value1, Object value2) {
        if (value1 == null || value2 == null) {
            return RES_NULL;
        }
        BigDecimal decimal1 = new BigDecimal(value1.toString());
        BigDecimal decimal2 = new BigDecimal(value2.toString());
        return decimal1.compareTo(decimal2);
    }

    private void checkUnsupportedColumnColumn(ExpressionType<?> type, ExpressionType<?> ... excludeTypes) {
        for (ExpressionType<?> expressionType : excludeTypes) {
            Object value = ExpressionBiValue.createBiValue(ExpressionBiValue.createBiClass(type, expressionType), null, null);
            this.put(value);
            String sql = this.sql(this.mode.token(), "field1", "field2");
            String errorMessage = ComparisonPredicateIntegrationTest.signatureErrorOperator(this.mode.token(), type.getFieldConverterType().getTypeFamily().getPublicType(), expressionType.getFieldConverterType().getTypeFamily().getPublicType());
            this.checkFailure0(sql, 1008, errorMessage, new Object[0]);
        }
    }

    private void checkUnsupportedColumnLiteral(Object columnValue, SqlColumnType columnType, Literal ... literals) {
        for (Literal literal : literals) {
            this.put(columnValue);
            String sql = this.sql(this.mode.token(), "this", literal.value);
            String errorMessage = ComparisonPredicateIntegrationTest.signatureErrorOperator(this.mode.token(), columnType, literal.type);
            this.checkFailure0(sql, 1008, errorMessage, new Object[0]);
        }
    }

    private void checkUnsupportedColumnParameter(Object columnValue, SqlColumnType columnType, int paramPos, ExpressionType<?> ... parameterTypes) {
        for (ExpressionType<?> parameterType : parameterTypes) {
            this.put(columnValue);
            String sql = this.sql(this.mode.token(), "this", "?");
            String errorMessage = ComparisonPredicateIntegrationTest.parameterError(paramPos, columnType, parameterType.getFieldConverterType().getTypeFamily().getPublicType());
            try {
                this.checkFailure0(sql, 2000, errorMessage, parameterType.valueFrom());
            }
            catch (AssertionError e) {
                throw new AssertionError("When comparing " + String.valueOf(columnType) + " & " + String.valueOf(parameterType) + ": " + String.valueOf(e), (Throwable)((Object)e));
            }
        }
    }

    private void checkUnsupportedLiteralLiteral(String literalValue, SqlColumnType literalType, Literal ... literals) {
        for (Literal literal : literals) {
            this.put(1);
            String sql = this.sql(this.mode.token(), literalValue, literal.value);
            String errorMessage = ComparisonPredicateIntegrationTest.signatureErrorOperator(this.mode.token(), literalType, literal.type);
            this.checkFailure0(sql, 1008, errorMessage, new Object[0]);
        }
    }

    private void putCheckCommute(Object value, String operand1, String operand2, Integer expectedResult, Object ... params) {
        this.put(value);
        this.checkCommute(operand1, operand2, expectedResult, params);
    }

    private void checkCommute(String operand1, String operand2, Integer expectedResult, Object ... params) {
        this.check(operand1, operand2, expectedResult, params);
        this.check(operand2, operand1, ComparisonPredicateIntegrationTest.inverse(expectedResult), params);
    }

    private void check(String operand1, String operand2, Integer expectedRes, Object ... params) {
        Boolean expectedValue = this.compare(expectedRes);
        String sql = this.sql(this.mode.token(), operand1, operand2);
        this.checkValue0(sql, SqlColumnType.BOOLEAN, expectedValue, params);
    }

    private void checkFailure(String operand1, String operand2, int expectedErrorCode, String expectedErrorMessage, Object ... params) {
        String sql = this.sql(this.mode.token(), operand1, operand2);
        this.checkFailure0(sql, expectedErrorCode, expectedErrorMessage, params);
    }

    private String sql(String token, String operand1, String operand2) {
        return "SELECT " + operand1 + " " + token + " " + operand2 + " FROM map";
    }

    private static Integer inverse(Integer result) {
        if (result == null) {
            return null;
        }
        switch (result) {
            case 1: {
                return -1;
            }
            case -1: {
                return 1;
            }
        }
        assert (result == 0);
        return 0;
    }

    public Boolean compare(Integer res) {
        if (res == null) {
            return null;
        }
        switch (this.mode) {
            case EQ: {
                return res == 0;
            }
            case NEQ: {
                return res != 0;
            }
            case LT: {
                return res < 0;
            }
            case LTE: {
                return res <= 0;
            }
            case GT: {
                return res > 0;
            }
        }
        assert (this.mode == Mode.GTE);
        return res >= 0;
    }

    private static class Literal {
        private final String value;
        private final SqlColumnType type;

        private Literal(String value, SqlColumnType type) {
            this.value = value;
            this.type = type;
        }
    }

    private static enum Mode {
        EQ("="),
        NEQ("<>"),
        LT("<"),
        LTE("<="),
        GT(">"),
        GTE(">=");

        private final String token;

        private Mode(String token) {
            this.token = token;
        }

        private String token() {
            return this.token;
        }
    }

    static class ComparableImpl
    implements Comparable<ComparableImpl>,
    Serializable {
        int innerField;

        ComparableImpl(int innerField) {
            this.innerField = innerField;
        }

        @Override
        public int compareTo(ComparableImpl that) {
            return Integer.compare(this.innerField, that.innerField);
        }
    }

    static class NonComparable
    implements Serializable {
        NonComparable() {
        }
    }

    static class ComparableImpl2
    implements Comparable<ComparableImpl2>,
    Serializable {
        int innerField;

        ComparableImpl2(int innerField) {
            this.innerField = innerField;
        }

        @Override
        public int compareTo(ComparableImpl2 that) {
            return Integer.compare(this.innerField, that.innerField);
        }
    }
}

