/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.math;

import com.hazelcast.jet.sql.impl.expression.math.ArithmeticOperatorIntegrationTest;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.math.DivideFunction;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class DivideOperatorIntegrationTest
extends ArithmeticOperatorIntegrationTest {
    @Override
    protected String operator() {
        return "/";
    }

    @Test
    public void testTinyint() {
        this.putAndCheckValue((byte)0, this.sql("this", "null"), SqlColumnType.SMALLINT, null, new Object[0]);
        this.putAndCheckValue((byte)0, this.sql("null", "this"), SqlColumnType.SMALLINT, null, new Object[0]);
        this.checkFields((byte)3, (byte)2, SqlColumnType.SMALLINT, (short)1);
        this.checkFields((byte)3, (byte)4, SqlColumnType.SMALLINT, (short)0);
        this.checkError((byte)3, (byte)0, 2000, DivideOperatorIntegrationTest.divisionByZeroError());
        this.checkFields((byte)-128, (byte)-1, SqlColumnType.SMALLINT, (short)128);
        this.checkFields((byte)3, (short)2, SqlColumnType.INTEGER, 1);
        this.checkFields((byte)3, (short)4, SqlColumnType.INTEGER, 0);
        this.checkError((byte)3, (short)0, 2000, DivideOperatorIntegrationTest.divisionByZeroError());
        this.checkFields((byte)-128, (short)-1, SqlColumnType.INTEGER, 128);
        this.checkFields((byte)3, 2, SqlColumnType.BIGINT, 1L);
        this.checkFields((byte)3, 4, SqlColumnType.BIGINT, 0L);
        this.checkError((byte)3, 0, 2000, DivideOperatorIntegrationTest.divisionByZeroError());
        this.checkFields((byte)-128, -1, SqlColumnType.BIGINT, 128L);
        this.checkFields((byte)3, 2L, SqlColumnType.BIGINT, 1L);
        this.checkFields((byte)3, 4L, SqlColumnType.BIGINT, 0L);
        this.checkError((byte)3, 0L, 2000, DivideOperatorIntegrationTest.divisionByZeroError());
        this.checkFields((byte)-128, -1L, SqlColumnType.BIGINT, 128L);
        this.checkFields((byte)3, new BigInteger("2"), SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"));
        this.checkFields((byte)3, DivideOperatorIntegrationTest.decimal("2"), SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"));
        this.checkFields((byte)3, Float.valueOf(2.0f), SqlColumnType.REAL, Float.valueOf(1.5f));
        this.checkFields((byte)3, 2.0, SqlColumnType.DOUBLE, 1.5);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue((byte)3, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, (byte)2);
        this.putAndCheckValue((byte)3, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, (short)2);
        this.putAndCheckValue((byte)3, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, 2);
        this.putAndCheckValue((byte)3, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, 2L);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_INTEGER_VAL);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_DECIMAL_VAL);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure((byte)2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testSmallint() {
        this.putAndCheckValue((short)0, this.sql("this", "null"), SqlColumnType.INTEGER, null, new Object[0]);
        this.putAndCheckValue((short)0, this.sql("null", "this"), SqlColumnType.INTEGER, null, new Object[0]);
        this.checkFields((short)3, (byte)2, SqlColumnType.INTEGER, 1);
        this.checkFields((short)3, (byte)4, SqlColumnType.INTEGER, 0);
        this.checkError((short)3, (byte)0, 2000, DivideOperatorIntegrationTest.divisionByZeroError());
        this.checkFields((short)Short.MIN_VALUE, (byte)-1, SqlColumnType.INTEGER, 32768);
        this.checkFields((short)3, (short)2, SqlColumnType.INTEGER, 1);
        this.checkFields((short)3, (short)4, SqlColumnType.INTEGER, 0);
        this.checkError((short)3, (short)0, 2000, DivideOperatorIntegrationTest.divisionByZeroError());
        this.checkFields((short)Short.MIN_VALUE, (short)-1, SqlColumnType.INTEGER, 32768);
        this.checkFields((short)3, 2, SqlColumnType.BIGINT, 1L);
        this.checkFields((short)3, 4, SqlColumnType.BIGINT, 0L);
        this.checkError((short)3, 0, 2000, DivideOperatorIntegrationTest.divisionByZeroError());
        this.checkFields((short)Short.MIN_VALUE, -1, SqlColumnType.BIGINT, 32768L);
        this.checkFields((short)3, 2L, SqlColumnType.BIGINT, 1L);
        this.checkFields((short)3, 4L, SqlColumnType.BIGINT, 0L);
        this.checkError((short)3, 0L, 2000, DivideOperatorIntegrationTest.divisionByZeroError());
        this.checkFields((short)Short.MIN_VALUE, -1L, SqlColumnType.BIGINT, 32768L);
        this.checkFields((short)3, new BigInteger("2"), SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"));
        this.checkFields((short)3, DivideOperatorIntegrationTest.decimal("2"), SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"));
        this.checkFields((short)3, Float.valueOf(2.0f), SqlColumnType.REAL, Float.valueOf(1.5f));
        this.checkFields((short)3, 2.0, SqlColumnType.DOUBLE, 1.5);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue((short)3, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, (byte)2);
        this.putAndCheckValue((short)3, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, (short)2);
        this.putAndCheckValue((short)3, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, 2);
        this.putAndCheckValue((short)3, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, 2L);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_INTEGER_VAL);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_DECIMAL_VAL);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure((short)2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testInteger() {
        this.putAndCheckValue(0, this.sql("this", "null"), SqlColumnType.BIGINT, null, new Object[0]);
        this.putAndCheckValue(0, this.sql("null", "this"), SqlColumnType.BIGINT, null, new Object[0]);
        this.checkFields(3, (byte)2, SqlColumnType.BIGINT, 1L);
        this.checkFields(3, (byte)4, SqlColumnType.BIGINT, 0L);
        this.checkError(3, (byte)0, 2000, DivideOperatorIntegrationTest.divisionByZeroError());
        this.checkFields(Integer.MIN_VALUE, (byte)-1, SqlColumnType.BIGINT, 0x80000000L);
        this.checkFields(3, (short)2, SqlColumnType.BIGINT, 1L);
        this.checkFields(3, (short)4, SqlColumnType.BIGINT, 0L);
        this.checkError(3, (short)0, 2000, DivideOperatorIntegrationTest.divisionByZeroError());
        this.checkFields(Integer.MIN_VALUE, (short)-1, SqlColumnType.BIGINT, 0x80000000L);
        this.checkFields(3, 2, SqlColumnType.BIGINT, 1L);
        this.checkFields(3, 4, SqlColumnType.BIGINT, 0L);
        this.checkError(3, 0, 2000, DivideOperatorIntegrationTest.divisionByZeroError());
        this.checkFields(Integer.MIN_VALUE, -1, SqlColumnType.BIGINT, 0x80000000L);
        this.checkFields(3, 2L, SqlColumnType.BIGINT, 1L);
        this.checkFields(3, 4L, SqlColumnType.BIGINT, 0L);
        this.checkError(3, 0L, 2000, DivideOperatorIntegrationTest.divisionByZeroError());
        this.checkFields(Integer.MIN_VALUE, -1L, SqlColumnType.BIGINT, 0x80000000L);
        this.checkFields(3, new BigInteger("2"), SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"));
        this.checkFields(3, DivideOperatorIntegrationTest.decimal("2"), SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"));
        this.checkFields(3, Float.valueOf(2.0f), SqlColumnType.REAL, Float.valueOf(1.5f));
        this.checkFields(3, 2.0, SqlColumnType.DOUBLE, 1.5);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue(3, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, (byte)2);
        this.putAndCheckValue(3, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, (short)2);
        this.putAndCheckValue(3, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, 2);
        this.putAndCheckValue(3, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, 2L);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_INTEGER_VAL);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_DECIMAL_VAL);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure(2, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testBigint() {
        this.putAndCheckValue(0L, this.sql("this", "null"), SqlColumnType.BIGINT, null, new Object[0]);
        this.putAndCheckValue(0L, this.sql("null", "this"), SqlColumnType.BIGINT, null, new Object[0]);
        this.checkFields(3L, (byte)2, SqlColumnType.BIGINT, 1L);
        this.checkFields(3L, (byte)4, SqlColumnType.BIGINT, 0L);
        this.checkError(3L, (byte)0, 2000, DivideOperatorIntegrationTest.divisionByZeroError());
        this.checkError(Long.MIN_VALUE, (byte)-1, 2000, DivideOperatorIntegrationTest.overflowError());
        this.checkFields(3L, (short)2, SqlColumnType.BIGINT, 1L);
        this.checkFields(3L, (short)4, SqlColumnType.BIGINT, 0L);
        this.checkError(3L, (short)0, 2000, DivideOperatorIntegrationTest.divisionByZeroError());
        this.checkError(Long.MIN_VALUE, (short)-1, 2000, DivideOperatorIntegrationTest.overflowError());
        this.checkFields(3L, 2, SqlColumnType.BIGINT, 1L);
        this.checkFields(3L, 4, SqlColumnType.BIGINT, 0L);
        this.checkError(3L, 0, 2000, DivideOperatorIntegrationTest.divisionByZeroError());
        this.checkError(Long.MIN_VALUE, -1, 2000, DivideOperatorIntegrationTest.overflowError());
        this.checkFields(3L, 2L, SqlColumnType.BIGINT, 1L);
        this.checkFields(3L, 4L, SqlColumnType.BIGINT, 0L);
        this.checkError(3L, 0L, 2000, DivideOperatorIntegrationTest.divisionByZeroError());
        this.checkError(Long.MIN_VALUE, -1L, 2000, DivideOperatorIntegrationTest.overflowError());
        this.checkFields(3L, new BigInteger("2"), SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"));
        this.checkFields(3L, DivideOperatorIntegrationTest.decimal("2"), SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"));
        this.checkFields(3L, Float.valueOf(2.0f), SqlColumnType.REAL, Float.valueOf(1.5f));
        this.checkFields(3L, 2.0, SqlColumnType.DOUBLE, 1.5);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue(3L, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, (byte)2);
        this.putAndCheckValue(3L, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, (short)2);
        this.putAndCheckValue(3L, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, 2);
        this.putAndCheckValue(3L, this.sql("this", "?"), SqlColumnType.BIGINT, 1L, 2L);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_INTEGER_VAL);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_DECIMAL_VAL);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure(2L, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testDecimal_BigInteger() {
        this.putAndCheckValue(BigInteger.ZERO, this.sql("this", "null"), SqlColumnType.DECIMAL, null, new Object[0]);
        this.putAndCheckValue(BigInteger.ZERO, this.sql("null", "this"), SqlColumnType.DECIMAL, null, new Object[0]);
        this.checkFields(new BigInteger("3"), (byte)2, SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"));
        this.checkFields(new BigInteger("3"), (short)2, SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"));
        this.checkFields(new BigInteger("3"), 2, SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"));
        this.checkFields(new BigInteger("3"), 2L, SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"));
        this.checkFields(new BigInteger("3"), new BigInteger("2"), SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"));
        this.checkFields(new BigInteger("3"), DivideOperatorIntegrationTest.decimal("2"), SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"));
        this.checkFields(new BigInteger("3"), Float.valueOf(2.0f), SqlColumnType.REAL, Float.valueOf(1.5f));
        this.checkFields(new BigInteger("3"), 2.0, SqlColumnType.DOUBLE, 1.5);
        this.checkError(new BigInteger("3"), DivideOperatorIntegrationTest.decimal("0"), 2000, DivideOperatorIntegrationTest.divisionByZeroError());
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue(new BigInteger("3"), this.sql("this", "?"), SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"), (byte)2);
        this.putAndCheckValue(new BigInteger("3"), this.sql("this", "?"), SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"), (short)2);
        this.putAndCheckValue(new BigInteger("3"), this.sql("this", "?"), SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"), 2);
        this.putAndCheckValue(new BigInteger("3"), this.sql("this", "?"), SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"), 2L);
        this.putAndCheckValue(new BigInteger("3"), this.sql("this", "?"), SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"), new BigInteger("2"));
        this.putAndCheckValue(new BigInteger("3"), this.sql("this", "?"), SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"), DivideOperatorIntegrationTest.decimal("2"));
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testDecimal_BigDecimal() {
        this.putAndCheckValue(BigDecimal.ZERO, this.sql("this", "null"), SqlColumnType.DECIMAL, null, new Object[0]);
        this.putAndCheckValue(BigDecimal.ZERO, this.sql("null", "this"), SqlColumnType.DECIMAL, null, new Object[0]);
        this.checkFields(new BigDecimal("3"), (byte)2, SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"));
        this.checkFields(new BigDecimal("3"), (short)2, SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"));
        this.checkFields(new BigDecimal("3"), 2, SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"));
        this.checkFields(new BigDecimal("3"), 2L, SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"));
        this.checkFields(new BigDecimal("3"), new BigInteger("2"), SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"));
        this.checkFields(new BigDecimal("3"), DivideOperatorIntegrationTest.decimal("2"), SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"));
        this.checkFields(new BigDecimal("3"), Float.valueOf(2.0f), SqlColumnType.REAL, Float.valueOf(1.5f));
        this.checkFields(new BigDecimal("3"), 2.0, SqlColumnType.DOUBLE, 1.5);
        this.checkError(new BigDecimal("3"), DivideOperatorIntegrationTest.decimal("0"), 2000, DivideOperatorIntegrationTest.divisionByZeroError());
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue(new BigDecimal("3"), this.sql("this", "?"), SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"), (byte)2);
        this.putAndCheckValue(new BigDecimal("3"), this.sql("this", "?"), SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"), (short)2);
        this.putAndCheckValue(new BigDecimal("3"), this.sql("this", "?"), SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"), 2);
        this.putAndCheckValue(new BigDecimal("3"), this.sql("this", "?"), SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"), 2L);
        this.putAndCheckValue(new BigDecimal("3"), this.sql("this", "?"), SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"), new BigInteger("2"));
        this.putAndCheckValue(new BigDecimal("3"), this.sql("this", "?"), SqlColumnType.DECIMAL, DivideOperatorIntegrationTest.decimal("1.5"), DivideOperatorIntegrationTest.decimal("2"));
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testReal() {
        this.putAndCheckValue(Float.valueOf(0.0f), this.sql("this", "null"), SqlColumnType.REAL, null, new Object[0]);
        this.putAndCheckValue(Float.valueOf(0.0f), this.sql("null", "this"), SqlColumnType.REAL, null, new Object[0]);
        this.checkFields(Float.valueOf(3.0f), Float.valueOf(2.0f), SqlColumnType.REAL, Float.valueOf(1.5f));
        this.checkError(Float.valueOf(3.0f), Float.valueOf(0.0f), 2000, DivideOperatorIntegrationTest.divisionByZeroError());
        this.checkFields(Float.valueOf(3.0f), 2.0, SqlColumnType.DOUBLE, 1.5);
        this.checkError(Float.valueOf(3.0f), 0.0, 2000, DivideOperatorIntegrationTest.divisionByZeroError());
        this.putAndCheckFailure(Float.valueOf(2.0f), this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure(Float.valueOf(2.0f), this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure(Float.valueOf(2.0f), this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue(Float.valueOf(3.0f), this.sql("this", "?"), SqlColumnType.REAL, Float.valueOf(1.5f), (byte)2);
        this.putAndCheckValue(Float.valueOf(3.0f), this.sql("this", "?"), SqlColumnType.REAL, Float.valueOf(1.5f), (short)2);
        this.putAndCheckValue(Float.valueOf(3.0f), this.sql("this", "?"), SqlColumnType.REAL, Float.valueOf(1.5f), 2);
        this.putAndCheckValue(Float.valueOf(3.0f), this.sql("this", "?"), SqlColumnType.REAL, Float.valueOf(1.5f), 2L);
        this.putAndCheckValue(Float.valueOf(3.0f), this.sql("this", "?"), SqlColumnType.REAL, Float.valueOf(1.5f), new BigInteger("2"));
        this.putAndCheckValue(Float.valueOf(3.0f), this.sql("this", "?"), SqlColumnType.REAL, Float.valueOf(1.5f), DivideOperatorIntegrationTest.decimal("2"));
        this.putAndCheckValue(Float.valueOf(3.0f), this.sql("this", "?"), SqlColumnType.REAL, Float.valueOf(1.5f), Float.valueOf(2.0f));
        this.putAndCheckFailure(Float.valueOf(2.0f), this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure(Float.valueOf(2.0f), this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure(Float.valueOf(2.0f), this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure(Float.valueOf(2.0f), this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure(Float.valueOf(2.0f), this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure(Float.valueOf(2.0f), this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testDouble() {
        this.putAndCheckValue(0.0, this.sql("this", "null"), SqlColumnType.DOUBLE, null, new Object[0]);
        this.putAndCheckValue(0.0, this.sql("null", "this"), SqlColumnType.DOUBLE, null, new Object[0]);
        this.checkFields(3.0, 2.0, SqlColumnType.DOUBLE, 1.5);
        this.checkError(3.0, 0.0, 2000, DivideOperatorIntegrationTest.divisionByZeroError());
        this.putAndCheckFailure(2.0, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure(2.0, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure(2.0, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue(3.0, this.sql("this", "?"), SqlColumnType.DOUBLE, 1.5, (byte)2);
        this.putAndCheckValue(3.0, this.sql("this", "?"), SqlColumnType.DOUBLE, 1.5, (short)2);
        this.putAndCheckValue(3.0, this.sql("this", "?"), SqlColumnType.DOUBLE, 1.5, 2);
        this.putAndCheckValue(3.0, this.sql("this", "?"), SqlColumnType.DOUBLE, 1.5, 2L);
        this.putAndCheckValue(3.0, this.sql("this", "?"), SqlColumnType.DOUBLE, 1.5, new BigInteger("2"));
        this.putAndCheckValue(3.0, this.sql("this", "?"), SqlColumnType.DOUBLE, 1.5, DivideOperatorIntegrationTest.decimal("2"));
        this.putAndCheckValue(3.0, this.sql("this", "?"), SqlColumnType.DOUBLE, 1.5, Float.valueOf(2.0f));
        this.putAndCheckValue(3.0, this.sql("this", "?"), SqlColumnType.DOUBLE, 1.5, 2.0);
        this.putAndCheckFailure(2.0, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure(2.0, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure(2.0, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure(2.0, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure(2.0, this.sql("this", "?"), 2000, DivideOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testTemporal() {
        this.checkUnsupportedForAllTypesCommute(LOCAL_DATE_VAL, SqlColumnType.DATE);
        this.checkUnsupportedForAllTypesCommute(LOCAL_TIME_VAL, SqlColumnType.TIME);
        this.checkUnsupportedForAllTypesCommute(LOCAL_DATE_TIME_VAL, SqlColumnType.TIMESTAMP);
        this.checkUnsupportedForAllTypesCommute(OFFSET_DATE_TIME_VAL, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE);
    }

    @Test
    public void testEquality() {
        DivideOperatorIntegrationTest.checkEquals(DivideFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), DivideFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), true);
        DivideOperatorIntegrationTest.checkEquals(DivideFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), DivideFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.BIGINT), false);
        DivideOperatorIntegrationTest.checkEquals(DivideFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), DivideFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)100, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), false);
    }

    @Test
    public void testSerialization() {
        DivideFunction original = DivideFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT);
        DivideFunction restored = (DivideFunction)DivideOperatorIntegrationTest.serializeAndCheck(original, 37);
        DivideOperatorIntegrationTest.checkEquals(original, restored, true);
    }

    private static String divisionByZeroError() {
        return "Division by zero";
    }

    private static String overflowError() {
        return "BIGINT overflow in '/' operator (consider adding explicit CAST to DECIMAL)";
    }
}

