/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.json;

import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonQueryEmptyOrErrorBehavior;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlJsonQueryWrapperBehavior;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class CalciteEnumStabilityTest {
    @Test
    public void test_SqlJsonQueryWrapperBehavior() throws Exception {
        this.compareActualValues(SqlJsonQueryWrapperBehavior.class, "WITHOUT_ARRAY", "WITH_CONDITIONAL_ARRAY", "WITH_UNCONDITIONAL_ARRAY");
    }

    @Test
    public void test_SqlJsonQueryEmptyOrErrorBehavior() throws Exception {
        this.compareActualValues(SqlJsonQueryEmptyOrErrorBehavior.class, "ERROR", "NULL", "EMPTY_ARRAY", "EMPTY_OBJECT");
    }

    private void compareActualValues(Class<? extends Enum<?>> enumClass, String ... expected) throws Exception {
        Enum[] actualValues = (Enum[])enumClass.getDeclaredMethod("values", new Class[0]).invoke(null, new Object[0]);
        List actualValuesStrings = Arrays.stream(actualValues).map(Enum::name).collect(Collectors.toList());
        Assert.assertEquals((Object)org.assertj.core.util.Arrays.asList((Object)expected), actualValuesStrings);
    }
}

