/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.datetime;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class ToTimestampTzIntegrationTest
extends ExpressionTestSupport {
    private static final Long SECONDS = 31536001L;
    private static final Long MILLISECONDS = SECONDS * 1000L;
    private static final Long MICROSECONDS = MILLISECONDS * 1000L;
    private static final Long NANOSECONDS = MICROSECONDS * 1000L;
    private static final Long MIN_NEGATIVE_SECONDS = LocalDateTime.of(-999999999, 1, 1, 0, 0).atZone(ZoneOffset.systemDefault()).toEpochSecond();

    @Test
    public void testColumn() {
        this.checkColumn((byte)1, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, this.fromEpoch(1L, ChronoUnit.SECONDS));
        this.checkColumn((short)1, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, this.fromEpoch(1L, ChronoUnit.SECONDS));
        this.checkColumn(1, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, this.fromEpoch(1L, ChronoUnit.SECONDS));
        this.checkColumn(1L, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, this.fromEpoch(1L, ChronoUnit.SECONDS));
        this.checkColumn(SECONDS, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, this.fromEpoch(SECONDS, ChronoUnit.SECONDS));
        this.checkColumn(MILLISECONDS, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, this.fromEpoch(MILLISECONDS, ChronoUnit.MILLIS));
        this.checkColumn(MICROSECONDS, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, this.fromEpoch(MICROSECONDS, ChronoUnit.MICROS));
        this.checkColumn(NANOSECONDS, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, this.fromEpoch(NANOSECONDS, ChronoUnit.NANOS));
        this.checkColumn(Long.MAX_VALUE, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, this.fromEpoch(Long.MAX_VALUE, ChronoUnit.NANOS));
        this.checkColumn(-MILLISECONDS.longValue(), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, this.fromEpoch(-MILLISECONDS.longValue(), ChronoUnit.SECONDS));
        this.checkColumn(-MICROSECONDS.longValue(), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, this.fromEpoch(-MICROSECONDS.longValue(), ChronoUnit.SECONDS));
        this.checkColumn(-NANOSECONDS.longValue(), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, this.fromEpoch(-NANOSECONDS.longValue(), ChronoUnit.SECONDS));
        this.checkColumn(MIN_NEGATIVE_SECONDS, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, this.fromEpoch(MIN_NEGATIVE_SECONDS, ChronoUnit.SECONDS));
        this.checkColumnFailure("'1'", 1008, ToTimestampTzIntegrationTest.signatureError(SqlColumnType.VARCHAR));
        this.checkColumnFailure(BigDecimal.valueOf(1.0), 1008, ToTimestampTzIntegrationTest.signatureError(SqlColumnType.DECIMAL));
        this.checkColumnFailure(BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.ONE), 1008, ToTimestampTzIntegrationTest.signatureError(SqlColumnType.DECIMAL));
        this.checkColumnFailure(BigDecimal.valueOf(Long.MIN_VALUE).subtract(BigDecimal.ONE), 1008, ToTimestampTzIntegrationTest.signatureError(SqlColumnType.DECIMAL));
        this.checkColumnFailure(1.0, 1008, ToTimestampTzIntegrationTest.signatureError(SqlColumnType.DOUBLE));
        this.checkColumnFailure(Float.valueOf(1.0f), 1008, ToTimestampTzIntegrationTest.signatureError(SqlColumnType.REAL));
        this.checkColumnFailure(true, 1008, ToTimestampTzIntegrationTest.signatureError(SqlColumnType.BOOLEAN));
        this.checkColumnFailure(LOCAL_DATE_TIME_VAL, 1008, ToTimestampTzIntegrationTest.signatureError(SqlColumnType.TIMESTAMP));
        this.checkColumnFailure(OFFSET_DATE_TIME_VAL, 1008, ToTimestampTzIntegrationTest.signatureError(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE));
        this.checkColumnFailure(LOCAL_DATE_VAL, 1008, ToTimestampTzIntegrationTest.signatureError(SqlColumnType.DATE));
        this.checkColumnFailure(LOCAL_TIME_VAL, 1008, ToTimestampTzIntegrationTest.signatureError(SqlColumnType.TIME));
        this.checkColumnFailure(OBJECT_VAL, 1008, ToTimestampTzIntegrationTest.signatureError(SqlColumnType.OBJECT));
    }

    @Test
    public void testNull() {
        this.put(0);
        this.check("null", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, null, new Object[0]);
    }

    @Test
    public void testLiteral() {
        this.put(0);
        this.checkLiteral(1L, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, this.fromEpoch(1L, ChronoUnit.SECONDS));
        this.checkLiteral(SECONDS, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, this.fromEpoch(SECONDS, ChronoUnit.SECONDS));
        this.checkLiteral(MILLISECONDS, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, this.fromEpoch(MILLISECONDS, ChronoUnit.MILLIS));
        this.checkLiteral(MICROSECONDS, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, this.fromEpoch(MICROSECONDS, ChronoUnit.MICROS));
        this.checkLiteral(NANOSECONDS, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, this.fromEpoch(NANOSECONDS, ChronoUnit.NANOS));
        this.checkLiteral("-10000", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, this.fromEpoch(-10000L, ChronoUnit.SECONDS));
        this.checkLiteral("0", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, this.fromEpoch(0L, ChronoUnit.SECONDS));
        this.checkLiteral("9223372036854775807", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, this.fromEpoch(Long.MAX_VALUE, ChronoUnit.NANOS));
        this.checkLiteral("null", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, null);
        this.checkLiteral(-MILLISECONDS.longValue(), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, this.fromEpoch(-MILLISECONDS.longValue(), ChronoUnit.SECONDS));
        this.checkLiteral(-MICROSECONDS.longValue(), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, this.fromEpoch(-MICROSECONDS.longValue(), ChronoUnit.SECONDS));
        this.checkLiteral(-NANOSECONDS.longValue(), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, this.fromEpoch(-NANOSECONDS.longValue(), ChronoUnit.SECONDS));
        this.checkLiteral(MIN_NEGATIVE_SECONDS, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, this.fromEpoch(MIN_NEGATIVE_SECONDS, ChronoUnit.SECONDS));
        this.checkFailure("'1'", 1008, ToTimestampTzIntegrationTest.signatureError(SqlColumnType.VARCHAR), new Object[0]);
        this.checkFailure("1.0", 1008, ToTimestampTzIntegrationTest.signatureError(SqlColumnType.DECIMAL), new Object[0]);
        this.checkFailure("9223372036854775808", 1008, ToTimestampTzIntegrationTest.signatureError(SqlColumnType.DECIMAL), new Object[0]);
        this.checkFailure("-9223372036854775809", 1008, ToTimestampTzIntegrationTest.signatureError(SqlColumnType.DECIMAL), new Object[0]);
    }

    @Test
    public void testParameter() {
        this.put(0);
        this.checkParameter(1L, this.fromEpoch(1L, ChronoUnit.SECONDS));
        this.checkParameter(SECONDS, this.fromEpoch(SECONDS, ChronoUnit.SECONDS));
        this.checkParameter(MILLISECONDS, this.fromEpoch(MILLISECONDS, ChronoUnit.MILLIS));
        this.checkParameter(MICROSECONDS, this.fromEpoch(MICROSECONDS, ChronoUnit.MICROS));
        this.checkParameter(NANOSECONDS, this.fromEpoch(NANOSECONDS, ChronoUnit.NANOS));
        this.checkParameter(Long.MAX_VALUE, this.fromEpoch(Long.MAX_VALUE, ChronoUnit.NANOS));
        this.checkParameter(null, null);
        this.checkParameter(-MILLISECONDS.longValue(), this.fromEpoch(-MILLISECONDS.longValue(), ChronoUnit.SECONDS));
        this.checkParameter(-MICROSECONDS.longValue(), this.fromEpoch(-MICROSECONDS.longValue(), ChronoUnit.SECONDS));
        this.checkParameter(-NANOSECONDS.longValue(), this.fromEpoch(-NANOSECONDS.longValue(), ChronoUnit.SECONDS));
        this.checkParameter(MIN_NEGATIVE_SECONDS, this.fromEpoch(MIN_NEGATIVE_SECONDS, ChronoUnit.SECONDS));
        this.checkFailure("?", 2000, ToTimestampTzIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), "foo");
        this.checkFailure("?", 2000, ToTimestampTzIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.BOOLEAN), true);
        this.checkFailure("?", 2000, ToTimestampTzIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BigInteger.ZERO);
        this.checkFailure("?", 2000, ToTimestampTzIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BigDecimal.ZERO);
        this.checkFailure("?", 2000, ToTimestampTzIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.REAL), Float.valueOf(0.0f));
        this.checkFailure("?", 2000, ToTimestampTzIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DOUBLE), 0.0);
        this.checkFailure("?", 2000, ToTimestampTzIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.checkFailure("?", 2000, ToTimestampTzIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.checkFailure("?", 2000, ToTimestampTzIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.checkFailure("?", 2000, ToTimestampTzIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.checkFailure("?", 2000, ToTimestampTzIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    private OffsetDateTime fromEpoch(Long timestamp, TemporalUnit unit) {
        Instant instant = Instant.EPOCH.plus((long)timestamp, unit);
        return OffsetDateTime.from(instant.atZone(ZoneOffset.systemDefault()));
    }

    private void checkColumn(Object value, SqlColumnType expectedType, Object expectedResult) {
        this.put(value);
        this.check("this", expectedType, expectedResult, new Object[0]);
    }

    private void checkParameter(Object parameterValue, Object expectedValue) {
        this.check("?", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, expectedValue, parameterValue);
    }

    private void checkLiteral(Object literal, SqlColumnType expectedType, Object expectedValue) {
        this.check(literal.toString(), expectedType, expectedValue, new Object[0]);
    }

    private void checkFailure(Object operand, int expectedErrorCode, String expectedErrorMessage, Object ... params) {
        String sql = "SELECT TO_TIMESTAMP_TZ(" + String.valueOf(operand) + ") FROM map";
        this.checkFailure0(sql, expectedErrorCode, expectedErrorMessage, params);
    }

    private void checkColumnFailure(Object value, int expectedErrorCode, String expectedErrorMessage) {
        this.put(value);
        this.checkFailure("this", expectedErrorCode, expectedErrorMessage, new Object[0]);
    }

    private void check(Object operand, SqlColumnType expectedType, Object expectedValue, Object ... params) {
        String sql = "SELECT TO_TIMESTAMP_TZ(" + String.valueOf(operand) + ") FROM map";
        this.checkValue0(sql, expectedType, expectedValue, params);
    }

    private static String signatureError(SqlColumnType type) {
        return ToTimestampTzIntegrationTest.signatureErrorFunction("TO_TIMESTAMP_TZ", type);
    }
}

