/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.datetime;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.util.HashMap;
import java.util.Map;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class ToCharIntegrationTest
extends ExpressionTestSupport {
    private static Map<Class<? extends Temporal>, DateTimeFormatter> literals;

    @BeforeClass
    public static void setup() {
        literals = new HashMap<Class<? extends Temporal>, DateTimeFormatter>();
        literals.put(LocalDate.class, DateTimeFormatter.ofPattern("'DATE' ''yyyy-MM-dd''"));
        literals.put(LocalTime.class, DateTimeFormatter.ofPattern("'TIME' ''HH:mm:ss''"));
        literals.put(LocalDateTime.class, DateTimeFormatter.ofPattern("'TIMESTAMP' ''yyyy-MM-dd HH:mm:ss''"));
        literals.put(OffsetDateTime.class, DateTimeFormatter.ofPattern("'TIMESTAMP WITH TIME ZONE' ''yyyy-MM-dd HH:mm:ssx''"));
    }

    @Test
    public void testTemporals() {
        this.check(LocalDate.of(2022, 9, 26), "FMDay, Mon FMDDth, FMYYYY", "Monday, Sep 26th, 2022");
        this.check(LocalDate.of(2022, 9, 26), "FMDD FMMonth FMYYYY", "tr-TR", "26 Eyl\u00fcl 2022");
        this.check(LocalTime.of(14, 53, 34), "FMHH:MI:SS AM", "2:53:34 PM");
        this.check(LocalDateTime.of(2022, 9, 26, 14, 53), "FMDay, Mon FMDDth, HH24:MI", "Monday, Sep 26th, 14:53");
    }

    @Test
    public void testNumbers() {
        this.check((byte)-128, "999", "-128");
        this.check((short)Short.MIN_VALUE, "99999", "-32768");
        this.check(Integer.MIN_VALUE, "9999999999", "-2147483648");
        this.check(Long.MIN_VALUE, "9999999999999999999", "-9223372036854775808");
        this.check(Float.valueOf(-3.4028235E38f), "9.9999999EEEE", "-3.4028235E+38");
        this.check(-1.7976931348623157E308, "9.9999999999999999EEEE", "-1.7976931348623157E+308");
        this.check(Float.valueOf(-3.4E38f), "9.9EEEE", "-3.4E+38");
        this.check(-3.5E38, "9.9EEEE", "-3.5E+38");
        this.check(new BigInteger("-9223372036854775809"), "9999999999999999999", "-9223372036854775809");
        this.check(new BigDecimal("-1.23456789012345678901234567890123456789012345678901234"), "9.99999999999999999999999999999999999999999999999999999", "-1.23456789012345678901234567890123456789012345678901234");
        this.check(new BigDecimal("-3.4e+38"), "9.9EEEE", "-3.4E+38");
        this.check(new BigDecimal("-3.5e+38"), "9.9EEEE", "-3.5E+38");
    }

    private void check(Object input, String format, String result) {
        this.check(input, format, null, result);
    }

    private void check(Object input, String format, String locale, String result) {
        String rest = "'" + format + "'" + (String)(locale == null ? "" : ", '" + locale + "'");
        this.putAndCheckValue(input, "SELECT TO_CHAR(this, " + rest + ") FROM map", SqlColumnType.VARCHAR, result, new Object[0]);
        input = input instanceof Temporal ? literals.get(input.getClass()).format((Temporal)input) : input.toString();
        this.checkValue0("SELECT TO_CHAR(" + String.valueOf(input) + ", " + rest + ")", SqlColumnType.VARCHAR, result, new Object[0]);
    }
}

