/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression;

import com.hazelcast.jet.sql.impl.validate.literal.Literal;
import com.hazelcast.jet.sql.impl.validate.literal.LiteralUtils;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlLiteral;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class LiteralTypeResolutionTest {
    @Test
    public void testNull() {
        this.checkLiteral(SqlLiteral.createNull((SqlParserPos)SqlParserPos.ZERO), null, null, SqlTypeName.NULL, true);
    }

    @Test
    public void testVarchar() {
        this.checkLiteral((SqlLiteral)SqlLiteral.createCharString((String)"foo", (SqlParserPos)SqlParserPos.ZERO), "foo", "foo", SqlTypeName.VARCHAR, false);
    }

    @Test
    public void testBoolean() {
        this.checkLiteral(SqlLiteral.createBoolean((boolean)true, (SqlParserPos)SqlParserPos.ZERO), true, "true", SqlTypeName.BOOLEAN, false);
        this.checkLiteral(SqlLiteral.createBoolean((boolean)false, (SqlParserPos)SqlParserPos.ZERO), false, "false", SqlTypeName.BOOLEAN, false);
        this.checkLiteral(SqlLiteral.createUnknown((SqlParserPos)SqlParserPos.ZERO), null, null, SqlTypeName.BOOLEAN, true);
    }

    @Test
    public void testInteger() {
        this.checkLiteral(LiteralTypeResolutionTest.exactNumeric(1), (byte)1, "1", SqlTypeName.TINYINT, false);
        this.checkLiteral(LiteralTypeResolutionTest.exactNumeric((byte)127), (byte)127, (byte)127, SqlTypeName.TINYINT, false);
        this.checkLiteral(LiteralTypeResolutionTest.exactNumeric((byte)-128), (byte)-128, (byte)-128, SqlTypeName.TINYINT, false);
        this.checkLiteral(LiteralTypeResolutionTest.exactNumeric((short)Short.MAX_VALUE), (short)Short.MAX_VALUE, (short)Short.MAX_VALUE, SqlTypeName.SMALLINT, false);
        this.checkLiteral(LiteralTypeResolutionTest.exactNumeric((short)Short.MIN_VALUE), (short)Short.MIN_VALUE, (short)Short.MIN_VALUE, SqlTypeName.SMALLINT, false);
        this.checkLiteral(LiteralTypeResolutionTest.exactNumeric(Integer.MAX_VALUE), Integer.MAX_VALUE, Integer.MAX_VALUE, SqlTypeName.INTEGER, false);
        this.checkLiteral(LiteralTypeResolutionTest.exactNumeric(Integer.MIN_VALUE), Integer.MIN_VALUE, Integer.MIN_VALUE, SqlTypeName.INTEGER, false);
        this.checkLiteral(LiteralTypeResolutionTest.exactNumeric(Long.MAX_VALUE), Long.MAX_VALUE, Long.MAX_VALUE, SqlTypeName.BIGINT, false);
        this.checkLiteral(LiteralTypeResolutionTest.exactNumeric(Long.MIN_VALUE), Long.MIN_VALUE, Long.MIN_VALUE, SqlTypeName.BIGINT, false);
        this.checkLiteral(LiteralTypeResolutionTest.exactNumeric("1.1"), new BigDecimal("1.1"), "1.1", SqlTypeName.DECIMAL, false);
        this.checkLiteral(LiteralTypeResolutionTest.exactNumeric("92233720368547758070"), new BigDecimal("92233720368547758070"), "92233720368547758070", SqlTypeName.DECIMAL, false);
        this.checkLiteral(LiteralTypeResolutionTest.exactNumeric("-92233720368547758080"), new BigDecimal("-92233720368547758080"), "-92233720368547758080", SqlTypeName.DECIMAL, false);
    }

    @Test
    public void testApproxNumeric() {
        this.checkLiteral((SqlLiteral)SqlLiteral.createApproxNumeric((String)"1.1E1", (SqlParserPos)SqlParserPos.ZERO), 11.0, "1.1E1", SqlTypeName.DOUBLE, false);
    }

    @Test
    public void testDecimal() {
        BigDecimal maxPlusOne = BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.ONE);
        this.checkLiteral(LiteralTypeResolutionTest.exactNumeric(maxPlusOne), maxPlusOne, maxPlusOne, SqlTypeName.DECIMAL, false);
    }

    private void checkLiteral(SqlLiteral literal, Object expectedValue, Object expectedStringValue, SqlTypeName expectedTypeName, boolean expectedNullable) {
        String expectedStringValue0 = expectedStringValue != null ? expectedStringValue.toString() : null;
        Literal literal0 = LiteralUtils.literal((SqlNode)literal);
        Assert.assertNotNull((Object)literal0);
        Assert.assertEquals((Object)expectedValue, (Object)literal0.getValue());
        Assert.assertEquals((Object)expectedStringValue0, (Object)literal0.getStringValue());
        Assert.assertEquals((Object)expectedTypeName, (Object)literal0.getTypeName());
        Assert.assertEquals((Object)expectedTypeName, (Object)literal0.getType(HazelcastTypeFactory.INSTANCE).getSqlTypeName());
        Assert.assertEquals((Object)expectedNullable, (Object)literal0.getType(HazelcastTypeFactory.INSTANCE).isNullable());
        Assert.assertEquals((Object)expectedTypeName, (Object)LiteralUtils.literalTypeName((SqlNode)literal));
        RelDataType type = LiteralUtils.literalType((SqlNode)literal, (HazelcastTypeFactory)HazelcastTypeFactory.INSTANCE);
        Assert.assertNotNull((Object)type);
        Assert.assertEquals((Object)expectedTypeName, (Object)type.getSqlTypeName());
        Assert.assertEquals((Object)expectedNullable, (Object)type.isNullable());
    }

    private static SqlLiteral exactNumeric(Object value) {
        return SqlLiteral.createExactNumeric((String)value.toString(), (SqlParserPos)SqlParserPos.ZERO);
    }
}

