/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map.index;

import com.hazelcast.config.Config;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.IndexType;
import com.hazelcast.jet.sql.impl.opt.OptimizerTestSupport;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.FullScanPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.IndexScanMapPhysicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionType;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionTypes;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionValue;
import com.hazelcast.map.IMap;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.schema.map.MapTableUtils;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.util.Arrays;
import java.util.List;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlIndexCastTest
extends OptimizerTestSupport {
    private static final String MAP_NAME = "map";

    @BeforeClass
    public static void beforeClass() {
        SqlIndexCastTest.initialize((int)1, (Config)SqlIndexCastTest.smallInstanceConfig());
    }

    @Before
    public void before() {
        IndexConfig indexConfig = new IndexConfig().setName("index").setType(IndexType.HASH).addAttribute("field1");
        SqlIndexCastTest.instance().getMap(MAP_NAME).addIndex(indexConfig);
    }

    @Test
    public void test_tinyint() {
        this.check(ExpressionTypes.BYTE, QueryDataTypeFamily.TINYINT, true);
        this.check(ExpressionTypes.BYTE, QueryDataTypeFamily.SMALLINT, true);
        this.check(ExpressionTypes.BYTE, QueryDataTypeFamily.INTEGER, true);
        this.check(ExpressionTypes.BYTE, QueryDataTypeFamily.BIGINT, true);
        this.check(ExpressionTypes.BYTE, QueryDataTypeFamily.DECIMAL, true);
        this.check(ExpressionTypes.BYTE, QueryDataTypeFamily.REAL, true);
        this.check(ExpressionTypes.BYTE, QueryDataTypeFamily.DOUBLE, true);
    }

    @Test
    public void test_smallint() {
        this.check(ExpressionTypes.SHORT, QueryDataTypeFamily.TINYINT, false);
        this.check(ExpressionTypes.SHORT, QueryDataTypeFamily.SMALLINT, true);
        this.check(ExpressionTypes.SHORT, QueryDataTypeFamily.INTEGER, true);
        this.check(ExpressionTypes.SHORT, QueryDataTypeFamily.BIGINT, true);
        this.check(ExpressionTypes.SHORT, QueryDataTypeFamily.DECIMAL, true);
        this.check(ExpressionTypes.SHORT, QueryDataTypeFamily.REAL, true);
        this.check(ExpressionTypes.SHORT, QueryDataTypeFamily.DOUBLE, true);
    }

    @Test
    public void test_integer() {
        this.check(ExpressionTypes.INTEGER, QueryDataTypeFamily.TINYINT, false);
        this.check(ExpressionTypes.INTEGER, QueryDataTypeFamily.SMALLINT, false);
        this.check(ExpressionTypes.INTEGER, QueryDataTypeFamily.INTEGER, true);
        this.check(ExpressionTypes.INTEGER, QueryDataTypeFamily.BIGINT, true);
        this.check(ExpressionTypes.INTEGER, QueryDataTypeFamily.DECIMAL, true);
        this.check(ExpressionTypes.INTEGER, QueryDataTypeFamily.REAL, true);
        this.check(ExpressionTypes.INTEGER, QueryDataTypeFamily.DOUBLE, true);
    }

    @Test
    public void test_bigint() {
        this.check(ExpressionTypes.LONG, QueryDataTypeFamily.TINYINT, false);
        this.check(ExpressionTypes.LONG, QueryDataTypeFamily.SMALLINT, false);
        this.check(ExpressionTypes.LONG, QueryDataTypeFamily.INTEGER, false);
        this.check(ExpressionTypes.LONG, QueryDataTypeFamily.BIGINT, true);
        this.check(ExpressionTypes.LONG, QueryDataTypeFamily.DECIMAL, true);
        this.check(ExpressionTypes.LONG, QueryDataTypeFamily.REAL, true);
        this.check(ExpressionTypes.LONG, QueryDataTypeFamily.DOUBLE, true);
    }

    @Test
    public void test_decimal() {
        this.check(ExpressionTypes.BIG_DECIMAL, QueryDataTypeFamily.TINYINT, false);
        this.check(ExpressionTypes.BIG_DECIMAL, QueryDataTypeFamily.SMALLINT, false);
        this.check(ExpressionTypes.BIG_DECIMAL, QueryDataTypeFamily.INTEGER, false);
        this.check(ExpressionTypes.BIG_DECIMAL, QueryDataTypeFamily.BIGINT, false);
        this.check(ExpressionTypes.BIG_DECIMAL, QueryDataTypeFamily.DECIMAL, true);
        this.check(ExpressionTypes.BIG_DECIMAL, QueryDataTypeFamily.REAL, true);
        this.check(ExpressionTypes.BIG_DECIMAL, QueryDataTypeFamily.DOUBLE, true);
    }

    @Test
    public void test_real() {
        this.check(ExpressionTypes.FLOAT, QueryDataTypeFamily.TINYINT, false);
        this.check(ExpressionTypes.FLOAT, QueryDataTypeFamily.SMALLINT, false);
        this.check(ExpressionTypes.FLOAT, QueryDataTypeFamily.INTEGER, false);
        this.check(ExpressionTypes.FLOAT, QueryDataTypeFamily.BIGINT, false);
        this.check(ExpressionTypes.FLOAT, QueryDataTypeFamily.DECIMAL, false);
        this.check(ExpressionTypes.FLOAT, QueryDataTypeFamily.REAL, true);
        this.check(ExpressionTypes.FLOAT, QueryDataTypeFamily.DOUBLE, true);
    }

    @Test
    public void test_double() {
        this.check(ExpressionTypes.DOUBLE, QueryDataTypeFamily.TINYINT, false);
        this.check(ExpressionTypes.DOUBLE, QueryDataTypeFamily.SMALLINT, false);
        this.check(ExpressionTypes.DOUBLE, QueryDataTypeFamily.INTEGER, false);
        this.check(ExpressionTypes.DOUBLE, QueryDataTypeFamily.BIGINT, false);
        this.check(ExpressionTypes.DOUBLE, QueryDataTypeFamily.DECIMAL, false);
        this.check(ExpressionTypes.DOUBLE, QueryDataTypeFamily.REAL, false);
        this.check(ExpressionTypes.DOUBLE, QueryDataTypeFamily.DOUBLE, true);
    }

    private void check(ExpressionType<?> typeFrom, QueryDataTypeFamily typeTo, boolean expectedIndexUsage) {
        IMap map = SqlIndexCastTest.instance().getMap(MAP_NAME);
        Class<? extends ExpressionValue> valueClass = ExpressionValue.createClass(typeFrom);
        ExpressionValue value = ((ExpressionValue)ExpressionValue.create(valueClass)).field1(typeFrom.valueFrom());
        map.put(0, value);
        this.checkComparison(typeFrom, typeTo, expectedIndexUsage);
        this.checkIsNull(typeFrom, typeTo, expectedIndexUsage);
    }

    private void checkComparison(ExpressionType<?> typeFrom, QueryDataTypeFamily typeTo, boolean expectedIndexUsage) {
        String sql = "SELECT field1 FROM map WHERE CAST(field1 AS " + String.valueOf(typeTo) + ") = CAST(? as " + String.valueOf(typeTo) + ")";
        SqlStatement statement = new SqlStatement(sql).addParameter(null);
        this.checkIndexUsage(statement, typeFrom, expectedIndexUsage);
    }

    private void checkIsNull(ExpressionType<?> typeFrom, QueryDataTypeFamily typeTo, boolean expectedIndexUsage) {
        String sql = "SELECT field1 FROM map WHERE CAST(field1 AS " + String.valueOf(typeTo) + ") IS NULL";
        this.checkIndexUsage(new SqlStatement(sql), typeFrom, expectedIndexUsage);
    }

    private void checkIndexUsage(SqlStatement statement, ExpressionType<?> field, boolean expectedIndexUsage) {
        List<QueryDataType> parameterTypes = Arrays.asList(QueryDataType.INT, field.getFieldConverterType());
        List<TableField> mapTableFields = Arrays.asList(new MapTableField("__key", QueryDataType.INT, false, QueryPath.KEY_PATH), new MapTableField("field1", field.getFieldConverterType(), false, new QueryPath("field1", false)));
        HazelcastTable table = SqlIndexCastTest.partitionedTable(MAP_NAME, mapTableFields, MapTableUtils.getPartitionedMapIndexes((MapContainer)SqlIndexCastTest.mapContainer(SqlIndexCastTest.instance().getMap(MAP_NAME)), mapTableFields), 1L);
        OptimizerTestSupport.Result optimizationResult = this.optimizePhysical(statement.getSql(), parameterTypes, table);
        SqlIndexCastTest.assertPlan((RelNode)optimizationResult.getLogical(), SqlIndexCastTest.plan(SqlIndexCastTest.planRow(0, FullScanLogicalRel.class)));
        SqlIndexCastTest.assertPlan((RelNode)optimizationResult.getPhysical(), SqlIndexCastTest.plan(SqlIndexCastTest.planRow(0, expectedIndexUsage ? IndexScanMapPhysicalRel.class : FullScanPhysicalRel.class)));
    }
}

