/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map.index;

import com.hazelcast.config.Config;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.IndexType;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.map.IMap;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.ArrayList;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={QuickTest.class, ParallelJVMTest.class})
public class MapSortedIndexScanIntegrationTest
extends SqlTestSupport {
    private static final int ITEM_COUNT = 10000;
    private static final String MAP_NAME = "map";
    private IMap<Integer, Integer> map;

    @BeforeClass
    public static void beforeClass() {
        MapSortedIndexScanIntegrationTest.initialize((int)3, (Config)MapSortedIndexScanIntegrationTest.smallInstanceConfig());
    }

    @Before
    public void before() {
        MapSortedIndexScanIntegrationTest.createMapping(MAP_NAME, Integer.TYPE, Integer.TYPE);
        this.map = MapSortedIndexScanIntegrationTest.instance().getMap(MAP_NAME);
    }

    @Test
    public void test_sorted() {
        ArrayList<SqlTestSupport.Row> expected = new ArrayList<SqlTestSupport.Row>();
        for (int i = 0; i <= 10000; ++i) {
            this.map.put((Object)i, (Object)i);
            expected.add(new SqlTestSupport.Row(10000 - i, 10000 - i));
        }
        IndexConfig indexConfig = new IndexConfig(IndexType.SORTED, new String[]{"this"}).setName(MapSortedIndexScanIntegrationTest.randomName());
        this.map.addIndex(indexConfig);
        for (int i = 0; i < 5; ++i) {
            MapSortedIndexScanIntegrationTest.assertRowsOrdered("SELECT * FROM map ORDER BY this DESC", expected);
        }
    }
}

