/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.jet.core.TestUtil;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.map.IMapSqlConnector;
import com.hazelcast.jet.sql.impl.connector.map.model.AllTypesValue;
import com.hazelcast.jet.sql.impl.connector.map.model.InsuredPerson;
import com.hazelcast.jet.sql.impl.connector.map.model.Person;
import com.hazelcast.jet.sql.impl.connector.map.model.PersonId;
import com.hazelcast.jet.sql.impl.connector.test.TestAllTypesSqlConnector;
import com.hazelcast.map.IMap;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.impl.schema.Mapping;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlPojoTest
extends SqlTestSupport {
    private static SqlService sqlService;

    @BeforeClass
    public static void setup() {
        SqlPojoTest.initialize((int)1, null);
        sqlService = SqlPojoTest.instance().getSql();
    }

    private static SqlTestSupport.SqlMapping javaMapping(String name, Class<?> keyClass, Class<?> valueClass) {
        return (SqlTestSupport.SqlMapping)new SqlTestSupport.SqlMapping(name, IMapSqlConnector.class).options(new Object[]{"keyFormat", "java", "keyJavaClass", keyClass.getName(), "valueFormat", "java", "valueJavaClass", valueClass.getName()});
    }

    @Test
    public void test_nulls() {
        String name = SqlPojoTest.randomName();
        SqlPojoTest.javaMapping(name, PersonId.class, Person.class).create();
        SqlPojoTest.assertMapEventually(name, "SINK INTO " + name + " VALUES (1, null)", TestUtil.createMap((Object[])new Object[]{new PersonId(1), new Person()}));
        SqlPojoTest.assertRowsAnyOrder("SELECT * FROM " + name, List.of(new SqlTestSupport.Row(1, null)));
    }

    @Test
    public void when_nullIntoPrimitive_then_fails() {
        String name = SqlPojoTest.randomName();
        SqlPojoTest.javaMapping(name, PersonId.class, Person.class).create();
        Assertions.assertThatThrownBy(() -> sqlService.execute("SINK INTO " + name + " VALUES (null, 'Alice')", new Object[0])).hasMessageContaining("Cannot pass NULL to a method with a primitive argument");
    }

    @Test
    public void when_wrongClass_then_canDrop() {
        String name = SqlPojoTest.randomName();
        SqlPojoTest.createBrokenMapping(name);
        IMap catalog = SqlPojoTest.instance().getMap("__sql.catalog");
        Assertions.assertThat((boolean)catalog.containsKey((Object)name)).isTrue();
        sqlService.execute("DROP MAPPING " + name, new Object[0]);
        Assertions.assertThat((boolean)catalog.containsKey((Object)name)).isFalse();
    }

    @Test
    public void when_wrongClass_then_canNotQueryTable() {
        String badName = SqlPojoTest.randomName();
        SqlPojoTest.createBrokenMapping(badName);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM " + badName, new Object[0])).hasMessage("Mapping '%s' is invalid: com.hazelcast.sql.impl.QueryException: Unable to load class 'com.hazelcast.NoSuchClass'", new Object[]{badName});
    }

    @Test
    public void when_wrongClass_then_canQueryOtherTables() {
        String badName = SqlPojoTest.randomName();
        String goodName = SqlPojoTest.randomName();
        SqlPojoTest.createBrokenMapping(badName);
        SqlPojoTest.javaMapping(goodName, PersonId.class, Person.class).create();
        Assertions.assertThat((Iterable)sqlService.execute("SELECT * FROM " + goodName, new Object[0])).hasSize(0);
    }

    private static void createBrokenMapping(String name) {
        SqlPojoTest.javaMapping(name, PersonId.class, Person.class).create();
        IMap catalog = SqlPojoTest.instance().getMap("__sql.catalog");
        Mapping m = (Mapping)catalog.get((Object)name);
        HashMap<String, String> brokenOptions = new HashMap<String, String>(m.options());
        brokenOptions.put("valueJavaClass", "com.hazelcast.NoSuchClass");
        catalog.put((Object)name, (Object)new Mapping(m.name(), m.externalName(), null, m.connectorType(), null, new ArrayList(m.fields()), brokenOptions));
    }

    @Test
    public void test_fieldsShadowing() {
        String name = SqlPojoTest.randomName();
        SqlPojoTest.javaMapping(name, PersonId.class, Person.class).create();
        SqlPojoTest.assertMapEventually(name, "SINK INTO " + name + " (id, name) VALUES (1, 'Alice')", TestUtil.createMap((Object[])new Object[]{new PersonId(1), new Person(null, "Alice")}));
        SqlPojoTest.assertRowsAnyOrder("SELECT * FROM " + name, List.of(new SqlTestSupport.Row(1, "Alice")));
    }

    @Test
    public void test_fieldsMapping() {
        String name = SqlPojoTest.randomName();
        ((SqlTestSupport.SqlMapping)SqlPojoTest.javaMapping(name, PersonId.class, Person.class).fields(new String[]{"key_id INT EXTERNAL NAME \"__key.id\"", "value_id INT EXTERNAL NAME \"this.id\"", "name VARCHAR"})).create();
        SqlPojoTest.assertMapEventually(name, "SINK INTO " + name + " (value_id, key_id, name) VALUES (2, 1, 'Alice')", TestUtil.createMap((Object[])new Object[]{new PersonId(1), new Person(2, "Alice")}));
        SqlPojoTest.assertRowsAnyOrder("SELECT key_id, value_id, name FROM " + name, List.of(new SqlTestSupport.Row(1, 2, "Alice")));
    }

    @Test
    public void test_schemaEvolution() {
        String name = SqlPojoTest.randomName();
        SqlPojoTest.javaMapping(name, PersonId.class, Person.class).create();
        sqlService.execute("SINK INTO " + name + " VALUES (1, 'Alice')", new Object[0]);
        SqlPojoTest.javaMapping(name, PersonId.class, InsuredPerson.class).createOrReplace();
        sqlService.execute("SINK INTO " + name + " (id, name, ssn) VALUES (2, 'Bob', 123456789)", new Object[0]);
        SqlPojoTest.assertRowsAnyOrder("SELECT id, name, ssn FROM " + name, List.of(new SqlTestSupport.Row(1, "Alice", null), new SqlTestSupport.Row(2, "Bob", 123456789L)));
    }

    @Test
    public void test_fieldsExtensions() {
        String name = SqlPojoTest.randomName();
        IMap map = SqlPojoTest.instance().getMap(name);
        map.put(new PersonId(1), new InsuredPerson(1, "Alice", 123456789L));
        ((SqlTestSupport.SqlMapping)SqlPojoTest.javaMapping(name, PersonId.class, Person.class).fields(new String[]{"id INT EXTERNAL NAME \"__key.id\"", "name VARCHAR", "ssn BIGINT"})).create();
        SqlPojoTest.assertMapEventually(name, "SINK INTO " + name + " (id, name, ssn) VALUES (2, 'Bob', null)", TestUtil.createMap((Object[])new Object[]{new PersonId(1), new InsuredPerson(1, "Alice", 123456789L), new PersonId(2), new Person(null, "Bob")}));
        SqlPojoTest.assertRowsAnyOrder("SELECT * FROM " + name, List.of(new SqlTestSupport.Row(1, "Alice", 123456789L), new SqlTestSupport.Row(2, "Bob", null)));
    }

    @Test
    public void test_allTypes() {
        String from = SqlPojoTest.randomName();
        TestAllTypesSqlConnector.create(sqlService, from);
        String to = SqlPojoTest.randomName();
        SqlPojoTest.javaMapping(to, BigInteger.class, AllTypesValue.class).create();
        SqlPojoTest.assertMapEventually(to, "SINK INTO " + to + " (__key, string, character0, boolean0, byte0, short0, int0, long0, float0, double0, bigDecimal, bigInteger, \"localTime\", localDate, localDateTime, \"date\", calendar, instant, zonedDateTime, offsetDateTime, map, object) SELECT CAST(1 AS DECIMAL), string, SUBSTRING(string, 1, 1), \"boolean\", byte, short, \"int\", long, \"float\", \"double\", \"decimal\", \"decimal\", \"time\", \"date\", \"timestamp\", \"timestampTz\", \"timestampTz\", \"timestampTz\", \"timestampTz\", \"timestampTz\", map, object FROM " + from, TestUtil.createMap((Object[])new Object[]{BigInteger.valueOf(1L), AllTypesValue.testValue()}));
        SqlPojoTest.assertRowsAnyOrder("SELECT __key, string, character0, boolean0, byte0, short0, int0, long0, bigDecimal, bigInteger, float0, double0, \"localTime\", localDate, localDateTime, \"date\", calendar, instant, zonedDateTime, offsetDateTime , map, object FROM " + to, List.of(new SqlTestSupport.Row(BigDecimal.valueOf(1L), "string", "s", true, (byte)127, (short)Short.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE, new BigDecimal("9223372036854775.123"), new BigDecimal("9223372036854775"), Float.valueOf(1.234568E9f), 1.234512345678901E14, LocalTime.of(12, 23, 34), LocalDate.of(2020, 4, 15), LocalDateTime.of(2020, 4, 15, 12, 23, 34, 1000000), OffsetDateTime.ofInstant(Date.from(Instant.ofEpochMilli(1586953414200L)).toInstant(), ZoneId.systemDefault()), OffsetDateTime.of(2020, 4, 15, 12, 23, 34, 200000000, ZoneOffset.UTC), OffsetDateTime.ofInstant(Instant.ofEpochMilli(1586953414200L), ZoneId.systemDefault()), OffsetDateTime.of(2020, 4, 15, 12, 23, 34, 200000000, ZoneOffset.UTC), OffsetDateTime.of(2020, 4, 15, 12, 23, 34, 200000000, ZoneOffset.UTC), Map.of(42, 43), null)));
    }

    @Test
    public void when_fieldWithInitialValueUnmapped_then_initialValuePreserved() {
        String mapName = SqlPojoTest.randomName();
        ((SqlTestSupport.SqlMapping)SqlPojoTest.javaMapping(mapName, Integer.class, ClassInitialValue.class).fields(new String[]{"__key INT"})).create();
        sqlService.execute("SINK INTO " + mapName + "(__key) VALUES (1)", new Object[0]);
        ClassInitialValue val = (ClassInitialValue)SqlPojoTest.instance().getMap(mapName).get((Object)1);
        Assert.assertEquals((Object)42, (Object)val.field);
    }

    @Test
    public void when_fieldWithInitialValueNotUsed_then_valueOverwritten() {
        String mapName = SqlPojoTest.randomName();
        SqlPojoTest.javaMapping(mapName, Integer.class, ClassInitialValue.class).create();
        sqlService.execute("SINK INTO " + mapName + "(__key) VALUES (1)", new Object[0]);
        SqlPojoTest.assertRowsAnyOrder("SELECT * FROM " + mapName, List.of(new SqlTestSupport.Row(1, null)));
    }

    @Test
    public void when_fieldWithInitialValueAssignedNull_then_isNull() {
        String mapName = SqlPojoTest.randomName();
        SqlPojoTest.javaMapping(mapName, Integer.class, ClassInitialValue.class).create();
        sqlService.execute("SINK INTO " + mapName + "(__key, field) VALUES (1, null)", new Object[0]);
        SqlPojoTest.assertRowsAnyOrder("SELECT * FROM " + mapName, List.of(new SqlTestSupport.Row(1, null)));
    }

    @Test
    public void test_writingToTopLevelWhileNestedFieldMapped_explicit() {
        this.test_writingToTopLevel(true);
    }

    @Test
    public void test_writingToTopLevelWhileNestedFieldMapped_implicit() {
        this.test_writingToTopLevel(false);
    }

    private void test_writingToTopLevel(boolean explicit) {
        String mapName = SqlPojoTest.randomName();
        ((SqlTestSupport.SqlMapping)((SqlTestSupport.SqlMapping)((SqlTestSupport.SqlMapping)SqlPojoTest.javaMapping(mapName, Integer.class, Person.class).fields(new String[]{"__key INT"})).fieldsIf(explicit, new String[]{"this OBJECT"})).fields(new String[]{"name VARCHAR"})).create();
        if (explicit) {
            Assertions.assertThatThrownBy(() -> sqlService.execute("SINK INTO " + mapName + " VALUES(1, null, 'foo')", new Object[0])).hasMessageContaining("Writing to top-level fields of type OBJECT not supported");
        }
        Assertions.assertThatThrownBy(() -> sqlService.execute("SINK INTO " + mapName + "(__key, this) VALUES(1, null)", new Object[0])).hasMessageContaining("Writing to top-level fields of type OBJECT not supported");
        sqlService.execute("SINK INTO " + mapName + (explicit ? "(__key, name)" : "") + " VALUES (1, 'foo')", new Object[0]);
        SqlPojoTest.assertRowsAnyOrder("SELECT __key, this, name FROM " + mapName, List.of(new SqlTestSupport.Row(1, new Person(null, "foo"), "foo")));
    }

    @Test
    public void test_topLevelFieldExtraction() {
        String name = SqlPojoTest.randomName();
        SqlPojoTest.javaMapping(name, PersonId.class, Person.class).create();
        sqlService.execute("SINK INTO " + name + " (id, name) VALUES (1, 'Alice')", new Object[0]);
        SqlPojoTest.assertRowsAnyOrder("SELECT __key, this FROM " + name, List.of(new SqlTestSupport.Row(new PersonId(1), new Person(null, "Alice"))));
    }

    @Test
    public void test_nestedField() {
        String mapName = SqlPojoTest.randomName();
        Assertions.assertThatThrownBy(() -> ((SqlTestSupport.SqlMapping)new SqlTestSupport.SqlMapping(mapName, IMapSqlConnector.class).fields(new String[]{"__key INT", "petName VARCHAR", "\"owner.name\" VARCHAR"})).create()).hasMessageContaining("Invalid external name: this.owner.name");
    }

    @Test
    public void when_noFieldsResolved_then_wholeValueMapped() {
        String name = SqlPojoTest.randomName();
        SqlPojoTest.javaMapping(name, Object.class, Object.class).create();
        Person key = new Person(1, "foo");
        Person value = new Person(2, "bar");
        SqlPojoTest.instance().getMap(name).put((Object)key, (Object)value);
        SqlPojoTest.assertRowsAnyOrder("SELECT __key, this FROM " + name, List.of(new SqlTestSupport.Row(key, value)));
    }

    @Test
    public void when_keyHasKeyField_then_fieldIsSkipped() {
        String name = SqlPojoTest.randomName();
        SqlPojoTest.javaMapping(name, ClassWithKey.class, Integer.class).create();
        SqlPojoTest.instance().getMap(name).put((Object)new ClassWithKey(), (Object)0);
        SqlPojoTest.assertRowsAnyOrder("SELECT * FROM " + name, List.of(new SqlTestSupport.Row(0)));
        SqlPojoTest.assertRowsAnyOrder("SELECT __key, this FROM " + name, List.of(new SqlTestSupport.Row(new ClassWithKey(), 0)));
    }

    @Test
    public void test_classWithMapField() {
        String name = SqlPojoTest.randomName();
        ClassWithMapField obj = new ClassWithMapField(100L, "k", "v");
        SqlPojoTest.javaMapping(name, Long.class, ClassWithMapField.class).create();
        SqlPojoTest.instance().getSql().execute("SINK INTO " + name + " VALUES (?, ?, ?)", new Object[]{1L, obj.id, obj.props});
        SqlPojoTest.assertRowsAnyOrder("SELECT * FROM " + name, List.of(new SqlTestSupport.Row(1L, obj.id, obj.props)));
    }

    public static class ClassInitialValue
    implements Serializable {
        public Integer field = 42;
    }

    public static class ClassWithKey
    implements Serializable {
        public int __key;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassWithKey that = (ClassWithKey)o;
            return this.__key == that.__key;
        }

        public int hashCode() {
            return Objects.hash(this.__key);
        }
    }

    public static class ClassWithMapField
    implements Serializable {
        private Long id;
        private Map<String, String> props;

        public ClassWithMapField() {
        }

        public ClassWithMapField(Long id, String ... values) {
            this.id = id;
            this.props = new HashMap<String, String>();
            for (int i = 0; i < values.length; i += 2) {
                this.props.put(values[i], values[i + 1]);
            }
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public Map<String, String> getProps() {
            return this.props;
        }

        public void setProps(Map<String, String> props) {
            this.props = props;
        }
    }
}

