/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlTestSupport;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.test.jdbc.H2DatabaseProvider;
import com.hazelcast.test.jdbc.JdbcObjectProvider;
import com.hazelcast.test.jdbc.TestDatabaseProvider;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assumptions;
import org.assertj.core.util.Lists;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Category(value={QuickTest.class})
public class SchemaJdbcConnectorTest
extends JdbcSqlTestSupport {
    @Parameterized.Parameter
    public String schema;
    @Parameterized.Parameter(value=1)
    public String table;
    @Parameterized.Parameter(value=2)
    public String externalName;
    protected String tableFull;

    @Parameterized.Parameters(name="{index}: schemaName={0}, tableName={1}, externalTableName={2}")
    public static List<Object[]> data() {
        return Arrays.asList({"schema1", "table1", "schema1.table1"}, {"schema-with-hyphen", "table-with-hyphen", "\"schema-with-hyphen\".\"table-with-hyphen\""}, {"schema with space", "table with space", "\"schema with space\".\"table with space\""}, {"schema.with.dot", "table1", "\"schema.with.dot\".\"table1\""}, {"schema1", "table.with.dot", "\"schema1\".\"table.with.dot\""}, {"schema_with_quote\"", "table_with_quote\"", "\"schema_with_quote\"\"\".\"table_with_quote\"\"\""}, {"schema_with_backtick`", "table_with_backtick`", "\"schema_with_backtick`\".\"table_with_backtick`\""});
    }

    @BeforeClass
    public static void beforeClass() {
        SchemaJdbcConnectorTest.initialize((TestDatabaseProvider)new H2DatabaseProvider());
    }

    @Before
    public void setUp() throws Exception {
        Assumptions.assumeThat((Object)recordProvider).isInstanceOf(JdbcObjectProvider.class);
        this.tableFull = SchemaJdbcConnectorTest.quote(this.schema, this.table);
        try {
            SchemaJdbcConnectorTest.executeJdbc(((JdbcObjectProvider)recordProvider).createSchemaQuery(this.schema));
        }
        catch (Exception e) {
            this.logger.info("Could not create schema", (Throwable)e);
        }
        SchemaJdbcConnectorTest.createTableNoQuote(this.tableFull);
    }

    @After
    public void after() throws SQLException {
        try {
            SchemaJdbcConnectorTest.executeJdbc("DROP TABLE " + this.tableFull);
        }
        catch (Exception e) {
            this.logger.info("Could not drop schema", (Throwable)e);
        }
    }

    protected void myCreateMapping(String mappingName) {
        SchemaJdbcConnectorTest.execute("CREATE MAPPING \"" + mappingName + "\" EXTERNAL NAME " + this.externalName + " ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
    }

    @Test
    public void selectFromTableWithSchema() throws Exception {
        SchemaJdbcConnectorTest.insertItemsNoQuote(this.tableFull, 1);
        String mappingName = "mapping_" + SchemaJdbcConnectorTest.randomName();
        this.myCreateMapping(mappingName);
        SchemaJdbcConnectorTest.assertRowsAnyOrder("SELECT * FROM " + mappingName, Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row(0, "name-0")}));
    }

    @Test
    public void insertIntoTableWithSchema() {
        String mappingName = "mapping_" + SchemaJdbcConnectorTest.randomName();
        this.myCreateMapping(mappingName);
        SchemaJdbcConnectorTest.execute("INSERT INTO " + mappingName + " VALUES (0, 'name-0')", new Object[0]);
        SchemaJdbcConnectorTest.assertJdbcRowsAnyOrderNoQuote(this.tableFull, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "name-0"));
    }

    @Test
    public void updateTableWithSchema() throws Exception {
        SchemaJdbcConnectorTest.insertItemsNoQuote(this.tableFull, 1);
        String mappingName = "mapping_" + SchemaJdbcConnectorTest.randomName();
        this.myCreateMapping(mappingName);
        SchemaJdbcConnectorTest.execute("UPDATE " + mappingName + " SET name = 'updated'", new Object[0]);
        SchemaJdbcConnectorTest.assertJdbcRowsAnyOrderNoQuote(this.tableFull, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "updated"));
    }

    @Test
    public void deleteFromTableWithSchema() throws Exception {
        SchemaJdbcConnectorTest.insertItemsNoQuote(this.tableFull, 1);
        String mappingName = "mapping_" + SchemaJdbcConnectorTest.randomName();
        this.myCreateMapping(mappingName);
        SchemaJdbcConnectorTest.execute("DELETE FROM " + mappingName, new Object[0]);
        SchemaJdbcConnectorTest.assertJdbcRowsAnyOrderNoQuote(this.tableFull, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row[0]);
    }

    @Test
    public void sinkIntoTableWithSchema() {
        String mappingName = "mapping_" + SchemaJdbcConnectorTest.randomName();
        this.myCreateMapping(mappingName);
        SchemaJdbcConnectorTest.execute("SINK INTO " + mappingName + " VALUES (0, 'name-0')", new Object[0]);
        SchemaJdbcConnectorTest.assertJdbcRowsAnyOrderNoQuote(this.tableFull, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "name-0"));
    }
}

