/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.config.Config;
import com.hazelcast.config.DataConnectionConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.jdbc.DatabaseRule;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.test.ChangeLoggingRule;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.SlowTest;
import com.hazelcast.test.bounce.BounceMemberRule;
import com.hazelcast.test.bounce.BounceTestConfiguration;
import com.hazelcast.test.jdbc.H2DatabaseProvider;
import com.hazelcast.test.jdbc.TestDatabaseProvider;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.assertj.core.util.Lists;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={SlowTest.class})
public class JdbcSqlConnectorBounceTest {
    private static final int ITEM_COUNT = 5;
    private static final int CONCURRENCY = 10;
    private static final String TEST_DATABASE_REF = "test_database_ref";
    private String tableName;
    private final DatabaseRule dbRule = new DatabaseRule((TestDatabaseProvider)new H2DatabaseProvider());
    private final BounceMemberRule bounceMemberRule = BounceMemberRule.with((Config)this.getConfig(this.dbRule.getDbConnectionUrl())).clusterSize(4).driverCount(4).driverType(BounceTestConfiguration.DriverType.CLIENT).build();
    @ClassRule
    public static ChangeLoggingRule changeLoggingRule = new ChangeLoggingRule("log4j2-jdbc-sql-connector-bounce.xml");
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.dbRule).around((TestRule)this.bounceMemberRule);

    private Config getConfig(String jdbcUrl) {
        Properties properties = new Properties();
        properties.setProperty("jdbcUrl", jdbcUrl);
        return HazelcastTestSupport.smallInstanceConfig().addDataConnectionConfig(new DataConnectionConfig(TEST_DATABASE_REF).setType("jdbc").setProperties(properties));
    }

    @Before
    public void setUp() throws Exception {
        this.tableName = "table_" + SqlTestSupport.randomName();
        this.dbRule.createTable(this.tableName, "id INT PRIMARY KEY", "name VARCHAR(100)");
        this.dbRule.insertItems(this.tableName, 5);
        this.execute("CREATE MAPPING " + this.tableName + " ( id INT,  name VARCHAR ) DATA CONNECTION test_database_ref", new Object[0]);
    }

    @Test
    public void testQuery() {
        Runnable[] testTasks = new QueryRunnable[10];
        for (int i = 0; i < 10; ++i) {
            testTasks[i] = new QueryRunnable(this.bounceMemberRule.getNextTestDriver());
        }
        this.bounceMemberRule.testRepeatedly(testTasks, TimeUnit.MINUTES.toSeconds(1L));
    }

    private void execute(String sql, Object ... arguments) {
        SqlResult ignored = this.bounceMemberRule.getSteadyMember().getSql().execute(sql, arguments);
        if (ignored != null) {
            ignored.close();
        }
    }

    public class QueryRunnable
    implements Runnable {
        private final HazelcastInstance hazelcastInstance;

        public QueryRunnable(HazelcastInstance hazelcastInstance) {
            this.hazelcastInstance = hazelcastInstance;
        }

        @Override
        public void run() {
            SqlTestSupport.assertRowsAnyOrder(this.hazelcastInstance, "SELECT * FROM " + JdbcSqlConnectorBounceTest.this.tableName, (Collection<SqlTestSupport.Row>)Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row(0, "name-0"), new SqlTestSupport.Row(1, "name-1"), new SqlTestSupport.Row(2, "name-2"), new SqlTestSupport.Row(3, "name-3"), new SqlTestSupport.Row(4, "name-4")}));
        }
    }
}

