/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlTestSupport;
import com.hazelcast.test.jdbc.H2DatabaseProvider;
import com.hazelcast.test.jdbc.TestDatabaseProvider;
import java.sql.SQLException;
import org.assertj.core.util.Lists;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class JdbcLeftJoinTest
extends JdbcSqlTestSupport {
    private static final int ITEM_COUNT = 5;
    private String tableName;

    @BeforeClass
    public static void beforeClass() {
        JdbcLeftJoinTest.initialize((TestDatabaseProvider)new H2DatabaseProvider());
    }

    @Before
    public void setUp() throws Exception {
        this.tableName = JdbcLeftJoinTest.randomTableName();
        JdbcLeftJoinTest.createTable(this.tableName);
        JdbcLeftJoinTest.insertItems(this.tableName, 5);
        JdbcLeftJoinTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
    }

    @Test
    public void joinWithOtherJdbc_right_Side_Has_Less_Rows() throws SQLException {
        String otherTableName = JdbcLeftJoinTest.randomTableName();
        JdbcLeftJoinTest.createTable(otherTableName);
        JdbcLeftJoinTest.insertItems(otherTableName, 1, 1);
        JdbcLeftJoinTest.insertItems(otherTableName, 3, 1);
        JdbcLeftJoinTest.execute("CREATE MAPPING " + otherTableName + " ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
        JdbcLeftJoinTest.assertRowsAnyOrder("SELECT t1.id, t2.name FROM " + this.tableName + " t1 LEFT JOIN " + otherTableName + " t2    ON t1.id = t2.id", Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row(0, null), new SqlTestSupport.Row(1, "name-1"), new SqlTestSupport.Row(2, null), new SqlTestSupport.Row(3, "name-3"), new SqlTestSupport.Row(4, null)}));
    }

    @Test
    public void leftJoinWithOtherJdbc() throws SQLException {
        String otherTableName = JdbcLeftJoinTest.randomTableName();
        JdbcLeftJoinTest.createTable(otherTableName);
        JdbcLeftJoinTest.insertItems(otherTableName, 3);
        JdbcLeftJoinTest.execute("CREATE MAPPING " + otherTableName + " ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
        JdbcLeftJoinTest.assertRowsAnyOrder("SELECT t1.id, t2.name FROM " + this.tableName + " t1 LEFT JOIN " + otherTableName + " t2    ON t1.id = t2.id", Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row(0, "name-0"), new SqlTestSupport.Row(1, "name-1"), new SqlTestSupport.Row(2, "name-2"), new SqlTestSupport.Row(3, null), new SqlTestSupport.Row(4, null)}));
    }
}

