/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.file;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.sql.SqlService;
import java.nio.file.Paths;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlPlanCacheTest
extends SqlTestSupport {
    private static final String RESOURCES_PATH = Paths.get("src/test/resources", new String[0]).toFile().getAbsolutePath();
    private static SqlService sqlService;

    @BeforeClass
    public static void setUpClass() {
        SqlPlanCacheTest.initialize((int)1, null);
        sqlService = SqlPlanCacheTest.instance().getSql();
    }

    @Test
    public void test_tableName() {
        SqlPlanCacheTest.createMappingWithGlob("file1", "id", "file.csv");
        sqlService.execute("SELECT * FROM file1", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isEqualTo(1);
        SqlPlanCacheTest.createMappingWithGlob("file2", "id", "file.csv");
        sqlService.execute("DROP MAPPING file1", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isZero();
    }

    @Test
    public void test_fieldList() {
        SqlPlanCacheTest.createMappingWithGlob("file", "id", "file.csv");
        sqlService.execute("SELECT * FROM file", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isEqualTo(1);
        SqlPlanCacheTest.createMappingWithGlob("file", "name", "file.csv");
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isZero();
    }

    @Test
    public void test_options() {
        SqlPlanCacheTest.createMappingWithGlob("file", "id", "file.csv");
        sqlService.execute("SELECT * FROM file", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isEqualTo(1);
        SqlPlanCacheTest.createMappingWithGlob("file", "id", "*");
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isZero();
    }

    @Test
    public void test_tableFunction() {
        sqlService.execute("SELECT * FROM TABLE(CSV_FILE('" + RESOURCES_PATH + "', 'file.csv'))", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isZero();
    }

    @Test
    public void test_tableFunctionInAJob() {
        SqlPlanCacheTest.createMapping("map", Integer.TYPE, String.class);
        SqlPlanCacheTest.instance().getMap("map").put((Object)1, (Object)"1");
        sqlService.execute("CREATE JOB job AS SINK INTO map SELECT \"int\", string FROM TABLE(JSON_FLAT_FILE('" + RESOURCES_PATH + "', 'file.json'))", new Object[0]);
        Assertions.assertThat((int)SqlPlanCacheTest.planCache(SqlPlanCacheTest.instance()).size()).isZero();
    }

    private static void createMappingWithGlob(String name, String fieldName, String glob) {
        sqlService.execute("CREATE OR REPLACE MAPPING " + name + " (" + fieldName + " TINYINT EXTERNAL NAME byte) TYPE File OPTIONS ('format'='csv', 'path'='" + RESOURCES_PATH + "', 'glob'='" + glob + "')", new Object[0]);
    }
}

