/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.jet.sql.SqlJsonTestSupport;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.test.TestBatchSqlConnector;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;

@RunWith(value=Enclosed.class)
public class JsonSqlAggregateTest {

    @RunWith(value=HazelcastSerialClassRunner.class)
    @Category(value={QuickTest.class, ParallelJVMTest.class})
    public static class JsonObjectAggregationTest
    extends SqlJsonTestSupport {
        private static SqlService sqlService;

        @BeforeClass
        public static void setUpClass() {
            JsonObjectAggregationTest.initialize((int)2, null);
            sqlService = JsonObjectAggregationTest.instance().getSql();
        }

        @Test
        public void when_jsonObjectAgg_jsonInputClause_then_fail() {
            Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT JSON_OBJECTAGG('k' VALUE 'v' FORMAT JSON)", new Object[0])).hasMessage("From line 1, column 33 to line 1, column 47: JSON VALUE EXPRESSION not supported");
        }

        @Test
        public void when_jsonObjectAgg_keyUniquenessConstraint_then_fail() {
            Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT JSON_OBJECTAGG('k' VALUE 'v' WITH UNIQUE KEYS)", new Object[0])).hasMessageStartingWith("Encountered \"WITH\" at line 1, column 37");
        }

        @Test
        public void when_jsonObjectAgg_outputClause_then_fail() {
            Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT JSON_OBJECTAGG('k' VALUE 'v' RETURNING VARCHAR)", new Object[0])).hasMessageStartingWith("Encountered \"RETURNING\" at line 1, column 37.");
        }

        @Test
        public void test_literal() {
            this.assertJsonRowsAnyOrder("SELECT JSON_OBJECTAGG('k' VALUE 'v')", Collections.singletonList(new SqlTestSupport.Row(JsonObjectAggregationTest.json("{\"k\":\"v\"}"))));
        }

        @Test
        public void test_alternateSyntax() {
            this.assertJsonRowsAnyOrder("SELECT JSON_OBJECTAGG(key 'k' value 'v')", Collections.singletonList(new SqlTestSupport.Row(JsonObjectAggregationTest.json("{\"k\":\"v\"}"))));
            this.assertJsonRowsAnyOrder("SELECT JSON_OBJECTAGG('k':'v')", Collections.singletonList(new SqlTestSupport.Row(JsonObjectAggregationTest.json("{\"k\":\"v\"}"))));
        }

        @Test
        public void test_nullKey() {
            Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT JSON_OBJECTAGG(NULL VALUE 'v')", new Object[0]).iterator().next()).hasMessageContaining("NULL key is not supported for JSON_OBJECTAGG");
            TestBatchSqlConnector.create(sqlService, "m1", List.of("k", "v"), List.of(QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.VARCHAR), Collections.singletonList(new String[]{null, "v1"}));
            Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT JSON_OBJECTAGG(k VALUE v) FROM m1", new Object[0]).iterator().next()).hasMessageContaining("NULL key is not supported for JSON_OBJECTAGG");
        }

        @Test
        public void test_nullValueLiteral() {
            this.assertJsonRowsAnyOrder("SELECT JSON_OBJECTAGG('k' VALUE NULL)", Collections.singletonList(new SqlTestSupport.Row(JsonObjectAggregationTest.json("{\"k\":null}"))));
            this.assertJsonRowsAnyOrder("SELECT JSON_OBJECTAGG('k' VALUE NULL ABSENT ON NULL)", Collections.singletonList(new SqlTestSupport.Row(new Object[]{null})));
            this.assertJsonRowsAnyOrder("SELECT JSON_OBJECTAGG('k' VALUE NULL ABSENT ON NULL) FROM table(generate_series(1, 1)) WHERE 1=2", Collections.singletonList(new SqlTestSupport.Row(new Object[]{null})));
        }

        @Test
        public void test_duplicateKey() {
            TestBatchSqlConnector.create(sqlService, "m", List.of("k", "v"), List.of(QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.VARCHAR), List.of(new String[]{"k", "v1"}, new String[]{"k", "v2"}));
            this.assertJsonRowsAnyOrder("SELECT JSON_OBJECTAGG(k VALUE v) FROM m", Collections.singletonList(new SqlTestSupport.Row(JsonObjectAggregationTest.json("{\"k\":\"v1\",\"k\":\"v2\"}"))));
        }

        @Test
        public void test_jsonObjectAgg() {
            String name = JsonObjectAggregationTest.createTable();
            this.assertJsonRowsAnyOrder("SELECT name, JSON_OBJECTAGG(k VALUE v ABSENT ON NULL) FROM " + name + " WHERE name IS NOT NULL GROUP BY name", List.of(new SqlTestSupport.Row("Alice", JsonObjectAggregationTest.json("{ \"department\" : \"dep1\", \"job\" : \"job1\", \"description\" : \"desc1\" }")), new SqlTestSupport.Row("Bob", JsonObjectAggregationTest.json("{ \"department\" : \"dep2\", \"job\" : \"job2\" }"))));
            this.assertJsonRowsAnyOrder("SELECT name, JSON_OBJECTAGG(k VALUE v NULL ON NULL) FROM " + name + " WHERE name IS NOT NULL GROUP BY name", List.of(new SqlTestSupport.Row("Alice", JsonObjectAggregationTest.json("{ \"department\" : \"dep1\", \"job\" : \"job1\", \"description\" : \"desc1\" }")), new SqlTestSupport.Row("Bob", JsonObjectAggregationTest.json("{ \"department\" : \"dep2\", \"job\" : \"job2\", \"description\" : null }"))));
        }

        @Test
        public void test_jsonObjectAgg_whenReturnsNull() {
            String name = JsonObjectAggregationTest.createTable();
            JsonObjectAggregationTest.assertRowsAnyOrder("SELECT name, JSON_OBJECTAGG(k VALUE v ABSENT ON NULL) FROM " + name + " WHERE name = 'Bob' AND k = 'description' GROUP BY name", List.of(new SqlTestSupport.Row("Bob", null)));
        }

        private static String createTable() {
            String name = JsonObjectAggregationTest.randomName();
            TestBatchSqlConnector.create(sqlService, name, List.of("name", "k", "v"), List.of(QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.VARCHAR), List.of(new String[]{"Alice", "department", "dep1"}, new String[]{"Bob", "department", "dep2"}, new String[]{"Alice", "job", "job1"}, new String[]{null, "department", "dep2"}, new String[]{"Bob", "job", "job2"}, new String[]{null, "job", "job1"}, new String[]{null, null, "desc2"}, new String[]{"Bob", "description", null}, new String[]{"Alice", "description", "desc1"}));
            return name;
        }
    }

    @RunWith(value=HazelcastSerialClassRunner.class)
    @Category(value={QuickTest.class, ParallelJVMTest.class})
    public static class JsonArrayAggregationTest
    extends SqlJsonTestSupport {
        private static SqlService sqlService;

        @BeforeClass
        public static void setUpClass() {
            JsonArrayAggregationTest.initialize((int)2, null);
            sqlService = JsonArrayAggregationTest.instance().getSql();
        }

        @Test
        public void test_jsonArrayAgg_emptyResult() {
            String name = this.createTable();
            JsonArrayAggregationTest.assertRowsAnyOrder("SELECT JSON_ARRAYAGG(name) FROM " + name + " WHERE 1=2", Collections.singletonList(new SqlTestSupport.Row(new Object[]{null})));
            JsonArrayAggregationTest.assertRowsAnyOrder("SELECT JSON_ARRAYAGG(name NULL ON NULL) FROM " + name + " WHERE 1=2", Collections.singletonList(new SqlTestSupport.Row(new Object[]{null})));
            JsonArrayAggregationTest.assertRowsAnyOrder("SELECT JSON_ARRAYAGG(name ABSENT ON NULL) FROM " + name + " WHERE 1=2", Collections.singletonList(new SqlTestSupport.Row(new Object[]{null})));
            JsonArrayAggregationTest.assertRowsAnyOrder("SELECT JSON_ARRAYAGG(name) FROM " + name + " WHERE name IS NULL", Collections.singletonList(new SqlTestSupport.Row(new Object[]{null})));
        }

        @Test
        public void test_jsonArrayAgg_nulls() {
            String name = this.createTable();
            JsonArrayAggregationTest.assertRowsAnyOrder("SELECT JSON_ARRAYAGG(name NULL ON NULL) FROM " + name + " WHERE name IS NULL", Collections.singletonList(new SqlTestSupport.Row(JsonArrayAggregationTest.json("[null,null]"))));
        }

        @Test
        public void test_jsonArrayAgg_unordered() {
            String name = this.createTable();
            JsonArrayAggregationTest.assertRowsAnyOrder("SELECT JSON_ARRAYAGG(name ABSENT ON NULL) FROM " + name + " WHERE name = 'Alice'", Collections.singletonList(new SqlTestSupport.Row(JsonArrayAggregationTest.json("[\"Alice\",\"Alice\",\"Alice\"]"))));
            JsonArrayAggregationTest.assertRowsAnyOrder("SELECT name, JSON_ARRAYAGG(distance) FROM " + name + " WHERE name = 'Bob' GROUP BY name", Collections.singletonList(new SqlTestSupport.Row("Bob", JsonArrayAggregationTest.json("[3]"))));
        }

        @Test
        public void test_jsonArrayAgg_orderedBySameColumn() {
            String name = this.createTable();
            JsonArrayAggregationTest.assertRowsAnyOrder("SELECT JSON_ARRAYAGG(name ORDER BY name ABSENT ON NULL) FROM " + name, Collections.singletonList(new SqlTestSupport.Row(JsonArrayAggregationTest.json("[\"Alice\",\"Alice\",\"Alice\",\"Bob\"]"))));
            JsonArrayAggregationTest.assertRowsAnyOrder("SELECT JSON_ARRAYAGG(name ORDER BY name NULL ON NULL) FROM " + name, Collections.singletonList(new SqlTestSupport.Row(JsonArrayAggregationTest.json("[null,null,\"Alice\",\"Alice\",\"Alice\",\"Bob\"]"))));
            JsonArrayAggregationTest.assertRowsAnyOrder("SELECT JSON_ARRAYAGG(name ORDER BY name) FROM " + name, Collections.singletonList(new SqlTestSupport.Row(JsonArrayAggregationTest.json("[\"Alice\",\"Alice\",\"Alice\",\"Bob\"]"))));
        }

        @Test
        public void test_jsonArrayAgg_orderedByDifferentColumn() {
            String name = this.createTable();
            JsonArrayAggregationTest.assertRowsAnyOrder("SELECT JSON_ARRAYAGG(name ORDER BY distance ABSENT ON NULL) FROM " + name, Collections.singletonList(new SqlTestSupport.Row(JsonArrayAggregationTest.json("[\"Alice\",\"Bob\",\"Alice\",\"Alice\"]"))));
            JsonArrayAggregationTest.assertRowsAnyOrder("SELECT JSON_ARRAYAGG(name ORDER BY distance NULL ON NULL) FROM " + name, Collections.singletonList(new SqlTestSupport.Row(JsonArrayAggregationTest.json("[\"Alice\",\"Bob\",\"Alice\",null,\"Alice\",null]"))));
            JsonArrayAggregationTest.assertRowsAnyOrder("SELECT JSON_ARRAYAGG(name ORDER BY distance) FROM " + name, Collections.singletonList(new SqlTestSupport.Row(JsonArrayAggregationTest.json("[\"Alice\",\"Bob\",\"Alice\",\"Alice\"]"))));
        }

        @Test
        public void test_jsonArrayAgg_withGroupBy() {
            String name = this.createTable();
            JsonArrayAggregationTest.assertRowsAnyOrder("SELECT name, JSON_ARRAYAGG(distance ORDER BY distance) FROM " + name + " GROUP BY name", List.of(new SqlTestSupport.Row("Alice", JsonArrayAggregationTest.json("[1,4,7]")), new SqlTestSupport.Row("Bob", JsonArrayAggregationTest.json("[3]")), new SqlTestSupport.Row(null, JsonArrayAggregationTest.json("[6,8]"))));
            JsonArrayAggregationTest.assertRowsAnyOrder("SELECT name, JSON_ARRAYAGG(distance ORDER BY distance DESC) FROM " + name + " GROUP BY name", List.of(new SqlTestSupport.Row("Alice", JsonArrayAggregationTest.json("[7,4,1]")), new SqlTestSupport.Row("Bob", JsonArrayAggregationTest.json("[3]")), new SqlTestSupport.Row(null, JsonArrayAggregationTest.json("[8,6]"))));
        }

        @Test
        public void test_jsonArrayAgg_multiple() {
            String name = this.createTable();
            JsonArrayAggregationTest.assertRowsAnyOrder("SELECT name, JSON_ARRAYAGG(distance ORDER BY distance DESC), JSON_ARRAYAGG(distance ORDER BY distance ASC) FROM " + name + " GROUP BY name", List.of(new SqlTestSupport.Row("Alice", JsonArrayAggregationTest.json("[7,4,1]"), JsonArrayAggregationTest.json("[1,4,7]")), new SqlTestSupport.Row("Bob", JsonArrayAggregationTest.json("[3]"), JsonArrayAggregationTest.json("[3]")), new SqlTestSupport.Row(null, JsonArrayAggregationTest.json("[8,6]"), JsonArrayAggregationTest.json("[6,8]"))));
        }

        private String createTable() {
            String name = JsonArrayAggregationTest.randomName();
            TestBatchSqlConnector.create(sqlService, name, List.of("name", "distance"), List.of(QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.INTEGER), List.of(new String[]{"Alice", "1"}, new String[]{"Bob", "3"}, new String[]{"Alice", "4"}, new String[]{null, "6"}, new String[]{"Alice", "7"}, new String[]{null, "8"}));
            return name;
        }
    }
}

