/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.core.JobAssertions;
import com.hazelcast.jet.core.TestProcessors;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.test.Accessors;
import com.hazelcast.version.MemberVersion;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlRollingUpgradeTest
extends SqlTestSupport {
    private static HazelcastInstance client;

    @BeforeClass
    public static void beforeClass() {
        SqlRollingUpgradeTest.initialize((int)2, null);
        MemberVersion m0Version = SqlRollingUpgradeTest.instances()[0].getCluster().getLocalMember().getVersion();
        Address m1Address = SqlRollingUpgradeTest.instances()[1].getCluster().getLocalMember().getAddress();
        MemberVersion m1Version = new MemberVersion((int)m0Version.getMajor(), m0Version.getMinor() + 1, (int)m0Version.getPatch());
        Accessors.getNodeEngineImpl((HazelcastInstance)SqlRollingUpgradeTest.instances()[1]).getLocalMember().setVersion(m1Version);
        Accessors.getNodeEngineImpl((HazelcastInstance)SqlRollingUpgradeTest.instances()[0]).getClusterService().getMember(m1Address).setVersion(m1Version);
        client = SqlRollingUpgradeTest.factory().newHazelcastClient();
    }

    @Test
    public void when_lightJob_then_usesTheSubmitterVersion() {
        Job job1 = SqlRollingUpgradeTest.instances()[0].getJet().newLightJob(TestProcessors.streamingDag());
        SqlRollingUpgradeTest.assertTrueEventually(() -> JobAssertions.assertThat((Job)job1).isExecutingOn(SqlRollingUpgradeTest.instances()[0]));
        JobAssertions.assertThat((Job)job1).isNotExecutingOn(SqlRollingUpgradeTest.instances()[1]);
        Job job2 = SqlRollingUpgradeTest.instances()[1].getJet().newLightJob(TestProcessors.streamingDag());
        SqlRollingUpgradeTest.assertTrueEventually(() -> JobAssertions.assertThat((Job)job2).isExecutingOn(SqlRollingUpgradeTest.instances()[1]));
        JobAssertions.assertThat((Job)job2).isNotExecutingOn(SqlRollingUpgradeTest.instances()[0]);
    }

    @Test
    public void when_clientSql_then_usesEitherVersion() {
        SqlRollingUpgradeTest.createMapping(client, "m", Integer.class, Integer.class);
        client.getSql().execute("select * from table(generate_stream(1)) join m on __key=v", new Object[0]);
        SqlRollingUpgradeTest.assertTrueEventually(() -> Assert.assertEquals((long)1L, (long)SqlRollingUpgradeTest.getJetServiceBackend((HazelcastInstance)SqlRollingUpgradeTest.instances()[1]).getJobExecutionService().getExecutionContexts().size()));
        Assert.assertEquals((long)0L, (long)SqlRollingUpgradeTest.getJetServiceBackend((HazelcastInstance)SqlRollingUpgradeTest.instances()[0]).getJobExecutionService().getExecutionContexts().size());
    }
}

