/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.config.DataConnectionConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.sql.SqlJsonTestSupport;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.test.Accessors;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class ShowDataConnectionsSqlTest
extends SqlJsonTestSupport {
    @BeforeClass
    public static void beforeClass() throws Exception {
        ShowDataConnectionsSqlTest.initializeWithClient((int)1, null, null);
    }

    @Test
    public void test_showDataConnections() {
        ShowDataConnectionsSqlTest.assertRowsOrdered("show data connections", Collections.emptyList());
        Accessors.getNodeEngineImpl((HazelcastInstance)ShowDataConnectionsSqlTest.instance()).getDataConnectionService().createConfigDataConnection(new DataConnectionConfig("dl").setType("dummy"));
        List dlNames = IntStream.range(0, 5).mapToObj(i -> "dl" + i).collect(Collectors.toList());
        for (String dlName : dlNames) {
            ShowDataConnectionsSqlTest.instance().getSql().execute("CREATE DATA CONNECTION " + dlName + " TYPE DUMMY SHARED OPTIONS ('b' = 'c')", new Object[0]).close();
        }
        dlNames.add(0, "dl");
        List<SqlTestSupport.Row> expectedRows = dlNames.stream().map(name -> new SqlTestSupport.Row(name, "DUMMY", ShowDataConnectionsSqlTest.jsonArray("testType1", "testType2"))).collect(Collectors.toList());
        ShowDataConnectionsSqlTest.assertRowsOrdered(ShowDataConnectionsSqlTest.instance(), "show data connections", expectedRows);
        ShowDataConnectionsSqlTest.assertRowsOrdered(ShowDataConnectionsSqlTest.client(), "show data connections", expectedRows);
    }
}

