/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.config.Config;
import com.hazelcast.config.IndexType;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.map.IMap;
import com.hazelcast.sql.impl.optimizer.PlanKey;
import com.hazelcast.sql.impl.optimizer.SqlPlan;
import com.hazelcast.sql.impl.plan.cache.PlanCache;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class PlanCacheIntegrationTest
extends SqlTestSupport {
    private String mapName;

    @BeforeClass
    public static void setUp() {
        PlanCacheIntegrationTest.initialize((int)2, (Config)PlanCacheIntegrationTest.smallInstanceConfig());
    }

    @Before
    public void before() {
        this.mapName = SqlTestSupport.randomName();
    }

    @Test
    public void testPlanIsCached() {
        PlanCacheIntegrationTest.createMapping(this.mapName, Integer.TYPE, Integer.TYPE);
        PlanCacheIntegrationTest.instance().getMap(this.mapName).put((Object)1, (Object)1);
        PlanCache planCache = PlanCacheIntegrationTest.planCache(PlanCacheIntegrationTest.instance());
        PlanCacheIntegrationTest.instance().getSql().execute("SELECT * FROM " + this.mapName, new Object[0]);
        Assert.assertEquals((long)1L, (long)planCache.size());
        SqlPlan plan1 = planCache.get((PlanKey)planCache.getPlans().keys().nextElement());
        PlanCacheIntegrationTest.instance().getSql().execute("SELECT * FROM " + this.mapName, new Object[0]);
        Assert.assertEquals((long)1L, (long)planCache.size());
        SqlPlan plan2 = planCache.get((PlanKey)planCache.getPlans().keys().nextElement());
        Assert.assertSame((Object)plan1, (Object)plan2);
    }

    @Test
    public void testPlanInvalidatedOnIndexAdd() {
        IMap map = PlanCacheIntegrationTest.instance().getMap(this.mapName);
        PlanCacheIntegrationTest.createMapping(this.mapName, Integer.TYPE, Integer.TYPE);
        map.put((Object)1, (Object)1);
        PlanCache planCache = PlanCacheIntegrationTest.planCache(PlanCacheIntegrationTest.instance());
        PlanCacheIntegrationTest.instance().getSql().execute("SELECT * FROM " + this.mapName + " WHERE this=1", new Object[0]);
        Assert.assertEquals((long)1L, (long)planCache.size());
        SqlPlan plan1 = planCache.get((PlanKey)planCache.getPlans().keys().nextElement());
        map.addIndex(IndexType.HASH, new String[]{"this"});
        PlanCacheIntegrationTest.assertTrueEventually(() -> {
            PlanCacheIntegrationTest.instance().getSql().execute("SELECT * FROM " + this.mapName + " WHERE this=1", new Object[0]);
            Assert.assertEquals((long)1L, (long)planCache.size());
            SqlPlan plan2 = planCache.get((PlanKey)planCache.getPlans().keys().nextElement());
            Assert.assertNotSame((Object)plan1, (Object)plan2);
        });
    }
}

