/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.test.TestBatchSqlConnector;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlSortTest
extends SqlTestSupport {
    private static SqlService sqlService;

    @BeforeClass
    public static void setUpClass() {
        SqlSortTest.initialize((int)2, null);
        sqlService = SqlSortTest.instance().getSql();
    }

    @Test
    public void test() {
        String tableName = SqlSortTest.createTable({"A", "1"}, {"B", "2"}, {"B", "1"}, {"C", "1"}, {"C", "2"});
        SqlSortTest.assertRowsOrdered(String.format("SELECT name, distance FROM %s ORDER BY distance, name", tableName), Arrays.asList(new SqlTestSupport.Row("A", 1), new SqlTestSupport.Row("B", 1), new SqlTestSupport.Row("C", 1), new SqlTestSupport.Row("B", 2), new SqlTestSupport.Row("C", 2)));
    }

    @Test
    public void test_orderByProjectExpression() {
        String tableName = SqlSortTest.createTable({"A", "1"}, {"B", "4"}, {"H", "3"}, {"Z", "2"});
        SqlSortTest.assertRowsOrdered(String.format("SELECT name, distance FROM %s ORDER BY LENGTH(name) + distance", tableName), Arrays.asList(new SqlTestSupport.Row("A", 1), new SqlTestSupport.Row("Z", 2), new SqlTestSupport.Row("H", 3), new SqlTestSupport.Row("B", 4)));
    }

    @Test
    public void test_nullAscending() {
        String tableName = SqlSortTest.createTable({"B", null}, {"A", null}, {"A", "1"}, {"B", "1"});
        SqlSortTest.assertRowsOrdered(String.format("SELECT name, distance FROM %s ORDER BY distance ASC, name ASC", tableName), Arrays.asList(new SqlTestSupport.Row("A", null), new SqlTestSupport.Row("B", null), new SqlTestSupport.Row("A", 1), new SqlTestSupport.Row("B", 1)));
    }

    @Test
    public void test_nullDescending() {
        String tableName = SqlSortTest.createTable({"B", null}, {"A", null}, {"A", "1"}, {"B", "1"});
        SqlSortTest.assertRowsOrdered(String.format("SELECT name, distance FROM %s ORDER BY distance DESC, name DESC", tableName), Arrays.asList(new SqlTestSupport.Row("B", 1), new SqlTestSupport.Row("A", 1), new SqlTestSupport.Row("B", null), new SqlTestSupport.Row("A", null)));
    }

    @Test
    public void test_nullsFirstAscending_notSupported() {
        String tableName = SqlSortTest.createTable({"B", null}, {"B", "1"}, {"A", null}, {"A", "1"}, {"C", "1"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.execute(String.format("SELECT name, distance FROM %s ORDER BY distance ASC NULLS FIRST, name ASC", tableName), new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("NULLS FIRST not supported");
    }

    @Test
    public void test_nullsLastAscending_notSupported() {
        String tableName = SqlSortTest.createTable({"B", null}, {"B", "1"}, {"A", null}, {"A", "1"}, {"C", "1"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.execute(String.format("SELECT name, distance FROM %s ORDER BY distance ASC NULLS LAST, name ASC", tableName), new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("NULLS LAST not supported");
    }

    @Test
    public void test_nullsFirstDescending_notSupported() {
        String tableName = SqlSortTest.createTable({"B", null}, {"B", "1"}, {"A", null}, {"A", "1"}, {"C", "1"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.execute(String.format("SELECT name, distance FROM %s ORDER BY distance DESC NULLS FIRST, name DESC", tableName), new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("NULLS FIRST not supported");
    }

    @Test
    public void test_nullsLastDescending_notSupported() {
        String tableName = SqlSortTest.createTable({"B", null}, {"B", "1"}, {"A", null}, {"A", "1"}, {"C", "1"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.execute(String.format("SELECT name, distance FROM %s ORDER BY distance DESC NULLS LAST, name DESC", tableName), new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("NULLS LAST not supported");
    }

    @Test
    public void test_sortWithLimit() {
        String tableName = SqlSortTest.createTable({"B", "2"}, {"B", "1"}, {"A", "3"}, {"A", "1"}, {"C", "1"});
        SqlSortTest.assertRowsOrdered(String.format("SELECT name, distance FROM %s ORDER BY distance DESC, name DESC LIMIT 2", tableName), Arrays.asList(new SqlTestSupport.Row("A", 3), new SqlTestSupport.Row("B", 2)));
    }

    @Test
    public void test_sortWithLimitAndOffset() {
        String tableName = SqlSortTest.createTable({"B", "2"}, {"B", "1"}, {"A", "3"}, {"A", "1"}, {"C", "1"});
        SqlSortTest.assertRowsOrdered(String.format("SELECT name, distance FROM %s ORDER BY distance DESC, name DESC LIMIT 2 OFFSET 2", tableName), Arrays.asList(new SqlTestSupport.Row("C", 1), new SqlTestSupport.Row("B", 1)));
    }

    @Test
    public void whenOffsetEqualsZero_thenNoOffset() {
        String tableName = SqlSortTest.createTable({"B", "2"}, {"B", "1"}, {"A", "3"}, {"A", "1"}, {"C", "1"});
        SqlSortTest.assertRowsOrdered(String.format("SELECT name, distance FROM %s ORDER BY distance DESC, name DESC LIMIT 2 OFFSET 0", tableName), Arrays.asList(new SqlTestSupport.Row("A", 3), new SqlTestSupport.Row("B", 2)));
    }

    @Test
    public void whenOffsetMoreThanSize_thenItShouldCompleteWithNoOutput() {
        String tableName = SqlSortTest.createTable({"B", "2"}, {"B", "1"}, {"A", "3"}, {"C", "1"});
        SqlSortTest.assertRowsAnyOrder(String.format("SELECT name, distance FROM %s ORDER BY distance DESC, name DESC OFFSET 100", tableName), Collections.emptyList());
    }

    @Test
    public void whenOffsetIsNegativeOrNull_thenFails() {
        String tableName = SqlSortTest.createTable({"B", "2"}, {"B", "1"});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.execute(String.format("SELECT name, distance FROM %s ORDER BY distance DESC, name DESC OFFSET -1", tableName), new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Encountered \"-\" at line 1, column 108");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.execute(String.format("SELECT name, distance FROM %s ORDER BY distance DESC, name DESC OFFSET NULL", tableName), new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Encountered \"NULL\" at line 1, column 108.");
    }

    @Test
    public void whenOrderByOnStreamingData_thenFails() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE(GENERATE_STREAM(1)) ORDER BY 1", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Sorting is not supported for a streaming query");
    }

    private static String createTable(String[] ... values) {
        String name = SqlSortTest.randomName();
        TestBatchSqlConnector.create(sqlService, name, Arrays.asList("name", "distance"), Arrays.asList(QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.INTEGER), Arrays.asList(values));
        return name;
    }
}

