/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.Job;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.JobAssertions;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.impl.JetClientInstanceImpl;
import com.hazelcast.jet.impl.JobAndSqlSummary;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.test.TestBatchSqlConnector;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlMetadataInJobConfigTest
extends SqlTestSupport {
    @BeforeClass
    public static void setUpClass() {
        SqlMetadataInJobConfigTest.initializeWithClient((int)1, null, null);
    }

    @Test
    public void test_selectMetadata_member() {
        String sql = "SELECT * FROM table(generate_stream(1))";
        try (SqlResult ignored = SqlMetadataInJobConfigTest.client().getSql().execute(new SqlStatement(sql).setCursorBufferSize(1));){
            this.waitForJobRunning();
            List<Job> runningJobs = this.getJobsByStatus(JobStatus.RUNNING);
            JobConfig config = runningJobs.get(0).getConfig();
            Assert.assertEquals((Object)sql, (Object)config.getArgument("__sql.queryText"));
            Assert.assertEquals((Object)Boolean.TRUE, (Object)config.getArgument("__sql.queryUnbounded"));
        }
    }

    @Test
    public void test_selectMetadata_client() {
        String sql = "SELECT * FROM table(generate_stream(1))";
        try (SqlResult ignored = SqlMetadataInJobConfigTest.client().getSql().execute(new SqlStatement(sql).setCursorBufferSize(1));){
            this.waitForJobRunning();
            List<Job> runningJobs = this.getJobsByStatus(JobStatus.RUNNING);
            JobConfig config = runningJobs.get(0).getConfig();
            Assert.assertEquals((Object)sql, (Object)config.getArgument("__sql.queryText"));
            Assert.assertEquals((Object)Boolean.TRUE, (Object)config.getArgument("__sql.queryUnbounded"));
        }
    }

    @Test
    public void test_selectMetadata_clientJobSummary() {
        String sql = "SELECT * FROM table(generate_stream(1))";
        try (SqlResult ignored = SqlMetadataInJobConfigTest.client().getSql().execute(new SqlStatement(sql).setCursorBufferSize(1));){
            this.waitForJobRunning();
            JetClientInstanceImpl jet = (JetClientInstanceImpl)SqlMetadataInJobConfigTest.client().getJet();
            List jobSummaries = jet.getJobAndSqlSummaryList().stream().filter(jobSummary -> jobSummary.getStatus() == JobStatus.RUNNING).collect(Collectors.toList());
            JobAndSqlSummary jobSummary2 = (JobAndSqlSummary)jobSummaries.get(0);
            Assert.assertNotNull((Object)jobSummary2.getSqlSummary());
            Assert.assertEquals((Object)sql, (Object)jobSummary2.getSqlSummary().getQuery());
            Assert.assertEquals((Object)Boolean.TRUE, (Object)jobSummary2.getSqlSummary().isUnbounded());
        }
    }

    @Test
    public void test_createBatchJobMetadata() {
        TestBatchSqlConnector.create(SqlMetadataInJobConfigTest.instance().getSql(), "src", 3);
        SqlMetadataInJobConfigTest.createMapping("dest", Integer.class, String.class);
        String sql = "CREATE JOB testJob AS INSERT INTO dest SELECT v * 2, 'value-' || v FROM src WHERE v < 2";
        SqlMetadataInJobConfigTest.instance().getSql().execute(sql, new Object[0]);
        Job job = SqlMetadataInJobConfigTest.instance().getJet().getJob("testJob");
        JobAssertions.assertThat((Job)job).eventuallyHasStatus(JobStatus.COMPLETED);
        List<Job> completedJobs = this.getJobsByStatus(JobStatus.COMPLETED);
        Assert.assertEquals((long)1L, (long)completedJobs.size());
        JobConfig config = completedJobs.get(0).getConfig();
        Assert.assertEquals((Object)sql, (Object)config.getArgument("__sql.queryText"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)config.getArgument("__sql.queryUnbounded"));
        Assert.assertEquals((Object)Boolean.FALSE, (Object)config.isSuspendOnFailure());
    }

    @Test
    public void test_createStreamingJobMetadata() {
        SqlMetadataInJobConfigTest.createMapping("dest", Integer.class, String.class);
        String sql = "CREATE JOB testJob AS INSERT INTO dest SELECT v * 2, 'value-' || v FROM TABLE(generate_stream(1))";
        SqlMetadataInJobConfigTest.instance().getSql().execute(sql, new Object[0]);
        SqlMetadataInJobConfigTest.awaitSingleRunningJob((HazelcastInstance)SqlMetadataInJobConfigTest.instance());
        List<Job> runningJobs = this.getJobsByStatus(JobStatus.RUNNING);
        Assert.assertEquals((long)1L, (long)runningJobs.size());
        JobConfig config = runningJobs.get(0).getConfig();
        Assert.assertEquals((Object)sql, (Object)config.getArgument("__sql.queryText"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)config.getArgument("__sql.queryUnbounded"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)config.isSuspendOnFailure());
    }

    @Test
    public void test_dmlMetadata() {
        SqlMetadataInJobConfigTest.createMapping("dest", Integer.class, Integer.class);
        TestBatchSqlConnector.create(SqlMetadataInJobConfigTest.instance().getSql(), "src", 1, true);
        String sql = "INSERT INTO dest SELECT v, v FROM src";
        SqlMetadataInJobConfigTest.spawn(() -> SqlMetadataInJobConfigTest.instance().getSql().execute(sql, new Object[0]));
        SqlMetadataInJobConfigTest.awaitSingleRunningJob((HazelcastInstance)SqlMetadataInJobConfigTest.instance());
        List<Job> runningJobs = this.getJobsByStatus(JobStatus.RUNNING);
        Assert.assertEquals((long)1L, (long)runningJobs.size());
        JobConfig config = runningJobs.get(0).getConfig();
        Assert.assertEquals((Object)sql, (Object)config.getArgument("__sql.queryText"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)config.getArgument("__sql.queryUnbounded"));
    }

    private void waitForJobRunning() {
        SqlMetadataInJobConfigTest.assertTrueEventually(() -> Assert.assertEquals((long)1L, (long)this.getJobsByStatus(JobStatus.RUNNING).size()));
    }

    private List<Job> getJobsByStatus(JobStatus status) {
        return SqlMetadataInJobConfigTest.instance().getJet().getJobs().stream().filter(job -> job.getStatus() == status).collect(Collectors.toList());
    }
}

