/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.jet.core.TestUtil;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.map.model.Person;
import com.hazelcast.jet.sql.impl.connector.test.TestAllTypesSqlConnector;
import com.hazelcast.jet.sql.impl.connector.test.TestBatchSqlConnector;
import com.hazelcast.map.IMap;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlService;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlFilterProjectTest
extends SqlTestSupport {
    private static SqlService sqlService;

    @BeforeClass
    public static void setUpClass() {
        SqlFilterProjectTest.initialize((int)2, null);
        sqlService = SqlFilterProjectTest.instance().getSql();
    }

    @Test
    public void test_valuesSelect() {
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT * FROM (VALUES ('a'), ('b'))", Arrays.asList(new SqlTestSupport.Row("a"), new SqlTestSupport.Row("b")));
    }

    @Test
    public void test_valuesSelectExpression() {
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT * FROM (VALUES (1), (1 + 2), (CAST ('5' AS TINYINT)))", Arrays.asList(new SqlTestSupport.Row((byte)1), new SqlTestSupport.Row((byte)3), new SqlTestSupport.Row((byte)5)));
    }

    @Test
    public void test_valuesSelectFilter() {
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT a - b FROM (VALUES (1, 2), (3, 5), (7, 11)) AS t (a, b) WHERE a > 1", Arrays.asList(new SqlTestSupport.Row((byte)-2), new SqlTestSupport.Row((byte)-4)));
    }

    @Test
    public void test_valuesSelectFilterExpression() {
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT a - b FROM (VALUES (1, 2), (3, 5), (7, 11)) AS t (a, b) WHERE a + b + 0 + CAST('1' AS TINYINT) > 4", Arrays.asList(new SqlTestSupport.Row((byte)-2), new SqlTestSupport.Row((byte)-4)));
    }

    @Test
    public void test_valuesSelectExpressionFilterExpression() {
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT a - b FROM (VALUES (1, 1 + 1), (3, 5), (CAST('7' AS TINYINT), 11)) AS t (a, b) WHERE a + b + 0 + CAST('1' AS TINYINT) > 4", Arrays.asList(new SqlTestSupport.Row((short)-2), new SqlTestSupport.Row((short)-4)));
    }

    @Test
    public void test_valuesSelectDynamicParameters() {
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT ? - b FROM (VALUES (1, ? + 1), (3, 5), (CAST(? AS TINYINT), 11)) AS t (a, b) WHERE a + b + ? + CAST('1' AS TINYINT) > ?", Arrays.asList(42, 1, "7", 0, 4), Arrays.asList(new SqlTestSupport.Row(37L), new SqlTestSupport.Row(31L)));
    }

    @Test
    public void test_valuesInsert() {
        SqlFilterProjectTest.createMapping("m", Integer.class, Integer.class);
        SqlFilterProjectTest.assertMapEventually("m", "SINK INTO m(__key, this) VALUES (1, 1), (2, 2)", TestUtil.createMap((Object[])new Object[]{1, 1, 2, 2}));
    }

    @Test
    public void test_valuesInsertExpression() {
        SqlFilterProjectTest.createMapping("m", Integer.class, Integer.class);
        SqlFilterProjectTest.assertMapEventually("m", "SINK INTO m(__key, this) VALUES (CAST(1 AS INTEGER), CAST(1 + 0 AS INTEGER)), (CAST(2 AS INTEGER), CAST(2 AS INTEGER))", TestUtil.createMap((Object[])new Object[]{1, 1, 2, 2}));
    }

    @Test
    public void test_valuesInsertDynamicParameter() {
        SqlFilterProjectTest.createMapping("m", Integer.class, String.class);
        SqlFilterProjectTest.assertMapEventually("m", "SINK INTO m(__key, this) VALUES (? + 1, ?), (?, UPPER(?))", Arrays.asList(0, "a", 2, "b"), TestUtil.createMap((Object[])new Object[]{1, "a", 2, "B"}));
    }

    @Test
    public void test_projectWithoutInputReferences() {
        TestBatchSqlConnector.create(sqlService, "t", 2);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT '\u55b7\u6c14\u5f0f\u98de\u673a' FROM t", Arrays.asList(new SqlTestSupport.Row("\u55b7\u6c14\u5f0f\u98de\u673a"), new SqlTestSupport.Row("\u55b7\u6c14\u5f0f\u98de\u673a")));
    }

    @Test
    public void test_starProject() {
        TestBatchSqlConnector.create(sqlService, "t", 2);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT * FROM t", Arrays.asList(new SqlTestSupport.Row(0), new SqlTestSupport.Row(1)));
    }

    @Test
    public void test_starProjectProject() {
        TestBatchSqlConnector.create(sqlService, "t", 2);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT * FROM (SELECT * FROM t)", Arrays.asList(new SqlTestSupport.Row(0), new SqlTestSupport.Row(1)));
    }

    @Test
    public void test_starProjectFilterProjectFilter() {
        TestBatchSqlConnector.create(sqlService, "t", 2);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT * FROM (SELECT * FROM t WHERE 0 = 0) WHERE 1 = 1", Arrays.asList(new SqlTestSupport.Row(0), new SqlTestSupport.Row(1)));
    }

    @Test
    public void test_starProjectFilterExpressionProjectFilter() {
        TestBatchSqlConnector.create(sqlService, "t", 2);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT * FROM (SELECT * FROM t WHERE 0 = 0) WHERE 2 - 1 = 1", Arrays.asList(new SqlTestSupport.Row(0), new SqlTestSupport.Row(1)));
    }

    @Test
    public void test_project() {
        TestBatchSqlConnector.create(sqlService, "t", 2);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT v, v FROM t", Arrays.asList(new SqlTestSupport.Row(0, 0), new SqlTestSupport.Row(1, 1)));
    }

    @Test
    public void test_projectProject() {
        TestBatchSqlConnector.create(sqlService, "t", 2);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT f2, f1 FROM (SELECT v f1, v f2 FROM t)", Arrays.asList(new SqlTestSupport.Row(0, 0), new SqlTestSupport.Row(1, 1)));
    }

    @Test
    public void test_projectExpression() {
        TestBatchSqlConnector.create(sqlService, "t", 2);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT v + 1, v * v FROM t", Arrays.asList(new SqlTestSupport.Row(1L, 0L), new SqlTestSupport.Row(2L, 1L)));
    }

    @Test
    public void test_projectFilter() {
        TestBatchSqlConnector.create(sqlService, "t", 3);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT v, v FROM t WHERE v = 1 OR v = 2", Arrays.asList(new SqlTestSupport.Row(1, 1), new SqlTestSupport.Row(2, 2)));
    }

    @Test
    public void test_projectFilterExpression() {
        TestBatchSqlConnector.create(sqlService, "t", 3);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT v, v FROM t WHERE v + v > 1", Arrays.asList(new SqlTestSupport.Row(1, 1), new SqlTestSupport.Row(2, 2)));
    }

    @Test
    public void test_projectExpressionFilter() {
        TestBatchSqlConnector.create(sqlService, "t", 3);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT v + 1, v + v FROM t WHERE v >= 1", Arrays.asList(new SqlTestSupport.Row(2L, 2L), new SqlTestSupport.Row(3L, 4L)));
    }

    @Test
    public void test_projectExpressionFilterExpression() {
        TestBatchSqlConnector.create(sqlService, "t", 3);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT v + 1, v + v FROM t WHERE v + v > 1", Arrays.asList(new SqlTestSupport.Row(2L, 2L), new SqlTestSupport.Row(3L, 4L)));
    }

    @Test
    public void test_projectProjectExpression() {
        TestBatchSqlConnector.create(sqlService, "t", 2);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT f2, f1 FROM (SELECT v f1, v + v f2 FROM t)", Arrays.asList(new SqlTestSupport.Row(0L, 0), new SqlTestSupport.Row(2L, 1)));
    }

    @Test
    public void test_projectExpressionProject() {
        TestBatchSqlConnector.create(sqlService, "t", 2);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT f1 + f2 FROM (SELECT v f1, v f2 FROM t)", Arrays.asList(new SqlTestSupport.Row(0L), new SqlTestSupport.Row(2L)));
    }

    @Test
    public void test_projectExpressionProjectExpression() {
        TestBatchSqlConnector.create(sqlService, "t", 2);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT f1 + f2 FROM (SELECT v f1, v + v f2 FROM t)", Arrays.asList(new SqlTestSupport.Row(0L), new SqlTestSupport.Row(3L)));
    }

    @Test
    public void test_projectProjectFilter() {
        TestBatchSqlConnector.create(sqlService, "t", 3);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT f2, f1 FROM (SELECT v f1, v f2 FROM t WHERE v >= 1)", Arrays.asList(new SqlTestSupport.Row(1, 1), new SqlTestSupport.Row(2, 2)));
    }

    @Test
    public void test_projectProjectFilterExpression() {
        TestBatchSqlConnector.create(sqlService, "t", 3);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT f2, f1 FROM (SELECT v f1, v f2 FROM t WHERE v + v > 1)", Arrays.asList(new SqlTestSupport.Row(1, 1), new SqlTestSupport.Row(2, 2)));
    }

    @Test
    public void test_projectProjectExpressionFilter() {
        TestBatchSqlConnector.create(sqlService, "t", 3);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT f2, f1 FROM (SELECT v f1, v + v f2 FROM t WHERE v >= 1)", Arrays.asList(new SqlTestSupport.Row(2L, 1), new SqlTestSupport.Row(4L, 2)));
    }

    @Test
    public void test_projectProjectExpressionFilterExpression() {
        TestBatchSqlConnector.create(sqlService, "t", 3);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT f2, f1 FROM (SELECT v f1, v + v f2 FROM t WHERE v + v > 1)", Arrays.asList(new SqlTestSupport.Row(2L, 1), new SqlTestSupport.Row(4L, 2)));
    }

    @Test
    public void test_projectExpressionProjectFilter() {
        TestBatchSqlConnector.create(sqlService, "t", 3);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT f1 + f2 FROM (SELECT v f1, v f2 FROM t WHERE v >= 1)", Arrays.asList(new SqlTestSupport.Row(2L), new SqlTestSupport.Row(4L)));
    }

    @Test
    public void test_projectExpressionProjectFilterExpression() {
        TestBatchSqlConnector.create(sqlService, "t", 3);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT f1 + f2 FROM (SELECT v f1, v f2 FROM t WHERE v + v > 1)", Arrays.asList(new SqlTestSupport.Row(2L), new SqlTestSupport.Row(4L)));
    }

    @Test
    public void test_projectExpressionProjectExpressionFilter() {
        TestBatchSqlConnector.create(sqlService, "t", 3);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT f1 + f2 FROM (SELECT v f1, v + v f2 FROM t WHERE v >= 1)", Arrays.asList(new SqlTestSupport.Row(3L), new SqlTestSupport.Row(6L)));
    }

    @Test
    public void test_projectExpressionProjectExpressionFilterExpression() {
        TestBatchSqlConnector.create(sqlService, "t", 3);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT f1 + f2 FROM (SELECT v f1, v + v f2 FROM t WHERE v + v > 1)", Arrays.asList(new SqlTestSupport.Row(3L), new SqlTestSupport.Row(6L)));
    }

    @Test
    public void test_projectFilterProject() {
        TestBatchSqlConnector.create(sqlService, "t", 3);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT f2, f1 FROM (SELECT v f1, v f2 FROM t) WHERE f2 >= 1", Arrays.asList(new SqlTestSupport.Row(1, 1), new SqlTestSupport.Row(2, 2)));
    }

    @Test
    public void test_projectFilterExpressionProject() {
        TestBatchSqlConnector.create(sqlService, "t", 3);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT f2, f1 FROM (SELECT v f1, v f2 FROM t) WHERE f1 + f2 > 1", Arrays.asList(new SqlTestSupport.Row(1, 1), new SqlTestSupport.Row(2, 2)));
    }

    @Test
    public void test_projectFilterProjectExpression() {
        TestBatchSqlConnector.create(sqlService, "t", 3);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT f2, f1 FROM (SELECT v f1, v + v f2 FROM t) WHERE f1 >= 1", Arrays.asList(new SqlTestSupport.Row(2L, 1), new SqlTestSupport.Row(4L, 2)));
    }

    @Test
    public void test_projectFilterExpressionProjectExpression() {
        TestBatchSqlConnector.create(sqlService, "t", 3);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT f2, f1 FROM (SELECT v f1, v + v f2 FROM t) WHERE f1 + f2 > 2", Arrays.asList(new SqlTestSupport.Row(2L, 1), new SqlTestSupport.Row(4L, 2)));
    }

    @Test
    public void test_projectExpressionFilterProject() {
        TestBatchSqlConnector.create(sqlService, "t", 3);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT f1 + f2 FROM (SELECT v f1, v f2 FROM t) WHERE f2 >= 1", Arrays.asList(new SqlTestSupport.Row(2L), new SqlTestSupport.Row(4L)));
    }

    @Test
    public void test_projectExpressionFilterExpressionProject() {
        TestBatchSqlConnector.create(sqlService, "t", 3);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT f1 + f2 FROM (SELECT v f1, v f2 FROM t) WHERE f1 + f2 > 1", Arrays.asList(new SqlTestSupport.Row(2L), new SqlTestSupport.Row(4L)));
    }

    @Test
    public void test_projectExpressionFilterProjectExpression() {
        TestBatchSqlConnector.create(sqlService, "t", 3);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT f1 + f2 FROM (SELECT v f1, v + v f2 FROM t) WHERE f1 >= 1", Arrays.asList(new SqlTestSupport.Row(3L), new SqlTestSupport.Row(6L)));
    }

    @Test
    public void test_projectExpressionFilterExpressionProjectExpression() {
        TestBatchSqlConnector.create(sqlService, "t", 3);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT f1 + f2 FROM (SELECT v f1, v + v f2 FROM t) WHERE f1 + f2 > 1", Arrays.asList(new SqlTestSupport.Row(3L), new SqlTestSupport.Row(6L)));
    }

    @Test
    public void test_projectFilterProjectFilter() {
        TestBatchSqlConnector.create(sqlService, "t", 4);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT f2, f1 FROM (SELECT v f1, v f2 FROM t WHERE v >= 1) WHERE f2 < 3", Arrays.asList(new SqlTestSupport.Row(1, 1), new SqlTestSupport.Row(2, 2)));
    }

    @Test
    public void test_projectFilterProjectExpressionFilter() {
        TestBatchSqlConnector.create(sqlService, "t", 4);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT f1 FROM (SELECT v f1, v + v f2 FROM t WHERE v >= 1) WHERE f2 < 6", Arrays.asList(new SqlTestSupport.Row(1), new SqlTestSupport.Row(2)));
    }

    @Test
    public void test_projectExpressionFilterProjectFilter() {
        TestBatchSqlConnector.create(sqlService, "t", 4);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT f1 + f2 FROM (SELECT v f1, v f2 FROM t WHERE v >= 1) WHERE f2 < 3", Arrays.asList(new SqlTestSupport.Row(2L), new SqlTestSupport.Row(4L)));
    }

    @Test
    public void test_projectExpressionFilterProjectExpressionFilter() {
        TestBatchSqlConnector.create(sqlService, "t", 4);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT f1 + f2 FROM (SELECT v f1, v + v f2 FROM t WHERE v >= 1) WHERE f2 < 6", Arrays.asList(new SqlTestSupport.Row(3L), new SqlTestSupport.Row(6L)));
    }

    @Test
    public void test_projectExpressionFilterExpressionProjectExpressionFilterExpression() {
        TestBatchSqlConnector.create(sqlService, "t", 4);
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT f1 + f2 FROM (SELECT v f1, v + v f2 FROM t WHERE v + v > 1) WHERE f1 + f2 < 9", Arrays.asList(new SqlTestSupport.Row(3L), new SqlTestSupport.Row(6L)));
    }

    @Test
    public void test_explicitTable() {
        TestBatchSqlConnector.create(sqlService, "t", 2);
        SqlFilterProjectTest.assertRowsAnyOrder("table t", SqlFilterProjectTest.rows(1, 0, 1));
        SqlFilterProjectTest.assertRowsAnyOrder("(table t)", SqlFilterProjectTest.rows(1, 0, 1));
        SqlFilterProjectTest.assertRowsAnyOrder("select * from (table t) t", SqlFilterProjectTest.rows(1, 0, 1));
    }

    @Test
    public void test_queryMetadata() {
        TestAllTypesSqlConnector.create(sqlService, "t");
        SqlResult result = sqlService.execute("SELECT * FROM t", new Object[0]);
        Assertions.assertThat((long)result.updateCount()).isEqualTo(-1L);
        Assertions.assertThat((int)result.getRowMetadata().getColumnCount()).isEqualTo(15);
        Assertions.assertThat((String)result.getRowMetadata().getColumn(0).getName()).isEqualTo("string");
        Assertions.assertThat((Comparable)result.getRowMetadata().getColumn(0).getType()).isEqualTo((Object)SqlColumnType.VARCHAR);
        Assertions.assertThat((String)result.getRowMetadata().getColumn(1).getName()).isEqualTo("boolean");
        Assertions.assertThat((Comparable)result.getRowMetadata().getColumn(1).getType()).isEqualTo((Object)SqlColumnType.BOOLEAN);
        Assertions.assertThat((String)result.getRowMetadata().getColumn(2).getName()).isEqualTo("byte");
        Assertions.assertThat((Comparable)result.getRowMetadata().getColumn(2).getType()).isEqualTo((Object)SqlColumnType.TINYINT);
        Assertions.assertThat((String)result.getRowMetadata().getColumn(3).getName()).isEqualTo("short");
        Assertions.assertThat((Comparable)result.getRowMetadata().getColumn(3).getType()).isEqualTo((Object)SqlColumnType.SMALLINT);
        Assertions.assertThat((String)result.getRowMetadata().getColumn(4).getName()).isEqualTo("int");
        Assertions.assertThat((Comparable)result.getRowMetadata().getColumn(4).getType()).isEqualTo((Object)SqlColumnType.INTEGER);
        Assertions.assertThat((String)result.getRowMetadata().getColumn(5).getName()).isEqualTo("long");
        Assertions.assertThat((Comparable)result.getRowMetadata().getColumn(5).getType()).isEqualTo((Object)SqlColumnType.BIGINT);
        Assertions.assertThat((String)result.getRowMetadata().getColumn(6).getName()).isEqualTo("float");
        Assertions.assertThat((Comparable)result.getRowMetadata().getColumn(6).getType()).isEqualTo((Object)SqlColumnType.REAL);
        Assertions.assertThat((String)result.getRowMetadata().getColumn(7).getName()).isEqualTo("double");
        Assertions.assertThat((Comparable)result.getRowMetadata().getColumn(7).getType()).isEqualTo((Object)SqlColumnType.DOUBLE);
        Assertions.assertThat((String)result.getRowMetadata().getColumn(8).getName()).isEqualTo("decimal");
        Assertions.assertThat((Comparable)result.getRowMetadata().getColumn(8).getType()).isEqualTo((Object)SqlColumnType.DECIMAL);
        Assertions.assertThat((String)result.getRowMetadata().getColumn(9).getName()).isEqualTo("time");
        Assertions.assertThat((Comparable)result.getRowMetadata().getColumn(9).getType()).isEqualTo((Object)SqlColumnType.TIME);
        Assertions.assertThat((String)result.getRowMetadata().getColumn(10).getName()).isEqualTo("date");
        Assertions.assertThat((Comparable)result.getRowMetadata().getColumn(10).getType()).isEqualTo((Object)SqlColumnType.DATE);
        Assertions.assertThat((String)result.getRowMetadata().getColumn(11).getName()).isEqualTo("timestamp");
        Assertions.assertThat((Comparable)result.getRowMetadata().getColumn(11).getType()).isEqualTo((Object)SqlColumnType.TIMESTAMP);
        Assertions.assertThat((String)result.getRowMetadata().getColumn(12).getName()).isEqualTo("timestampTz");
        Assertions.assertThat((Comparable)result.getRowMetadata().getColumn(12).getType()).isEqualTo((Object)SqlColumnType.TIMESTAMP_WITH_TIME_ZONE);
        Assertions.assertThat((String)result.getRowMetadata().getColumn(13).getName()).isEqualTo("map");
        Assertions.assertThat((Comparable)result.getRowMetadata().getColumn(13).getType()).isEqualTo((Object)SqlColumnType.OBJECT);
        Assertions.assertThat((String)result.getRowMetadata().getColumn(14).getName()).isEqualTo("object");
        Assertions.assertThat((Comparable)result.getRowMetadata().getColumn(14).getType()).isEqualTo((Object)SqlColumnType.OBJECT);
    }

    @Test
    public void test_sinkMetadata() {
        SqlFilterProjectTest.createMapping("m", Integer.class, Integer.class);
        SqlResult result = sqlService.execute("SINK INTO m(__key, this) VALUES (1, 1), (2, 2)", new Object[0]);
        Assertions.assertThat((long)result.updateCount()).isEqualTo(0L);
    }

    @Test
    public void test_dynamicParameterMetadata() {
        TestBatchSqlConnector.create(sqlService, "t", 1);
        SqlResult result = sqlService.execute("SELECT CAST(? AS VARCHAR) FROM t", new Object[]{1});
        Assertions.assertThat((int)result.getRowMetadata().getColumnCount()).isEqualTo(1);
        Assertions.assertThat((Comparable)result.getRowMetadata().getColumn(0).getType()).isEqualTo((Object)SqlColumnType.VARCHAR);
    }

    @Test
    public void test_dynamicParameterCountMismatch() {
        TestBatchSqlConnector.create(sqlService, "t", 1);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT CAST(? AS VARCHAR) FROM t", new Object[]{1, 2})).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Unexpected parameter count: expected 1, got 2");
    }

    @Test
    public void test_selectByKey_deoptToFullScan() {
        String mapOneName = "mapOne";
        SqlFilterProjectTest.createMapping(mapOneName, Integer.TYPE, String.class);
        String mapTwoName = "mapTwo";
        SqlFilterProjectTest.createMapping(mapTwoName, Integer.TYPE, String.class);
        SqlFilterProjectTest.instance().getMap(mapOneName).put((Object)1, (Object)"value-1");
        SqlFilterProjectTest.instance().getMap(mapOneName).put((Object)2, (Object)"value-2");
        SqlFilterProjectTest.instance().getMap(mapOneName).put((Object)3, (Object)"value-3");
        SqlFilterProjectTest.instance().getMap(mapTwoName).put((Object)1, (Object)"value-1");
        SqlFilterProjectTest.instance().getMap(mapTwoName).put((Object)2, (Object)"value-2");
        SqlFilterProjectTest.instance().getMap(mapTwoName).put((Object)3, (Object)"value-3");
        SqlFilterProjectTest.assertRowsAnyOrder("SELECT o.this as mId FROM mapOne AS o JOIN mapTwo AS a ON o.__key = a.__key WHERE a.__key IN (1)", Collections.singletonList(new SqlTestSupport.Row("value-1")));
    }

    @Test
    public void test_selectByKey_keyNotSelected() {
        IMap map = SqlFilterProjectTest.instance().getMap("test");
        map.put((Object)1L, (Object)new Person(10, "foo"));
        SqlFilterProjectTest.createMapping("test", Long.class, Person.class);
        SqlFilterProjectTest.assertRowsAnyOrder("select name from test where __key = 1", Collections.singletonList(new SqlTestSupport.Row("foo")));
    }

    @Test
    public void test_filterSpecificValueOrNull() {
        String mapName = "test";
        SqlFilterProjectTest.createMapping(mapName, Integer.class, Person.class);
        IMap map = SqlFilterProjectTest.instance().getMap(mapName);
        map.put((Object)42, (Object)new Person(42, null));
        map.put((Object)43, (Object)new Person(43, "foo"));
        SqlFilterProjectTest.assertRowsAnyOrder("select name from " + mapName + " where name is null or name='foo'", SqlFilterProjectTest.rows(1, null, "foo"));
        SqlFilterProjectTest.assertRowsAnyOrder("select __key from " + mapName + " where name is null or name='foo'", SqlFilterProjectTest.rows(1, 42, 43));
    }
}

