/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.map.IMap;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.sql.impl.ResultIterator;
import com.hazelcast.sql.impl.client.SqlClientResult;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.function.ThrowingRunnable;

@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlClientResultTest
extends SqlTestSupport {
    private static final String MAP_NAME = "map";

    @BeforeClass
    public static void setUpClass() {
        SqlClientResultTest.initializeWithClient((int)1, null, null);
    }

    @Before
    public void before() {
        SqlClientResultTest.createMapping(MAP_NAME, Integer.TYPE, Integer.TYPE);
        IMap map = SqlClientResultTest.instance().getMap(MAP_NAME);
        map.put(0, 0);
        map.put(1, 1);
    }

    @Test
    public void when_executingValidQuery() {
        try (SqlResult result = this.execute("SELECT * FROM map");){
            Assert.assertEquals((long)2L, (long)result.getRowMetadata().getColumnCount());
            Assert.assertEquals((long)-1L, (long)result.updateCount());
            Assert.assertTrue((boolean)result.isRowSet());
            Iterator iterator = result.iterator();
            iterator.next();
            iterator.next();
            Assert.assertFalse((boolean)iterator.hasNext());
            this.checkIllegalStateException(() -> ((SqlResult)result).iterator(), "Iterator can be requested only once");
        }
    }

    @Test
    public void when_executingInvalidQuery_then_fail() {
        this.checkSqlException(() -> this.execute("SELECT * FROM map_bad"), 1010, "Object 'map_bad' not found");
    }

    @Test
    public void when_fetchingElementOnClosedResult_then_fail() {
        try (SqlResult result = this.execute("SELECT * FROM map");){
            Assert.assertEquals((long)2L, (long)result.getRowMetadata().getColumnCount());
            Assert.assertEquals((long)-1L, (long)result.updateCount());
            Assert.assertTrue((boolean)result.isRowSet());
            Iterator iterator = result.iterator();
            iterator.next();
            result.close();
            this.checkSqlException(iterator::hasNext, 1003, "Query was cancelled by the user");
            this.checkSqlException(iterator::next, 1003, "Query was cancelled by the user");
        }
    }

    @Test
    public void when_checkingHasNextWithTimeout_then_timeoutOccurs() {
        try (SqlResult result = this.execute("select * from table(generate_stream(1))");){
            Assert.assertTrue((boolean)result.isRowSet());
            ResultIterator iterator = (ResultIterator)result.iterator();
            int timeoutCount = 0;
            for (int i = 0; i < 2; ++i) {
                while (iterator.hasNext(10L, TimeUnit.MILLISECONDS) == ResultIterator.HasNextResult.TIMEOUT) {
                    ++timeoutCount;
                }
                iterator.next();
            }
            Assert.assertNotEquals((long)0L, (long)timeoutCount);
        }
    }

    @Test
    public void when_checkingHasNextWithTimeout_then_timeoutIsLongerThanParam() {
        try (SqlResult result = this.execute("select * from table(generate_stream(1))");){
            Assert.assertTrue((boolean)result.isRowSet());
            ResultIterator iterator = (ResultIterator)result.iterator();
            long shortestSleep = Long.MAX_VALUE;
            for (int i = 0; i < 2; ++i) {
                long startNanos = System.nanoTime();
                while (iterator.hasNext(10L, TimeUnit.MILLISECONDS) == ResultIterator.HasNextResult.TIMEOUT) {
                    shortestSleep = Math.min(shortestSleep, System.nanoTime() - startNanos);
                    startNanos = System.nanoTime();
                }
                iterator.next();
            }
            SqlClientResultTest.assertGreaterOrEquals((String)"shortestSleep", (long)shortestSleep, (long)TimeUnit.MILLISECONDS.toNanos(10L));
        }
    }

    @Test
    public void when_executingQuery_then_isInfiniteRowsIsSet() {
        SqlClientResult sqlClientResult;
        try (SqlResult result = this.execute("select * from table(generate_stream(1))");){
            sqlClientResult = (SqlClientResult)result;
            Assert.assertTrue((boolean)sqlClientResult.isInfiniteRows());
        }
        result = this.execute("select * from map");
        try {
            sqlClientResult = (SqlClientResult)result;
            Assert.assertFalse((boolean)sqlClientResult.isInfiniteRows());
        }
        finally {
            if (result != null) {
                result.close();
            }
        }
    }

    private void checkSqlException(ThrowingRunnable task, int expectedCode, String expectedMessage) {
        HazelcastSqlException err = (HazelcastSqlException)SqlClientResultTest.assertThrows(HazelcastSqlException.class, (ThrowingRunnable)task);
        Assert.assertEquals((long)expectedCode, (long)err.getCode());
        Assert.assertTrue((String)err.getMessage(), (boolean)err.getMessage().contains(expectedMessage));
    }

    private void checkIllegalStateException(ThrowingRunnable task, String expectedMessage) {
        IllegalStateException err = (IllegalStateException)SqlClientResultTest.assertThrows(IllegalStateException.class, (ThrowingRunnable)task);
        Assert.assertEquals((Object)expectedMessage, (Object)err.getMessage());
    }

    private SqlResult execute(String sql) {
        return SqlClientResultTest.client().getSql().execute(new SqlStatement(sql).setCursorBufferSize(1));
    }
}

