package com.hazelcast.shaded.org.checkerframework.checker.propkey.qual;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import com.hazelcast.shaded.org.checkerframework.framework.qual.SubtypeOf;

/**
 * Indicates that the {@code String} type can be used as key in a property file or resource bundle.
 *
 * @checker_framework.manual #propkey-checker Property File Checker
 */
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE_USE, ElementType.TYPE_PARAMETER})
@SubtypeOf(UnknownPropertyKey.class)
public @interface PropertyKey {}
