/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.type.converter;

import com.hazelcast.internal.serialization.SerializableByConvention;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import com.hazelcast.sql.impl.type.converter.AbstractDecimalConverter;
import java.math.BigDecimal;
import java.math.BigInteger;

@SerializableByConvention
public final class BigIntegerConverter
extends AbstractDecimalConverter {
    public static final BigIntegerConverter INSTANCE = new BigIntegerConverter();

    private BigIntegerConverter() {
        super(5);
    }

    @Override
    public Class<?> getValueClass() {
        return BigInteger.class;
    }

    @Override
    public byte asTinyint(Object val) {
        BigInteger casted = this.cast(val);
        try {
            return casted.byteValueExact();
        }
        catch (ArithmeticException e) {
            throw this.numericOverflowError(QueryDataTypeFamily.TINYINT);
        }
    }

    @Override
    public short asSmallint(Object val) {
        BigInteger casted = this.cast(val);
        try {
            return casted.shortValueExact();
        }
        catch (ArithmeticException e) {
            throw this.numericOverflowError(QueryDataTypeFamily.SMALLINT);
        }
    }

    @Override
    public int asInt(Object val) {
        BigInteger casted = this.cast(val);
        try {
            return casted.intValueExact();
        }
        catch (ArithmeticException e) {
            throw this.numericOverflowError(QueryDataTypeFamily.INTEGER);
        }
    }

    @Override
    public long asBigint(Object val) {
        BigInteger casted = this.cast(val);
        try {
            return casted.longValueExact();
        }
        catch (ArithmeticException e) {
            throw this.numericOverflowError(QueryDataTypeFamily.BIGINT);
        }
    }

    @Override
    public BigDecimal asDecimal(Object val) {
        return new BigDecimal(this.cast(val), QueryDataTypeUtils.DECIMAL_MATH_CONTEXT);
    }

    @Override
    public float asReal(Object val) {
        return this.cast(val).floatValue();
    }

    @Override
    public double asDouble(Object val) {
        return this.cast(val).doubleValue();
    }

    @Override
    public String asVarchar(Object val) {
        return this.cast(val).toString();
    }

    private BigInteger cast(Object val) {
        return (BigInteger)val;
    }
}

