/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.schema.map;

import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.core.TypeConverter;
import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.query.impl.CompositeConverter;
import com.hazelcast.query.impl.InternalIndex;
import com.hazelcast.query.impl.TypeConverters;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.schema.map.MapTableIndex;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class MapTableUtils {
    private MapTableUtils() {
    }

    public static long estimatePartitionedMapRowCount(NodeEngine nodeEngine, MapServiceContext context, String mapName) {
        long entryCount = 0L;
        PartitionIdSet ownedPartitions = context.getCachedOwnedPartitions();
        for (PartitionContainer partitionContainer : context.getPartitionContainers()) {
            RecordStore recordStore;
            if (!ownedPartitions.contains(partitionContainer.getPartitionId()) || (recordStore = partitionContainer.getExistingRecordStore(mapName)) == null) continue;
            entryCount += (long)recordStore.size();
        }
        int memberCount = nodeEngine.getClusterService().getMembers(MemberSelectors.DATA_MEMBER_SELECTOR).size();
        return entryCount * (long)memberCount;
    }

    public static List<MapTableIndex> getPartitionedMapIndexes(MapContainer mapContainer, List<TableField> fields) {
        Map<QueryPath, Integer> pathToOrdinalMap = MapTableUtils.mapPathsToOrdinals(fields);
        if (!mapContainer.shouldUseGlobalIndex()) {
            return Collections.emptyList();
        }
        InternalIndex[] indexes = mapContainer.getGlobalIndexRegistry().getIndexes();
        if (indexes == null || indexes.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<MapTableIndex> res = new ArrayList<MapTableIndex>(indexes.length);
        for (InternalIndex index : indexes) {
            QueryDataType converterType;
            QueryDataType fieldType;
            String attribute;
            QueryPath attributePath;
            Integer ordinal;
            IndexConfig indexConfig = index.getConfig();
            List<QueryDataType> resolvedFieldConverterTypes = MapTableUtils.indexConverterToSqlTypes(index.getConverter());
            List indexAttributes = indexConfig.getAttributes();
            ArrayList<Integer> indexFieldOrdinals = new ArrayList<Integer>(indexAttributes.size());
            ArrayList<QueryDataType> indexFieldConverterTypes = new ArrayList<QueryDataType>(indexAttributes.size());
            String[] components = index.getComponents();
            for (int i = 0; i < indexAttributes.size() && (ordinal = pathToOrdinalMap.get(attributePath = QueryPath.create(attribute = (String)indexAttributes.get(i)))) != null && i < resolvedFieldConverterTypes.size() && MapTableUtils.isCompatibleForIndexRequest(fieldType = fields.get(ordinal).getType(), converterType = resolvedFieldConverterTypes.get(i)); ++i) {
                indexFieldOrdinals.add(ordinal);
                indexFieldConverterTypes.add(converterType);
            }
            MapTableIndex index0 = new MapTableIndex(indexConfig.getName(), indexConfig.getType(), components.length, indexFieldOrdinals, indexFieldConverterTypes);
            res.add(index0);
        }
        return res;
    }

    private static Map<QueryPath, Integer> mapPathsToOrdinals(List<TableField> fields) {
        HashMap<QueryPath, Integer> res = new HashMap<QueryPath, Integer>();
        for (int i = 0; i < fields.size(); ++i) {
            res.put(((MapTableField)fields.get(i)).getPath(), i);
        }
        return res;
    }

    public static List<QueryDataType> indexConverterToSqlTypes(TypeConverter converter) {
        if (converter == null) {
            return Collections.emptyList();
        }
        if (converter instanceof CompositeConverter) {
            QueryDataType type;
            CompositeConverter converter0 = (CompositeConverter)converter;
            ArrayList<QueryDataType> res = new ArrayList<QueryDataType>(converter0.getComponentCount());
            for (int i = 0; i < converter0.getComponentCount() && (type = MapTableUtils.indexConverterToSqlType(converter0.getComponentConverter(i))) != null; ++i) {
                res.add(type);
            }
            if (!res.isEmpty()) {
                return res;
            }
        } else {
            QueryDataType type = MapTableUtils.indexConverterToSqlType(converter);
            if (type != null) {
                return Collections.singletonList(type);
            }
        }
        return Collections.emptyList();
    }

    public static QueryDataType indexConverterToSqlType(TypeConverter converter) {
        if (converter == null) {
            return null;
        }
        assert (!(converter instanceof CompositeConverter)) : converter;
        if (converter == TypeConverters.BOOLEAN_CONVERTER) {
            return QueryDataType.BOOLEAN;
        }
        if (converter == TypeConverters.BYTE_CONVERTER) {
            return QueryDataType.TINYINT;
        }
        if (converter == TypeConverters.SHORT_CONVERTER) {
            return QueryDataType.SMALLINT;
        }
        if (converter == TypeConverters.INTEGER_CONVERTER) {
            return QueryDataType.INT;
        }
        if (converter == TypeConverters.LONG_CONVERTER) {
            return QueryDataType.BIGINT;
        }
        if (converter == TypeConverters.BIG_DECIMAL_CONVERTER) {
            return QueryDataType.DECIMAL;
        }
        if (converter == TypeConverters.BIG_INTEGER_CONVERTER) {
            return QueryDataType.DECIMAL_BIG_INTEGER;
        }
        if (converter == TypeConverters.FLOAT_CONVERTER) {
            return QueryDataType.REAL;
        }
        if (converter == TypeConverters.DOUBLE_CONVERTER) {
            return QueryDataType.DOUBLE;
        }
        if (converter == TypeConverters.STRING_CONVERTER) {
            return QueryDataType.VARCHAR;
        }
        if (converter == TypeConverters.CHAR_CONVERTER) {
            return QueryDataType.VARCHAR_CHARACTER;
        }
        if (converter == TypeConverters.LOCAL_TIME_CONVERTER) {
            return QueryDataType.TIME;
        }
        if (converter == TypeConverters.LOCAL_DATE_CONVERTER) {
            return QueryDataType.DATE;
        }
        if (converter == TypeConverters.LOCAL_DATE_TIME_CONVERTER) {
            return QueryDataType.TIMESTAMP;
        }
        if (converter == TypeConverters.OFFSET_DATE_TIME_CONVERTER) {
            return QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME;
        }
        if (converter == TypeConverters.ENUM_CONVERTER) {
            return QueryDataType.OBJECT;
        }
        if (converter == TypeConverters.IDENTITY_CONVERTER) {
            return QueryDataType.OBJECT;
        }
        if (converter == TypeConverters.PORTABLE_CONVERTER) {
            return QueryDataType.OBJECT;
        }
        if (converter == TypeConverters.UUID_CONVERTER) {
            return QueryDataType.OBJECT;
        }
        return null;
    }

    public static boolean isCompatibleForIndexRequest(QueryDataType columnType, QueryDataType indexConverterType) {
        if (columnType.getTypeFamily() == indexConverterType.getTypeFamily()) {
            return true;
        }
        return QueryDataTypeUtils.isNumeric(columnType) && QueryDataTypeUtils.isNumeric(indexConverterType);
    }
}

