/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.extract;

import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.AbstractGenericExtractor;
import com.hazelcast.sql.impl.extract.GenericTargetAccessor;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeMismatchException;

public class GenericFieldExtractor
extends AbstractGenericExtractor {
    private final Extractors extractors;
    private final String path;

    public GenericFieldExtractor(boolean key, GenericTargetAccessor targetAccessor, QueryDataType type, Extractors extractors, String path) {
        super(key, targetAccessor, type);
        this.extractors = extractors;
        this.path = path;
    }

    private Object getInternal(boolean useLazyDeserialization) {
        try {
            Object target = this.targetAccessor.getTargetForFieldAccess();
            Object value = this.extractors.extract(target, this.path, (Object)useLazyDeserialization, false);
            return this.type.normalize(value);
        }
        catch (QueryDataTypeMismatchException e) {
            throw QueryException.dataException((String)("Failed to extract map entry " + (this.key ? "key" : "value") + " field \"" + this.path + "\" because of type mismatch [expectedClass=" + e.getExpectedClass().getName() + ", actualClass=" + e.getActualClass().getName() + "]"));
        }
        catch (Exception e) {
            throw QueryException.dataException((String)("Failed to extract map entry " + (this.key ? "key" : "value") + " field \"" + this.path + "\": " + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public Object get() {
        return this.getInternal(false);
    }

    @Override
    public Object get(boolean useLazyDeserialization) {
        return this.getInternal(useLazyDeserialization);
    }
}

