/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.expression.Expression;
import java.io.IOException;
import java.util.Objects;

public abstract class BiExpression<T>
implements Expression<T> {
    protected Expression<?> operand1;
    protected Expression<?> operand2;

    protected BiExpression() {
    }

    protected BiExpression(Expression<?> operand1, Expression<?> operand2) {
        this.operand1 = operand1;
        this.operand2 = operand2;
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.operand1);
        out.writeObject(this.operand2);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.operand1 = (Expression)in.readObject();
        this.operand2 = (Expression)in.readObject();
    }

    public int hashCode() {
        return Objects.hash(this.operand1, this.operand2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BiExpression that = (BiExpression)o;
        return Objects.equals(this.operand1, that.operand1) && Objects.equals(this.operand2, that.operand2);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{operand1=" + String.valueOf(this.operand1) + ", operand2=" + String.valueOf(this.operand2) + "}";
    }

    @Override
    public boolean isCooperative() {
        return !(this.operand1 != null && !this.operand1.isCooperative() || this.operand2 != null && !this.operand2.isCooperative());
    }
}

