/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.geomgraph;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.IntersectionMatrix;
import com.hazelcast.shaded.org.locationtech.jts.geomgraph.Label;
import com.hazelcast.shaded.org.locationtech.jts.util.Assert;

public abstract class GraphComponent {
    protected Label label;
    private boolean isInResult = false;
    private boolean isCovered = false;
    private boolean isCoveredSet = false;
    private boolean isVisited = false;

    public GraphComponent() {
    }

    public GraphComponent(Label label) {
        this.label = label;
    }

    public Label getLabel() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public void setInResult(boolean isInResult) {
        this.isInResult = isInResult;
    }

    public boolean isInResult() {
        return this.isInResult;
    }

    public void setCovered(boolean isCovered) {
        this.isCovered = isCovered;
        this.isCoveredSet = true;
    }

    public boolean isCovered() {
        return this.isCovered;
    }

    public boolean isCoveredSet() {
        return this.isCoveredSet;
    }

    public boolean isVisited() {
        return this.isVisited;
    }

    public void setVisited(boolean isVisited) {
        this.isVisited = isVisited;
    }

    public abstract Coordinate getCoordinate();

    protected abstract void computeIM(IntersectionMatrix var1);

    public abstract boolean isIsolated();

    public void updateIM(IntersectionMatrix im) {
        Assert.isTrue(this.label.getGeometryCount() >= 2, "found partial label");
        this.computeIM(im);
    }
}

