/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.locationtech.jts.algorithm.distance;

import com.hazelcast.shaded.org.locationtech.jts.algorithm.distance.DistanceToPoint;
import com.hazelcast.shaded.org.locationtech.jts.algorithm.distance.PointPairDistance;
import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateFilter;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequence;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequenceFilter;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;

public class DiscreteHausdorffDistance {
    private Geometry g0;
    private Geometry g1;
    private PointPairDistance ptDist = new PointPairDistance();
    private double densifyFrac = 0.0;

    public static double distance(Geometry g0, Geometry g1) {
        DiscreteHausdorffDistance dist = new DiscreteHausdorffDistance(g0, g1);
        return dist.distance();
    }

    public static double distance(Geometry g0, Geometry g1, double densifyFrac) {
        DiscreteHausdorffDistance dist = new DiscreteHausdorffDistance(g0, g1);
        dist.setDensifyFraction(densifyFrac);
        return dist.distance();
    }

    public DiscreteHausdorffDistance(Geometry g0, Geometry g1) {
        this.g0 = g0;
        this.g1 = g1;
    }

    public void setDensifyFraction(double densifyFrac) {
        if (densifyFrac > 1.0 || densifyFrac <= 0.0) {
            throw new IllegalArgumentException("Fraction is not in range (0.0 - 1.0]");
        }
        this.densifyFrac = densifyFrac;
    }

    public double distance() {
        this.compute(this.g0, this.g1);
        return this.ptDist.getDistance();
    }

    public double orientedDistance() {
        this.computeOrientedDistance(this.g0, this.g1, this.ptDist);
        return this.ptDist.getDistance();
    }

    public Coordinate[] getCoordinates() {
        return this.ptDist.getCoordinates();
    }

    private void compute(Geometry g0, Geometry g1) {
        this.computeOrientedDistance(g0, g1, this.ptDist);
        this.computeOrientedDistance(g1, g0, this.ptDist);
    }

    private void computeOrientedDistance(Geometry discreteGeom, Geometry geom, PointPairDistance ptDist) {
        MaxPointDistanceFilter distFilter = new MaxPointDistanceFilter(geom);
        discreteGeom.apply(distFilter);
        ptDist.setMaximum(distFilter.getMaxPointDistance());
        if (this.densifyFrac > 0.0) {
            MaxDensifiedByFractionDistanceFilter fracFilter = new MaxDensifiedByFractionDistanceFilter(geom, this.densifyFrac);
            discreteGeom.apply(fracFilter);
            ptDist.setMaximum(fracFilter.getMaxPointDistance());
        }
    }

    public static class MaxDensifiedByFractionDistanceFilter
    implements CoordinateSequenceFilter {
        private PointPairDistance maxPtDist = new PointPairDistance();
        private PointPairDistance minPtDist = new PointPairDistance();
        private Geometry geom;
        private int numSubSegs = 0;

        public MaxDensifiedByFractionDistanceFilter(Geometry geom, double fraction) {
            this.geom = geom;
            this.numSubSegs = (int)Math.rint(1.0 / fraction);
        }

        @Override
        public void filter(CoordinateSequence seq, int index) {
            if (index == 0) {
                return;
            }
            Coordinate p0 = seq.getCoordinate(index - 1);
            Coordinate p1 = seq.getCoordinate(index);
            double delx = (p1.x - p0.x) / (double)this.numSubSegs;
            double dely = (p1.y - p0.y) / (double)this.numSubSegs;
            for (int i = 0; i < this.numSubSegs; ++i) {
                double x = p0.x + (double)i * delx;
                double y = p0.y + (double)i * dely;
                Coordinate pt = new Coordinate(x, y);
                this.minPtDist.initialize();
                DistanceToPoint.computeDistance(this.geom, pt, this.minPtDist);
                this.maxPtDist.setMaximum(this.minPtDist);
            }
        }

        @Override
        public boolean isGeometryChanged() {
            return false;
        }

        @Override
        public boolean isDone() {
            return false;
        }

        public PointPairDistance getMaxPointDistance() {
            return this.maxPtDist;
        }
    }

    public static class MaxPointDistanceFilter
    implements CoordinateFilter {
        private PointPairDistance maxPtDist = new PointPairDistance();
        private PointPairDistance minPtDist = new PointPairDistance();
        private DistanceToPoint euclideanDist = new DistanceToPoint();
        private Geometry geom;

        public MaxPointDistanceFilter(Geometry geom) {
            this.geom = geom;
        }

        @Override
        public void filter(Coordinate pt) {
            this.minPtDist.initialize();
            DistanceToPoint.computeDistance(this.geom, pt, this.minPtDist);
            this.maxPtDist.setMaximum(this.minPtDist);
        }

        public PointPairDistance getMaxPointDistance() {
            return this.maxPtDist;
        }
    }
}

