/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.sql.type;

import com.hazelcast.shaded.org.apache.calcite.sql.SqlCallBinding;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIntervalQualifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlSingleOperandTypeChecker;
import com.hazelcast.shaded.org.apache.calcite.util.Static;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import java.util.function.Predicate;

public class IntervalOperandTypeChecker
implements SqlSingleOperandTypeChecker {
    private final Predicate<SqlIntervalQualifier> predicate;

    IntervalOperandTypeChecker(Predicate<SqlIntervalQualifier> predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean checkSingleOperandType(SqlCallBinding callBinding, SqlNode operand, int iFormalOperand, boolean throwOnFailure) {
        if (operand instanceof SqlIntervalQualifier) {
            SqlIntervalQualifier interval = (SqlIntervalQualifier)operand;
            if (this.predicate.test(interval)) {
                return true;
            }
            if (throwOnFailure) {
                String name = Util.first(interval.timeFrameName, interval.timeUnitRange.name());
                throw callBinding.getValidator().newValidationError(operand, Static.RESOURCE.invalidTimeFrame(name));
            }
        }
        return false;
    }

    @Override
    public String getAllowedSignatures(SqlOperator op, String opName) {
        return "<INTERVAL>";
    }
}

