/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.runtime;

import com.hazelcast.shaded.org.locationtech.jts.geom.Coordinate;
import com.hazelcast.shaded.org.locationtech.jts.geom.CoordinateSequence;
import com.hazelcast.shaded.org.locationtech.jts.geom.Geometry;
import com.hazelcast.shaded.org.locationtech.jts.geom.impl.CoordinateArraySequence;
import com.hazelcast.shaded.org.locationtech.jts.geom.util.GeometryTransformer;
import java.util.ArrayList;

public class RemoveRepeatedPointsTransformer
extends GeometryTransformer {
    private double tolerance = 0.0;

    public RemoveRepeatedPointsTransformer() {
    }

    public RemoveRepeatedPointsTransformer(double tolerance) {
        this.tolerance = tolerance;
    }

    @Override
    protected CoordinateSequence transformCoordinates(CoordinateSequence coordinates, Geometry parent) {
        ArrayList<Coordinate> list = new ArrayList<Coordinate>();
        Coordinate previous = coordinates.getCoordinate(0);
        list.add(previous);
        for (int i = 1; i < coordinates.size(); ++i) {
            Coordinate current = coordinates.getCoordinate(i);
            double distance = current.distance(previous);
            if (!(distance > this.tolerance)) continue;
            list.add(current);
            previous = current;
        }
        Coordinate last = coordinates.getCoordinate(coordinates.size() - 1);
        double distance = last.distance(previous);
        if (distance <= this.tolerance) {
            list.set(list.size() - 1, last);
        }
        Coordinate[] array = list.toArray(new Coordinate[list.size()]);
        return new CoordinateArraySequence(array);
    }
}

