/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.linq4j.tree;

import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Expression;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.ExpressionType;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.ExpressionWriter;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Shuttle;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Visitor;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import java.lang.reflect.Type;
import java.util.Objects;

public class UnaryExpression
extends Expression {
    public final Expression expression;

    UnaryExpression(ExpressionType nodeType, Type type, Expression expression) {
        super(nodeType, type);
        assert (expression != null) : "expression should not be null";
        this.expression = expression;
    }

    @Override
    public Expression accept(Shuttle shuttle) {
        shuttle = shuttle.preVisit(this);
        Expression expression = this.expression.accept(shuttle);
        return shuttle.visit(this, expression);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    void accept(ExpressionWriter writer, int lprec, int rprec) {
        switch (this.nodeType) {
            case Convert: {
                if (!writer.requireParentheses(this, lprec, rprec)) {
                    writer.append("(").append(this.type).append(") ");
                    this.expression.accept(writer, this.nodeType.rprec, rprec);
                }
                return;
            }
        }
        if (this.nodeType.postfix) {
            this.expression.accept(writer, lprec, this.nodeType.rprec);
            writer.append(this.nodeType.op);
        } else {
            writer.append(this.nodeType.op);
            this.expression.accept(writer, this.nodeType.lprec, rprec);
        }
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UnaryExpression that = (UnaryExpression)o;
        return this.expression.equals(that.expression);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.nodeType, this.type, this.expression});
    }
}

