/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.calcite.adapter.enumerable;

import com.hazelcast.shaded.com.google.common.cache.Cache;
import com.hazelcast.shaded.com.google.common.cache.CacheBuilder;
import com.hazelcast.shaded.org.apache.calcite.DataContext;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.EnumerableRel;
import com.hazelcast.shaded.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import com.hazelcast.shaded.org.apache.calcite.avatica.Helper;
import com.hazelcast.shaded.org.apache.calcite.config.CalciteSystemProperty;
import com.hazelcast.shaded.org.apache.calcite.interpreter.Compiler;
import com.hazelcast.shaded.org.apache.calcite.interpreter.InterpretableConvention;
import com.hazelcast.shaded.org.apache.calcite.interpreter.InterpretableRel;
import com.hazelcast.shaded.org.apache.calcite.interpreter.Node;
import com.hazelcast.shaded.org.apache.calcite.interpreter.Row;
import com.hazelcast.shaded.org.apache.calcite.interpreter.Sink;
import com.hazelcast.shaded.org.apache.calcite.linq4j.AbstractEnumerable;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Enumerable;
import com.hazelcast.shaded.org.apache.calcite.linq4j.Enumerator;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.ClassDeclaration;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.Expressions;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.FieldDeclaration;
import com.hazelcast.shaded.org.apache.calcite.linq4j.tree.VisitorImpl;
import com.hazelcast.shaded.org.apache.calcite.plan.ConventionTraitDef;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTrait;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.convert.ConverterImpl;
import com.hazelcast.shaded.org.apache.calcite.runtime.ArrayBindable;
import com.hazelcast.shaded.org.apache.calcite.runtime.Bindable;
import com.hazelcast.shaded.org.apache.calcite.runtime.Hook;
import com.hazelcast.shaded.org.apache.calcite.runtime.Typed;
import com.hazelcast.shaded.org.apache.calcite.util.Util;
import com.hazelcast.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import com.hazelcast.shaded.org.codehaus.commons.compiler.CompileException;
import com.hazelcast.shaded.org.codehaus.commons.compiler.CompilerFactoryFactory;
import com.hazelcast.shaded.org.codehaus.commons.compiler.ICompilerFactory;
import com.hazelcast.shaded.org.codehaus.commons.compiler.ISimpleCompiler;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;

public class EnumerableInterpretable
extends ConverterImpl
implements InterpretableRel {
    private static final Cache<String, Bindable> BINDABLE_CACHE = CacheBuilder.newBuilder().concurrencyLevel(CalciteSystemProperty.BINDABLE_CACHE_CONCURRENCY_LEVEL.value()).maximumSize(CalciteSystemProperty.BINDABLE_CACHE_MAX_SIZE.value().intValue()).build();

    protected EnumerableInterpretable(RelOptCluster cluster, RelNode input) {
        super(cluster, ConventionTraitDef.INSTANCE, cluster.traitSetOf((RelTrait)InterpretableConvention.INSTANCE), input);
    }

    @Override
    public EnumerableInterpretable copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new EnumerableInterpretable(this.getCluster(), EnumerableInterpretable.sole(inputs));
    }

    @Override
    public Node implement(InterpretableRel.InterpreterImplementor implementor) {
        Bindable bindable = EnumerableInterpretable.toBindable(implementor.internalParameters, implementor.spark, (EnumerableRel)this.getInput(), EnumerableRel.Prefer.ARRAY);
        ArrayBindable arrayBindable = EnumerableInterpretable.box(bindable);
        Enumerable<@Nullable Object[]> enumerable = arrayBindable.bind(implementor.dataContext);
        return new EnumerableNode(enumerable, implementor.compiler, this);
    }

    public static Bindable toBindable(Map<String, Object> parameters,  @Nullable CalcitePrepare.SparkHandler spark, EnumerableRel rel, EnumerableRel.Prefer prefer) {
        EnumerableRelImplementor relImplementor = new EnumerableRelImplementor(rel.getCluster().getRexBuilder(), parameters);
        ClassDeclaration expr = relImplementor.implementRoot(rel, prefer);
        String s2 = Expressions.toString(expr.memberDeclarations, "\n", false);
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            Util.debugCode(System.out, s2);
        }
        Hook.JAVA_PLAN.run(s2);
        try {
            if (spark != null && spark.enabled()) {
                return spark.compile(expr, s2);
            }
            return EnumerableInterpretable.getBindable(expr, s2, rel.getRowType().getFieldCount());
        }
        catch (Exception e) {
            throw Helper.INSTANCE.wrap("Error while compiling generated Java code:\n" + s2, e);
        }
    }

    static Bindable getBindable(ClassDeclaration expr, String classBody, int fieldCount) throws CompileException, ExecutionException, ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        ICompilerFactory compilerFactory;
        ClassLoader classLoader = Objects.requireNonNull(EnumerableInterpretable.class.getClassLoader(), "classLoader");
        try {
            compilerFactory = CompilerFactoryFactory.getDefaultCompilerFactory(classLoader);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to instantiate java compiler", e);
        }
        ISimpleCompiler compiler = compilerFactory.newSimpleCompiler();
        compiler.setParentClassLoader(classLoader);
        String s2 = "public final class " + expr.name + " implements " + (fieldCount == 1 ? Bindable.class.getCanonicalName() + ", " + Typed.class.getCanonicalName() : ArrayBindable.class.getCanonicalName()) + " {\n" + classBody + "\n}";
        if (CalciteSystemProperty.DEBUG.value().booleanValue()) {
            compiler.setDebuggingInformation(true, true, true);
        }
        if (CalciteSystemProperty.BINDABLE_CACHE_MAX_SIZE.value() != 0) {
            StaticFieldDetector detector = new StaticFieldDetector();
            expr.accept(detector);
            if (!detector.containsStaticField) {
                return BINDABLE_CACHE.get(classBody, () -> EnumerableInterpretable.compileToBindable(expr.name, s2, compiler));
            }
        }
        return EnumerableInterpretable.compileToBindable(expr.name, s2, compiler);
    }

    private static Bindable<?> compileToBindable(String className, String s2, ISimpleCompiler compiler) throws CompileException, ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        compiler.cook(s2);
        return (Bindable)compiler.getClassLoader().loadClass(className).getDeclaredConstructors()[0].newInstance(new Object[0]);
    }

    static ArrayBindable box(final Bindable bindable) {
        if (bindable instanceof ArrayBindable) {
            return (ArrayBindable)bindable;
        }
        return new ArrayBindable(){

            @Override
            public Class<Object[]> getElementType() {
                return Object[].class;
            }

            @Override
            public Enumerable<@Nullable Object[]> bind(DataContext dataContext) {
                final Enumerable enumerable = bindable.bind(dataContext);
                return new AbstractEnumerable<Object[]>(){

                    @Override
                    public Enumerator<@Nullable Object[]> enumerator() {
                        final Enumerator enumerator = enumerable.enumerator();
                        return new Enumerator<Object[]>(){

                            @Override
                            public @Nullable Object[] current() {
                                return new Object[]{enumerator.current()};
                            }

                            @Override
                            public boolean moveNext() {
                                return enumerator.moveNext();
                            }

                            @Override
                            public void reset() {
                                enumerator.reset();
                            }

                            @Override
                            public void close() {
                                enumerator.close();
                            }
                        };
                    }
                };
            }
        };
    }

    private static class EnumerableNode
    implements Node {
        private final Enumerable<@Nullable Object[]> enumerable;
        private final Sink sink;

        EnumerableNode(Enumerable<@Nullable Object[]> enumerable, Compiler compiler, EnumerableInterpretable rel) {
            this.enumerable = enumerable;
            this.sink = compiler.sink(rel);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public void run() throws InterruptedException {
            Enumerator<@Nullable T> enumerator = this.enumerable.enumerator();
            while (enumerator.moveNext()) {
                @Nullable Object[] values = (Object[])enumerator.current();
                this.sink.send(Row.of(values));
            }
        }
    }

    static class StaticFieldDetector
    extends VisitorImpl<Void> {
        boolean containsStaticField = false;

        StaticFieldDetector() {
        }

        @Override
        public Void visit(FieldDeclaration fieldDeclaration) {
            this.containsStaticField |= (fieldDeclaration.modifier & 8) != 0;
            return this.containsStaticField ? null : (Void)super.visit(fieldDeclaration);
        }
    }
}

