/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.jet.sql.impl.parse.ParserResource;
import com.hazelcast.jet.sql.impl.validate.ValidationUtil;
import com.hazelcast.jet.sql.impl.validate.operators.special.HazelcastCreateViewOperator;
import com.hazelcast.shaded.com.google.common.collect.ImmutableList;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlCreate;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.pretty.SqlPrettyWriter;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.shaded.org.apache.calcite.sql.validate.SqlValidatorScope;
import com.hazelcast.sql.impl.schema.view.View;
import java.util.List;

public class SqlCreateView
extends SqlCreate {
    private static final SqlOperator CREATE_VIEW = new HazelcastCreateViewOperator();
    private final SqlIdentifier name;
    private SqlNode query;

    public SqlCreateView(SqlParserPos pos, boolean replace, boolean ifNotExists, SqlIdentifier name, SqlNode query) {
        super(CREATE_VIEW, pos, replace, ifNotExists);
        this.name = name;
        this.query = query;
    }

    public String name() {
        return (String)this.name.names.get(this.name.names.size() - 1);
    }

    public SqlNode getQuery() {
        return this.query;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableList.of(this.name, this.query);
    }

    @Override
    public SqlOperator getOperator() {
        return CREATE_VIEW;
    }

    @Override
    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        if (this.getReplace()) {
            writer.keyword("CREATE OR REPLACE");
        } else {
            writer.keyword("CREATE");
        }
        writer.keyword("VIEW");
        if (this.ifNotExists) {
            writer.keyword("IF NOT EXISTS");
        }
        this.name.unparse(writer, leftPrec, rightPrec);
        writer.keyword("AS");
        writer.newlineAndIndent();
        this.query.unparse(writer, 0, 0);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        if (this.getReplace() && this.ifNotExists) {
            throw validator.newValidationError(this, ParserResource.RESOURCE.orReplaceWithIfNotExistsNotSupported());
        }
        if (!ValidationUtil.isCatalogObjectNameValid(this.name)) {
            throw validator.newValidationError(this.name, ParserResource.RESOURCE.viewIncorrectSchema());
        }
        this.query = validator.validate(this.query);
    }

    public static String unparse(View view) {
        SqlPrettyWriter writer = new SqlPrettyWriter(SqlPrettyWriter.config());
        writer.keyword("CREATE OR REPLACE VIEW");
        writer.identifier("hazelcast", true);
        writer.keyword(".");
        writer.identifier("public", true);
        writer.keyword(".");
        writer.identifier(view.name(), true);
        writer.keyword("AS");
        writer.newlineAndIndent();
        writer.print(view.query());
        return writer.toString();
    }
}

