/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.opt.physical.PhysicalRel;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.shaded.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.RelWriter;
import com.hazelcast.shaded.org.apache.calcite.rel.core.Join;
import com.hazelcast.shaded.org.apache.calcite.rel.core.JoinInfo;
import com.hazelcast.shaded.org.apache.calcite.rel.core.JoinRelType;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.rex.RexUtil;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.plan.node.PlanNodeSchema;
import java.util.Collections;

public abstract class JoinPhysicalRel
extends Join
implements PhysicalRel {
    public JoinPhysicalRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, JoinRelType joinType) {
        super(cluster, traitSet, Collections.emptyList(), left, right, condition, Collections.emptySet(), joinType);
    }

    @Override
    public PlanNodeSchema schema(QueryParameterMetadata parameterMetadata) {
        PlanNodeSchema leftSchema = ((PhysicalRel)this.getLeft()).schema(parameterMetadata);
        PlanNodeSchema rightSchema = ((PhysicalRel)this.getRight()).schema(parameterMetadata);
        return PlanNodeSchema.combine(leftSchema, rightSchema);
    }

    public JetJoinInfo joinInfo(QueryParameterMetadata parameterMetadata) {
        JoinInfo joinInfo = this.analyzeCondition();
        int[] leftKeys = joinInfo.leftKeys.toIntArray();
        int[] rightKeys = joinInfo.rightKeys.toIntArray();
        RexNode predicate = RexUtil.composeConjunction(this.getCluster().getRexBuilder(), joinInfo.nonEquiConditions);
        Expression<Boolean> nonEquiCondition = this.filter(this.schema(parameterMetadata), predicate, parameterMetadata);
        Expression<Boolean> condition = this.filter(this.schema(parameterMetadata), this.getCondition(), parameterMetadata);
        return new JetJoinInfo(this.getJoinType(), leftKeys, rightKeys, nonEquiCondition, condition);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("conditionType", !this.analyzeCondition().rightKeys.isEmpty() ? "equiJoin" : "nonEquiJoin");
    }
}

