/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.compact.CompactGenericRecord;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.serialization.impl.portable.PortableGenericRecord;
import com.hazelcast.jet.sql.impl.connector.map.Metadata;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.VersionedPortable;
import com.hazelcast.sql.impl.FieldUtils;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class SampleMetadataResolver {
    private SampleMetadataResolver() {
    }

    @Nullable
    static Metadata resolve(InternalSerializationService ss, Object target, boolean key) {
        try {
            if (target instanceof Data) {
                Data data = (Data)target;
                if (data.isPortable()) {
                    ClassDefinition classDefinition = ss.getPortableContext().lookupClassDefinition(data);
                    return SampleMetadataResolver.resolvePortable(classDefinition, key);
                }
                if (data.isCompact()) {
                    return SampleMetadataResolver.resolveCompact(ss.extractSchemaFromData(data), key);
                }
                if (data.isJson()) {
                    return null;
                }
                return SampleMetadataResolver.resolveJava(ss.toObject((Object)data).getClass(), key);
            }
            if (target instanceof VersionedPortable) {
                VersionedPortable portable = (VersionedPortable)target;
                ClassDefinition classDefinition = ss.getPortableContext().lookupClassDefinition(portable.getFactoryId(), portable.getClassId(), portable.getClassVersion());
                return SampleMetadataResolver.resolvePortable(classDefinition, key);
            }
            if (target instanceof Portable) {
                Portable portable = (Portable)target;
                ClassDefinition classDefinition = ss.getPortableContext().lookupClassDefinition(portable.getFactoryId(), portable.getClassId(), 0);
                return SampleMetadataResolver.resolvePortable(classDefinition, key);
            }
            if (target instanceof PortableGenericRecord) {
                return SampleMetadataResolver.resolvePortable(((PortableGenericRecord)target).getClassDefinition(), key);
            }
            if (target instanceof CompactGenericRecord) {
                return SampleMetadataResolver.resolveCompact(((CompactGenericRecord)target).getSchema(), key);
            }
            if (ss.isCompactSerializable(target)) {
                Schema schema = ss.extractSchemaFromObject(target);
                return SampleMetadataResolver.resolveCompact(schema, key);
            }
            if (target instanceof HazelcastJsonValue) {
                return null;
            }
            return SampleMetadataResolver.resolveJava(target.getClass(), key);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Metadata resolvePortable(ClassDefinition classDefinition, boolean key) {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        options.put(key ? "keyFormat" : "valueFormat", "portable");
        options.put(key ? "keyPortableFactoryId" : "valuePortableFactoryId", String.valueOf(classDefinition.getFactoryId()));
        options.put(key ? "keyPortableClassId" : "valuePortableClassId", String.valueOf(classDefinition.getClassId()));
        options.put(key ? "keyPortableClassVersion" : "valuePortableClassVersion", String.valueOf(classDefinition.getVersion()));
        return new Metadata(options);
    }

    private static Metadata resolveCompact(Schema schema, boolean key) {
        List<MappingField> fields = FieldUtils.resolveCompact(schema).entrySet().stream().map(entry -> new MappingField((String)entry.getKey(), (QueryDataType)entry.getValue(), new QueryPath((String)entry.getKey(), key).toString())).collect(Collectors.toList());
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        options.put(key ? "keyFormat" : "valueFormat", "compact");
        options.put(key ? "keyCompactTypeName" : "valueCompactTypeName", schema.getTypeName());
        return new Metadata(fields, options);
    }

    private static Metadata resolveJava(Class<?> clazz, boolean key) {
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        options.put(key ? "keyFormat" : "valueFormat", "java");
        options.put(key ? "keyJavaClass" : "valueJavaClass", clazz.getName());
        return new Metadata(options);
    }
}

