/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.jet.sql.impl.aggregate.DistinctSqlAggregation;
import com.hazelcast.jet.sql.impl.aggregate.SqlAggregation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeUtils;
import java.io.IOException;
import java.math.BigDecimal;
import javax.annotation.concurrent.NotThreadSafe;

public final class AvgSqlAggregations {
    private AvgSqlAggregations() {
    }

    public static SqlAggregation from(QueryDataType operandType, boolean distinct) {
        SqlAggregation aggregation = AvgSqlAggregations.from(operandType);
        return distinct ? new DistinctSqlAggregation(aggregation) : aggregation;
    }

    private static SqlAggregation from(QueryDataType operandType) {
        switch (operandType.getTypeFamily()) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DECIMAL: {
                return new AvgDecimalSqlAggregation();
            }
            case REAL: 
            case DOUBLE: {
                return new AvgDoubleSqlAggregation();
            }
        }
        throw QueryException.error((String)("Unexpected operand type: " + String.valueOf(operandType)));
    }

    @NotThreadSafe
    private static final class AvgDecimalSqlAggregation
    implements SqlAggregation {
        private BigDecimal sum;
        private long count;

        private AvgDecimalSqlAggregation() {
        }

        @Override
        public void accumulate(Object value) {
            this.add(value, 1L);
        }

        @Override
        public void combine(SqlAggregation other0) {
            AvgDecimalSqlAggregation other = (AvgDecimalSqlAggregation)other0;
            this.add(other.sum, other.count);
        }

        private void add(Object value, long count) {
            if (value == null) {
                return;
            }
            if (this.sum == null) {
                this.sum = BigDecimal.ZERO;
            }
            BigDecimal decimalValue = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(((Number)value).longValue());
            this.sum = this.sum.add(decimalValue, QueryDataTypeUtils.DECIMAL_MATH_CONTEXT);
            this.count += count;
        }

        @Override
        public Object collect() {
            if (this.count == 0L) {
                return null;
            }
            return this.sum.divide(QueryDataType.BIGINT.getConverter().asDecimal(this.count), QueryDataTypeUtils.DECIMAL_MATH_CONTEXT);
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeObject((Object)this.sum);
            out.writeLong(this.count);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.sum = (BigDecimal)in.readObject();
            this.count = in.readLong();
        }
    }

    @NotThreadSafe
    private static final class AvgDoubleSqlAggregation
    implements SqlAggregation {
        private double sum;
        private long count;

        private AvgDoubleSqlAggregation() {
        }

        @Override
        public void accumulate(Object value) {
            this.add(value, 1L);
        }

        @Override
        public void combine(SqlAggregation other0) {
            AvgDoubleSqlAggregation other = (AvgDoubleSqlAggregation)other0;
            this.add(other.sum, other.count);
        }

        private void add(Object value, long count) {
            if (value == null) {
                return;
            }
            this.sum += ((Number)value).doubleValue();
            this.count += count;
        }

        @Override
        public Object collect() {
            if (this.count == 0L) {
                return null;
            }
            return this.sum / QueryDataType.BIGINT.getConverter().asDouble(this.count);
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeDouble(this.sum);
            out.writeLong(this.count);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.sum = in.readDouble();
            this.count = in.readLong();
        }
    }
}

