/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.literal;

import com.hazelcast.sql.impl.calcite.validate.literal.Literal;
import com.hazelcast.sql.impl.calcite.validate.literal.NumericLiteral;
import com.hazelcast.sql.impl.calcite.validate.literal.TypedLiteral;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeFactory;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeUtils;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.NlsString;

public final class LiteralUtils {
    private LiteralUtils() {
    }

    public static Literal literal(RexNode node) {
        if (node.getKind() != SqlKind.LITERAL) {
            return null;
        }
        RexLiteral literal = (RexLiteral)node;
        return LiteralUtils.literal0(node.getType().getSqlTypeName(), literal.getValue());
    }

    public static Literal literal(SqlNode node) {
        if (node.getKind() != SqlKind.LITERAL) {
            return null;
        }
        SqlLiteral literal = (SqlLiteral)node;
        SqlTypeName typeName = literal.getTypeName();
        Object value = SqlTypeName.CHAR_TYPES.contains(typeName) ? literal.toValue() : literal.getValue();
        return LiteralUtils.literal0(typeName, value);
    }

    private static Literal literal0(SqlTypeName typeName, Object value) {
        if (typeName == SqlTypeName.SYMBOL) {
            return null;
        }
        if (HazelcastTypeUtils.isNumericType(typeName)) {
            return NumericLiteral.create(typeName, value);
        }
        if (SqlTypeName.CHAR_TYPES.contains(typeName)) {
            if (value instanceof NlsString) {
                value = ((NlsString)value).getValue();
            }
            assert (value instanceof String) : value.getClass().getName();
            return new TypedLiteral(value, SqlTypeName.VARCHAR);
        }
        return new TypedLiteral(value, typeName);
    }

    public static SqlTypeName literalTypeName(SqlNode node) {
        Literal literal = LiteralUtils.literal(node);
        return literal != null ? literal.getTypeName() : null;
    }

    public static RelDataType literalType(SqlNode node, HazelcastTypeFactory typeFactory) {
        Literal literal = LiteralUtils.literal(node);
        return literal != null ? literal.getType(typeFactory) : null;
    }
}

