/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.opt.distribution;

import com.hazelcast.sql.impl.calcite.opt.distribution.DistributionTraitDef;
import com.hazelcast.sql.impl.calcite.opt.distribution.DistributionType;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitDef;

public class DistributionTrait
implements RelTrait {
    private final DistributionTraitDef traitDef;
    private final DistributionType type;

    DistributionTrait(DistributionTraitDef traitDef, DistributionType type) {
        this.traitDef = traitDef;
        this.type = type;
    }

    public DistributionType getType() {
        return this.type;
    }

    public RelTraitDef getTraitDef() {
        return this.traitDef;
    }

    public boolean satisfies(RelTrait targetTrait) {
        if (!(targetTrait instanceof DistributionTrait)) {
            return false;
        }
        if (this.traitDef.getMemberCount() == 1) {
            return true;
        }
        DistributionTrait targetTrait0 = (DistributionTrait)targetTrait;
        if (targetTrait0.getType() == DistributionType.ANY) {
            return true;
        }
        if (this.type == DistributionType.REPLICATED && targetTrait0.getType() == DistributionType.ROOT) {
            return true;
        }
        return this.equals(targetTrait);
    }

    public boolean isFullResultSetOnAllParticipants() {
        if (this.traitDef.getMemberCount() == 1) {
            return true;
        }
        if (this.type == DistributionType.ROOT) {
            return true;
        }
        return this.type == DistributionType.REPLICATED;
    }

    public void register(RelOptPlanner planner) {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DistributionTrait other = (DistributionTrait)o;
        return this.traitDef.equals((Object)other.traitDef) && this.type == other.type;
    }

    public int hashCode() {
        return 31 * this.traitDef.hashCode() + this.type.hashCode();
    }

    public String toString() {
        return this.type.name();
    }
}

