/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.types;

import com.hazelcast.sql.impl.calcite.validate.SqlNodeUtil;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastIntegerType;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastObjectType;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeFactory;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeSystem;
import java.util.Arrays;
import java.util.Collections;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlTypeName;

public final class HazelcastInferTypes {
    public static final SqlOperandTypeInference FIRST_KNOWN = (binding, returnType, operandTypes) -> {
        RelDataType unknown = binding.getValidator().getUnknownType();
        boolean seenParameters = false;
        RelDataType known = unknown;
        for (int i = 0; i < binding.getOperandCount(); ++i) {
            RelDataType type = binding.getOperandType(i);
            if (SqlNodeUtil.isParameter(binding.operand(i))) {
                seenParameters = true;
                continue;
            }
            if (!known.equals(unknown) || HazelcastTypeSystem.typeName(type) == SqlTypeName.NULL) continue;
            known = type;
        }
        if (seenParameters && HazelcastIntegerType.supports(HazelcastTypeSystem.typeName(known))) {
            known = HazelcastTypeFactory.INSTANCE.createSqlType(SqlTypeName.BIGINT);
        }
        Arrays.fill(operandTypes, known);
    };
    public static final SqlOperandTypeInference NULLABLE_OBJECT = (binding, returnType, operandTypes) -> {
        assert (binding.getTypeFactory() == HazelcastTypeFactory.INSTANCE);
        RelDataType unknown = binding.getValidator().getUnknownType();
        for (int i = 0; i < operandTypes.length; ++i) {
            RelDataType type = binding.getOperandType(i);
            if (!unknown.equals(type) && HazelcastTypeSystem.typeName(type) == SqlTypeName.NULL) continue;
            operandTypes[i] = HazelcastObjectType.NULLABLE_INSTANCE;
        }
    };

    private HazelcastInferTypes() {
    }

    public static SqlOperandTypeInference explicit(SqlTypeName typeName) {
        return InferTypes.explicit(Collections.singletonList(HazelcastTypeFactory.INSTANCE.createSqlType(typeName)));
    }
}

