/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.opt.physical;

import com.hazelcast.sql.impl.calcite.opt.HazelcastConventions;
import com.hazelcast.sql.impl.calcite.opt.OptUtils;
import com.hazelcast.sql.impl.calcite.opt.distribution.DistributionTrait;
import com.hazelcast.sql.impl.calcite.opt.logical.MapScanLogicalRel;
import com.hazelcast.sql.impl.calcite.opt.physical.MapScanPhysicalRel;
import com.hazelcast.sql.impl.calcite.opt.physical.index.IndexResolver;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.rel.RelNode;

public final class MapScanPhysicalRule
extends RelOptRule {
    public static final RelOptRule INSTANCE = new MapScanPhysicalRule();

    private MapScanPhysicalRule() {
        super(OptUtils.single(MapScanLogicalRel.class, HazelcastConventions.LOGICAL), MapScanPhysicalRule.class.getSimpleName());
    }

    public void onMatch(RelOptRuleCall call) {
        MapScanLogicalRel scan = (MapScanLogicalRel)call.rel(0);
        PartitionedMapTable table = (PartitionedMapTable)scan.getMap();
        DistributionTrait distribution = OptUtils.getDistributionDef(scan).getTraitPartitionedUnknown();
        ArrayList<RelNode> transforms = new ArrayList<RelNode>(1);
        MapScanPhysicalRel mapScan = new MapScanPhysicalRel(scan.getCluster(), OptUtils.toPhysicalConvention(scan.getTraitSet(), distribution), scan.getTable());
        if (!table.isHd()) {
            transforms.add(mapScan);
        }
        List indexes = table.getIndexes();
        List<RelNode> indexScans = IndexResolver.createIndexScans(scan, distribution, indexes);
        transforms.addAll(indexScans);
        if (transforms.isEmpty() && table.isHd()) {
            RelNode indexScan = IndexResolver.createFullIndexScan(scan, distribution, indexes);
            if (indexScan != null) {
                transforms.add(indexScan);
            } else {
                transforms.add(mapScan);
            }
        }
        for (RelNode transform : transforms) {
            call.transformTo(transform);
        }
    }
}

