/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.validate.types;

import com.hazelcast.sql.impl.calcite.validate.types.HazelcastIntegerType;
import com.hazelcast.sql.impl.calcite.validate.types.HazelcastTypeSystem;
import java.util.function.BiFunction;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;

public final class HazelcastReturnTypes {
    public static final SqlReturnTypeInference PLUS = ReturnTypes.chain((SqlReturnTypeInference[])new SqlReturnTypeInference[]{ReturnTypes.DECIMAL_SUM_NULLABLE, binding -> HazelcastReturnTypes.integer(binding, HazelcastReturnTypes::binaryIntegerPlus), ReturnTypes.LEAST_RESTRICTIVE});
    public static final SqlReturnTypeInference MINUS = ReturnTypes.chain((SqlReturnTypeInference[])new SqlReturnTypeInference[]{ReturnTypes.DECIMAL_SUM_NULLABLE, binding -> HazelcastReturnTypes.integer(binding, HazelcastReturnTypes::binaryIntegerMinus), ReturnTypes.LEAST_RESTRICTIVE});
    public static final SqlReturnTypeInference MULTIPLY = ReturnTypes.chain((SqlReturnTypeInference[])new SqlReturnTypeInference[]{ReturnTypes.DECIMAL_PRODUCT_NULLABLE, binding -> HazelcastReturnTypes.integer(binding, HazelcastReturnTypes::integerMultiply), ReturnTypes.LEAST_RESTRICTIVE});
    public static final SqlReturnTypeInference DIVIDE = ReturnTypes.chain((SqlReturnTypeInference[])new SqlReturnTypeInference[]{ReturnTypes.DECIMAL_QUOTIENT_NULLABLE, ReturnTypes.ARG0_INTERVAL_NULLABLE, binding -> HazelcastReturnTypes.integer(binding, HazelcastReturnTypes::integerDivide), ReturnTypes.LEAST_RESTRICTIVE});
    public static final SqlReturnTypeInference UNARY_MINUS = binding -> {
        RelDataType type = binding.getOperandType(0);
        return HazelcastIntegerType.supports(HazelcastTypeSystem.typeName(type)) ? HazelcastReturnTypes.integerUnaryMinus(type) : type;
    };

    private HazelcastReturnTypes() {
    }

    public static RelDataType binaryIntegerPlus(RelDataType left, RelDataType right) {
        int leftBitWidth = HazelcastIntegerType.noOverflowBitWidthOf(left);
        int rightBitWidth = HazelcastIntegerType.noOverflowBitWidthOf(right);
        int bitWidth = Math.max(leftBitWidth, rightBitWidth);
        if (leftBitWidth != 0 && rightBitWidth != 0) {
            ++bitWidth;
        }
        return HazelcastIntegerType.of(bitWidth, left.isNullable() || right.isNullable());
    }

    public static RelDataType binaryIntegerMinus(RelDataType left, RelDataType right) {
        int leftBitWidth = HazelcastIntegerType.noOverflowBitWidthOf(left);
        int rightBitWidth = HazelcastIntegerType.noOverflowBitWidthOf(right);
        int bitWidth = Math.max(leftBitWidth, rightBitWidth);
        if (rightBitWidth != 0) {
            ++bitWidth;
        }
        if (leftBitWidth != 0 && rightBitWidth != 0) {
            ++bitWidth;
        }
        return HazelcastIntegerType.of(bitWidth, left.isNullable() || right.isNullable());
    }

    public static RelDataType integerMultiply(RelDataType left, RelDataType right) {
        int leftBitWidth = HazelcastIntegerType.noOverflowBitWidthOf(left);
        int rightBitWidth = HazelcastIntegerType.noOverflowBitWidthOf(right);
        int bitWidth = leftBitWidth == 0 || rightBitWidth == 0 ? 0 : leftBitWidth + rightBitWidth;
        return HazelcastIntegerType.of(bitWidth, left.isNullable() || right.isNullable());
    }

    public static RelDataType integerDivide(RelDataType left, RelDataType right) {
        int leftBitWidth = HazelcastIntegerType.noOverflowBitWidthOf(left);
        int bitWidth = leftBitWidth == 0 ? 0 : leftBitWidth + 1;
        return HazelcastIntegerType.of(bitWidth, left.isNullable() || right.isNullable());
    }

    public static RelDataType integerUnaryMinus(RelDataType type) {
        int typeBitWidth;
        int operandBitWidth = HazelcastIntegerType.noOverflowBitWidthOf(type);
        if (operandBitWidth == (typeBitWidth = HazelcastIntegerType.bitWidthOf(HazelcastTypeSystem.typeName(type)))) {
            ++operandBitWidth;
        }
        return HazelcastIntegerType.of(operandBitWidth, type.isNullable());
    }

    private static RelDataType integer(SqlOperatorBinding binding, BiFunction<RelDataType, RelDataType, RelDataType> strategy) {
        RelDataType left = binding.getOperandType(0);
        RelDataType right = binding.getOperandType(1);
        if (!HazelcastIntegerType.supports(HazelcastTypeSystem.typeName(left)) || !HazelcastIntegerType.supports(HazelcastTypeSystem.typeName(right))) {
            return null;
        }
        return strategy.apply(left, right);
    }
}

