/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jca;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigBuilder;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ConfigProperty;
import javax.resource.spi.Connector;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.TransactionSupport;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;

@Connector(description={"Hazelcast JCA Connection"}, displayName={"Hazelcast"}, vendorName="Hazelcast.com", eisType="Hazelcast", licenseDescription={"Copyright (c) 2008-2017, Hazelcast, Inc. All Rights Reserved."}, licenseRequired=true, transactionSupport=TransactionSupport.TransactionSupportLevel.XATransaction, version="3.8")
public class ResourceAdapterImpl
implements ResourceAdapter,
Referenceable,
Serializable {
    private static final AtomicInteger ID_GEN = new AtomicInteger();
    private static final long serialVersionUID = -1727994229521767306L;
    private volatile transient HazelcastInstance hazelcastInstance;
    private Reference reference;
    @ConfigProperty(description={"Location of the hazelcast.xml file (Client or Server)"})
    private String configurationLocation;
    @ConfigProperty(description={"Create a Hazelcast Client Instance? Defaults to false (Server)"})
    private Boolean client = Boolean.FALSE;
    private transient int id;

    public ResourceAdapterImpl() {
        this.setId(ID_GEN.incrementAndGet());
    }

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        return new XAResource[0];
    }

    public void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        if (this.client != null && this.client.booleanValue()) {
            XmlClientConfigBuilder configBuilder = this.buildClientConfiguration();
            this.hazelcastInstance = HazelcastClient.newHazelcastClient((ClientConfig)configBuilder.build());
        } else {
            ConfigBuilder config = this.buildConfiguration();
            this.hazelcastInstance = Hazelcast.newHazelcastInstance((Config)config.build());
        }
    }

    private ConfigBuilder buildConfiguration() throws ResourceAdapterInternalException {
        XmlConfigBuilder config;
        if (this.configurationLocation == null || this.configurationLocation.length() == 0) {
            config = new XmlConfigBuilder();
        } else {
            try {
                config = new XmlConfigBuilder(this.configurationLocation);
            }
            catch (FileNotFoundException e) {
                throw new ResourceAdapterInternalException(e.getMessage(), (Throwable)e);
            }
        }
        return config;
    }

    private XmlClientConfigBuilder buildClientConfiguration() throws ResourceAdapterInternalException {
        XmlClientConfigBuilder configBuilder;
        if (this.configurationLocation == null || this.configurationLocation.length() == 0) {
            configBuilder = new XmlClientConfigBuilder();
        } else {
            try {
                configBuilder = new XmlClientConfigBuilder(this.configurationLocation);
            }
            catch (IOException e) {
                throw new ResourceAdapterInternalException(e.getMessage(), (Throwable)e);
            }
        }
        return configBuilder;
    }

    public void stop() {
        HazelcastInstance instance = this.hazelcastInstance;
        if (instance != null) {
            instance.getLifecycleService().shutdown();
        }
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    public void setHazelcastInstance(HazelcastInstance hazelcast) {
        this.hazelcastInstance = hazelcast;
    }

    public Reference getReference() throws NamingException {
        if (this.reference == null) {
            throw new NamingException("reference has not been set");
        }
        return this.reference;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public String getConfigurationLocation() {
        return this.configurationLocation;
    }

    public void setConfigurationLocation(String configurationLocation) {
        this.configurationLocation = configurationLocation;
    }

    public Boolean isClient() {
        return this.client;
    }

    public void setClient(Boolean client) {
        this.client = client;
    }

    @Deprecated
    public String getConfigLocation() {
        return this.configurationLocation;
    }

    @Deprecated
    public void setConfigLocation(String configLocation) {
        this.configurationLocation = configLocation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceAdapterImpl other = (ResourceAdapterImpl)obj;
        return this.id == other.id;
    }

    public void setId(int id) {
        this.id = id;
    }
}

