/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jca;

import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigBuilder;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.resource.ResourceException;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;

public class ResourceAdapterImpl
implements ResourceAdapter,
Serializable {
    private static final AtomicInteger ID_GEN = new AtomicInteger();
    private static final long serialVersionUID = -1727994229521767306L;
    private volatile transient HazelcastInstance hazelcastInstance;
    private String configurationLocation;
    private transient int id;

    public ResourceAdapterImpl() {
        this.setId(ID_GEN.incrementAndGet());
    }

    public void endpointActivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) throws ResourceException {
    }

    public void endpointDeactivation(MessageEndpointFactory endpointFactory, ActivationSpec spec) {
    }

    public XAResource[] getXAResources(ActivationSpec[] specs) throws ResourceException {
        return new XAResource[0];
    }

    public void start(BootstrapContext ctx) throws ResourceAdapterInternalException {
        ConfigBuilder config = this.buildConfiguration();
        this.hazelcastInstance = Hazelcast.newHazelcastInstance((Config)config.build());
    }

    private ConfigBuilder buildConfiguration() throws ResourceAdapterInternalException {
        XmlConfigBuilder config;
        if (this.configurationLocation == null || this.configurationLocation.length() == 0) {
            config = new XmlConfigBuilder();
        } else {
            try {
                config = new XmlConfigBuilder(this.configurationLocation);
            }
            catch (FileNotFoundException e) {
                throw new ResourceAdapterInternalException(e.getMessage(), (Throwable)e);
            }
        }
        return config;
    }

    public void stop() {
        HazelcastInstance instance = this.hazelcastInstance;
        if (instance != null) {
            instance.getLifecycleService().shutdown();
        }
    }

    HazelcastInstance getHazelcastInstance() {
        return this.hazelcastInstance;
    }

    public void setHazelcastInstance(HazelcastInstance hazelcast) {
        this.hazelcastInstance = hazelcast;
    }

    public String getConfigurationLocation() {
        return this.configurationLocation;
    }

    public void setConfigurationLocation(String configurationLocation) {
        this.configurationLocation = configurationLocation;
    }

    @Deprecated
    public String getConfigLocation() {
        return this.configurationLocation;
    }

    @Deprecated
    public void setConfigLocation(String configLocation) {
        this.configurationLocation = configLocation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceAdapterImpl other = (ResourceAdapterImpl)obj;
        return this.id == other.id;
    }

    public void setId(int id) {
        this.id = id;
    }
}

