/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jca;

import com.hazelcast.jca.ConnectionFactoryMetaData;
import com.hazelcast.jca.HazelcastConnection;
import com.hazelcast.jca.HazelcastConnectionFactory;
import com.hazelcast.jca.ManagedConnectionFactoryImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionSpec;
import javax.resource.cci.RecordFactory;
import javax.resource.cci.ResourceAdapterMetaData;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;

public class ConnectionFactoryImpl
implements HazelcastConnectionFactory {
    private static final AtomicInteger ID_GEN = new AtomicInteger();
    private static final ILogger LOGGER = Logger.getLogger((String)"com.hazelcast.jca");
    private static final long serialVersionUID = -5909363703528221650L;
    private ManagedConnectionFactoryImpl mcf;
    private ConnectionManager cm;
    private Reference ref;
    private transient int id;

    public ConnectionFactoryImpl() {
        this.setId(ID_GEN.incrementAndGet());
    }

    public ConnectionFactoryImpl(ManagedConnectionFactoryImpl mcf, ConnectionManager cm) {
        this();
        this.mcf = mcf;
        this.cm = cm;
    }

    @Override
    public HazelcastConnection getConnection() throws ResourceException {
        LOGGER.finest("getConnection");
        return this.getConnection(null);
    }

    @Override
    public HazelcastConnection getConnection(ConnectionSpec connSpec) throws ResourceException {
        if (LOGGER.isFinestEnabled()) {
            LOGGER.finest("getConnection spec: " + connSpec);
        }
        return (HazelcastConnection)this.cm.allocateConnection((ManagedConnectionFactory)this.mcf, null);
    }

    public ResourceAdapterMetaData getMetaData() throws ResourceException {
        return new ConnectionFactoryMetaData();
    }

    public RecordFactory getRecordFactory() throws ResourceException {
        return null;
    }

    public void setReference(Reference ref) {
        this.ref = ref;
    }

    public Reference getReference() throws NamingException {
        return this.ref;
    }

    public String toString() {
        return "hazelcast.ConnectionFactoryImpl [" + this.id + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConnectionFactoryImpl other = (ConnectionFactoryImpl)obj;
        return this.id == other.id;
    }

    public void setId(int id) {
        this.id = id;
    }
}

