/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jca;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jca.HazelcastTransactionImpl;
import com.hazelcast.jca.ManagedConnectionImpl;
import com.hazelcast.transaction.TransactionContext;
import java.util.logging.Level;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceWrapper
implements XAResource {
    private final ManagedConnectionImpl managedConnection;
    private int transactionTimeoutSeconds;
    private XAResource inner;
    private volatile boolean isStarted;

    public XAResourceWrapper(ManagedConnectionImpl managedConnectionImpl) {
        this.managedConnection = managedConnectionImpl;
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        this.managedConnection.log(Level.FINEST, "XA start: " + xid);
        switch (flags) {
            case 0: {
                this.setInner();
                break;
            }
            case 0x200000: 
            case 0x8000000: {
                break;
            }
            default: {
                throw new XAException(-5);
            }
        }
        if (this.inner != null) {
            this.isStarted = true;
            this.inner.start(xid, flags);
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        this.managedConnection.log(Level.FINEST, "XA end: " + xid + ", " + flags);
        this.validateInner();
        this.inner.end(xid, flags);
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        this.managedConnection.log(Level.FINEST, "XA prepare: " + xid);
        this.validateInner();
        return this.inner.prepare(xid);
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        this.managedConnection.log(Level.FINEST, "XA commit: " + xid);
        this.validateInner();
        this.inner.commit(xid, onePhase);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.managedConnection.log(Level.FINEST, "XA rollback: " + xid);
        this.validateInner();
        this.inner.rollback(xid);
    }

    @Override
    public void forget(Xid xid) throws XAException {
        throw new XAException(-6);
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        if (xaResource instanceof XAResourceWrapper) {
            ManagedConnectionImpl otherManagedConnection = ((XAResourceWrapper)xaResource).managedConnection;
            HazelcastInstance hazelcastInstance = this.managedConnection.getHazelcastInstance();
            HazelcastInstance otherHazelcastInstance = otherManagedConnection.getHazelcastInstance();
            return hazelcastInstance != null && hazelcastInstance.equals(otherHazelcastInstance);
        }
        return false;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        if (this.inner == null) {
            this.setInner();
        }
        return this.inner.recover(flag);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeoutSeconds;
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (!this.isStarted) {
            this.transactionTimeoutSeconds = seconds;
            return true;
        }
        return false;
    }

    private final void validateInner() throws XAException {
        if (this.inner == null) {
            throw new XAException(-4);
        }
    }

    private void setInner() throws XAException {
        TransactionContext transactionContext = HazelcastTransactionImpl.createTransaction(this.getTransactionTimeout(), this.managedConnection.getHazelcastInstance());
        this.managedConnection.getTx().setTxContext(transactionContext);
        this.inner = transactionContext.getXaResource();
    }
}

