/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.protocol.generator;

import com.hazelcast.annotation.GenerateParameters;
import com.hazelcast.client.protocol.generator.Lang;
import com.hazelcast.client.protocol.generator.MessageTypeEnumModel;
import com.hazelcast.client.protocol.generator.ParameterClassModel;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"com.hazelcast.annotation.GenerateParameters"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
public class CodeGenerator
extends AbstractProcessor {
    private Filer filer;
    private Messager messager;
    private Template parameterTemplate;
    private Template parameterTemplateCSharp;
    private Template messageTypeTemplate;

    @Override
    public void init(ProcessingEnvironment env) {
        this.filer = env.getFiler();
        this.messager = env.getMessager();
        try {
            Logger.selectLoggerLibrary((int)0);
        }
        catch (ClassNotFoundException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        }
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_22);
        cfg.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(this.getClass(), "/"));
        try {
            this.parameterTemplate = cfg.getTemplate("parameter-template-java.ftl");
            this.parameterTemplateCSharp = cfg.getTemplate("parameter-template-csharp.ftl");
            this.messageTypeTemplate = cfg.getTemplate("messagetype-template-java.ftl");
        }
        catch (IOException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> elements, RoundEnvironment env) {
        for (Element element : env.getElementsAnnotatedWith(GenerateParameters.class)) {
            this.generate((TypeElement)element);
        }
        return true;
    }

    public void generate(TypeElement classElement) {
        this.generateMessageTypeEnum(classElement);
        for (Element element : classElement.getEnclosedElements()) {
            if (!element.getKind().equals((Object)ElementKind.METHOD)) continue;
            ExecutableElement methodElement = (ExecutableElement)element;
            this.generateParameterClass(classElement, methodElement);
        }
    }

    private void generateMessageTypeEnum(TypeElement classElement) {
        MessageTypeEnumModel clazz = new MessageTypeEnumModel(classElement);
        String content = this.generateFromTemplate(this.messageTypeTemplate, clazz);
        this.saveClass(clazz.getPackageName(), clazz.getClassName(), content);
    }

    private void generateParameterClassCSharp(TypeElement classElement, ExecutableElement methodElement) {
        ParameterClassModel clazz = new ParameterClassModel(classElement, methodElement, Lang.CSHARP);
        String content = this.generateFromTemplate(this.parameterTemplateCSharp, clazz);
        this.saveFile(classElement, clazz.getPackageName(), clazz.getClassName(), content);
    }

    private void generateParameterClass(TypeElement classElement, ExecutableElement methodElement) {
        ParameterClassModel clazz = new ParameterClassModel(classElement, methodElement, Lang.JAVA);
        String content = this.generateFromTemplate(this.parameterTemplate, clazz);
        this.saveClass(clazz.getPackageName(), clazz.getClassName(), content);
    }

    private void saveClass(String packageName, String className, String content) {
        try {
            String fullClassName = packageName + "." + className;
            JavaFileObject file = this.filer.createSourceFile(fullClassName, new Element[0]);
            file.openWriter().append(content).close();
        }
        catch (IOException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        }
    }

    private void saveFile(TypeElement classElement, String packageName, String className, String content) {
        try {
            String fullName = className + ".cs";
            FileObject file = this.filer.createResource(StandardLocation.locationFor(StandardLocation.SOURCE_OUTPUT.name()), packageName, fullName, classElement);
            file.openWriter().append(content).close();
        }
        catch (IOException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        }
    }

    private String generateFromTemplate(Template template, Object model) {
        String content = null;
        try {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("model", model);
            StringWriter writer = new StringWriter();
            template.process(data, (Writer)writer);
            content = writer.toString();
        }
        catch (Exception e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        }
        return content;
    }
}

