/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy.txn;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.TransactionCommitCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionCreateCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionRollbackCodec;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionNotActiveException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.util.Clock;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ThreadUtil;

final class TransactionProxy {
    private static final ThreadLocal<Boolean> TRANSACTION_EXISTS = new ThreadLocal();
    private final TransactionOptions options;
    private final HazelcastClientInstanceImpl client;
    private final long threadId = ThreadUtil.getThreadId();
    private final ClientConnection connection;
    private String txnId;
    private Transaction.State state = Transaction.State.NO_TXN;
    private long startTime;

    TransactionProxy(HazelcastClientInstanceImpl client, TransactionOptions options, ClientConnection connection) {
        this.options = options;
        this.client = client;
        this.connection = connection;
    }

    public String getTxnId() {
        return this.txnId;
    }

    public Transaction.State getState() {
        return this.state;
    }

    void begin() {
        try {
            if (this.state == Transaction.State.ACTIVE) {
                throw new IllegalStateException("Transaction is already active");
            }
            this.checkThread();
            if (TRANSACTION_EXISTS.get() != null) {
                throw new IllegalStateException("Nested transactions are not allowed!");
            }
            TRANSACTION_EXISTS.set(Boolean.TRUE);
            this.startTime = Clock.currentTimeMillis();
            ClientMessage request = TransactionCreateCodec.encodeRequest((long)this.options.getTimeoutMillis(), (int)this.options.getDurability(), (int)this.options.getTransactionType().id(), (long)this.threadId);
            ClientMessage response = this.invoke(request);
            TransactionCreateCodec.ResponseParameters result = TransactionCreateCodec.decodeResponse((ClientMessage)response);
            this.txnId = result.response;
            this.state = Transaction.State.ACTIVE;
        }
        catch (Exception e) {
            TRANSACTION_EXISTS.set(null);
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    void commit() {
        try {
            if (this.state != Transaction.State.ACTIVE) {
                throw new TransactionNotActiveException("Transaction is not active");
            }
            this.checkThread();
            this.checkTimeout();
            ClientMessage request = TransactionCommitCodec.encodeRequest((String)this.txnId, (long)this.threadId);
            this.invoke(request);
            this.state = Transaction.State.COMMITTED;
        }
        catch (Exception e) {
            this.state = Transaction.State.ROLLING_BACK;
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        finally {
            TRANSACTION_EXISTS.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollback() {
        try {
            if (this.state == Transaction.State.NO_TXN || this.state == Transaction.State.ROLLED_BACK) {
                throw new IllegalStateException("Transaction is not active");
            }
            if (this.state == Transaction.State.ROLLING_BACK) {
                this.state = Transaction.State.ROLLED_BACK;
                return;
            }
            this.checkThread();
            try {
                ClientMessage request = TransactionRollbackCodec.encodeRequest((String)this.txnId, (long)this.threadId);
                this.invoke(request);
            }
            catch (Exception ignored) {
                EmptyStatement.ignore((Throwable)ignored);
            }
            this.state = Transaction.State.ROLLED_BACK;
        }
        finally {
            TRANSACTION_EXISTS.set(null);
        }
    }

    private void checkThread() {
        if (this.threadId != Thread.currentThread().getId()) {
            throw new IllegalStateException("Transaction cannot span multiple threads!");
        }
    }

    private void checkTimeout() {
        if (this.startTime + this.options.getTimeoutMillis() < Clock.currentTimeMillis()) {
            throw new TransactionException("Transaction is timed-out!");
        }
    }

    private ClientMessage invoke(ClientMessage request) {
        try {
            ClientInvocation clientInvocation = new ClientInvocation(this.client, request, this.connection);
            ClientInvocationFuture future = clientInvocation.invoke();
            return (ClientMessage)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }
}

