/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.ICache;
import com.hazelcast.cache.impl.CacheEntryProcessorResult;
import com.hazelcast.cache.impl.CacheEventListenerAdaptor;
import com.hazelcast.cache.impl.CacheProxyUtil;
import com.hazelcast.cache.impl.client.CacheAddEntryListenerRequest;
import com.hazelcast.cache.impl.client.CacheContainsKeyRequest;
import com.hazelcast.cache.impl.client.CacheEntryProcessorRequest;
import com.hazelcast.cache.impl.client.CacheListenerRegistrationRequest;
import com.hazelcast.cache.impl.client.CacheLoadAllRequest;
import com.hazelcast.cache.impl.client.CacheRemoveEntryListenerRequest;
import com.hazelcast.cache.impl.nearcache.NearCache;
import com.hazelcast.client.cache.impl.AbstractClientCacheProxy;
import com.hazelcast.client.cache.impl.ClientClusterWideIterator;
import com.hazelcast.client.cache.impl.HazelcastClientCacheManager;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.client.BaseClientRemoveListenerRequest;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.Member;
import com.hazelcast.instance.AbstractMember;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;

public class ClientCacheProxy<K, V>
extends AbstractClientCacheProxy<K, V> {
    public ClientCacheProxy(CacheConfig<K, V> cacheConfig, ClientContext clientContext, HazelcastClientCacheManager cacheManager) {
        super(cacheConfig, clientContext, cacheManager);
    }

    public V get(K key) {
        return (V)this.get((Object)key, (ExpiryPolicy)null);
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        return this.getAll((Set)keys, (ExpiryPolicy)null);
    }

    public boolean containsKey(K key) {
        Object cached;
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        Data keyData = this.toData(key);
        Object object = cached = this.nearCache != null ? this.nearCache.get((Object)keyData) : null;
        if (cached != null && !NearCache.NULL_OBJECT.equals(cached)) {
            return true;
        }
        CacheContainsKeyRequest request = new CacheContainsKeyRequest(this.nameWithPrefix, keyData, this.cacheConfig.getInMemoryFormat());
        try {
            ICompletableFuture future = this.invoke((ClientRequest)request, keyData, false);
            return (Boolean)this.toObject(future.get());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(keys);
        for (K key : keys) {
            CacheProxyUtil.validateConfiguredTypes((CacheConfig)this.cacheConfig, key);
        }
        this.validateCacheLoader(completionListener);
        HashSet<Data> keysData = new HashSet<Data>();
        for (K key : keys) {
            keysData.add(this.toData(key));
        }
        CacheLoadAllRequest request = new CacheLoadAllRequest(this.nameWithPrefix, keysData, replaceExistingValues);
        try {
            this.submitLoadAllTask(request, completionListener);
        }
        catch (Exception e) {
            if (completionListener != null) {
                completionListener.onException(e);
            }
            throw new CacheException((Throwable)e);
        }
    }

    public void put(K key, V value) {
        this.put((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    public V getAndPut(K key, V value) {
        return (V)this.getAndPut((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.putAll((Map)map, (ExpiryPolicy)null);
    }

    public boolean putIfAbsent(K key, V value) {
        return this.putIfAbsent((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    public boolean remove(K key) {
        ICompletableFuture f = this.removeAsyncInternal(key, null, false, false, true);
        try {
            return (Boolean)f.get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
    }

    public boolean remove(K key, V oldValue) {
        ICompletableFuture f = this.removeAsyncInternal(key, oldValue, true, false, true);
        try {
            return (Boolean)f.get();
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
    }

    public V getAndRemove(K key) {
        ICompletableFuture f = this.removeAsyncInternal(key, null, false, true, true);
        try {
            return (V)this.toObject(f.get());
        }
        catch (Throwable e) {
            throw ExceptionUtil.rethrowAllowedTypeFirst((Throwable)e, CacheException.class);
        }
    }

    public boolean replace(K key, V oldValue, V newValue) {
        return this.replace((Object)key, (Object)oldValue, (Object)newValue, (ExpiryPolicy)null);
    }

    public boolean replace(K key, V value) {
        return this.replace((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    public V getAndReplace(K key, V value) {
        return (V)this.getAndReplace((Object)key, (Object)value, (ExpiryPolicy)null);
    }

    public void removeAll(Set<? extends K> keys) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(keys);
        this.removeAllInternal(keys, true);
    }

    public void removeAll() {
        this.ensureOpen();
        this.removeAllInternal(null, true);
    }

    public void clear() {
        this.ensureOpen();
        this.clearInternal();
    }

    public <C extends Configuration<K, V>> C getConfiguration(Class<C> clazz) {
        if (clazz.isInstance(this.cacheConfig)) {
            return (C)((Configuration)clazz.cast(this.cacheConfig.getAsReadOnly()));
        }
        throw new IllegalArgumentException("The configuration class " + clazz + " is not supported by this implementation");
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(key);
        if (entryProcessor == null) {
            throw new NullPointerException("Entry Processor is null");
        }
        Data keyData = this.toData(key);
        CacheEntryProcessorRequest request = new CacheEntryProcessorRequest(this.nameWithPrefix, keyData, entryProcessor, this.cacheConfig.getInMemoryFormat(), arguments);
        try {
            ICompletableFuture f = this.invoke((ClientRequest)request, keyData, true);
            Data data = (Data)this.getSafely(f);
            return this.toObject(data);
        }
        catch (CacheException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new EntryProcessorException((Throwable)e);
        }
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.ensureOpen();
        CacheProxyUtil.validateNotNull(keys);
        if (entryProcessor == null) {
            throw new NullPointerException("Entry Processor is null");
        }
        HashMap<K, CacheEntryProcessorResult> allResult = new HashMap<K, CacheEntryProcessorResult>();
        for (K key : keys) {
            CacheEntryProcessorResult ceResult;
            try {
                T result = this.invoke(key, entryProcessor, arguments);
                ceResult = result != null ? new CacheEntryProcessorResult(result) : null;
            }
            catch (Exception e) {
                ceResult = new CacheEntryProcessorResult((Throwable)e);
            }
            if (ceResult == null) continue;
            allResult.put(key, ceResult);
        }
        return allResult;
    }

    public String getName() {
        return this.name;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new IllegalArgumentException("Unwrapping to " + clazz + " is not supported by this implementation");
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.ensureOpen();
        if (cacheEntryListenerConfiguration == null) {
            throw new NullPointerException("CacheEntryListenerConfiguration can't be null");
        }
        CacheEventListenerAdaptor adaptor = new CacheEventListenerAdaptor((ICache)this, cacheEntryListenerConfiguration, this.clientContext.getSerializationService());
        EventHandler<Object> handler = this.createHandler(adaptor);
        CacheAddEntryListenerRequest registrationRequest = new CacheAddEntryListenerRequest(this.nameWithPrefix);
        String regId = this.clientContext.getListenerService().startListening((ClientRequest)registrationRequest, null, handler);
        if (regId != null) {
            this.cacheConfig.addCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
            this.addListenerLocally(regId, cacheEntryListenerConfiguration);
            this.updateCacheListenerConfigOnOtherNodes(cacheEntryListenerConfiguration, true);
        }
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        if (cacheEntryListenerConfiguration == null) {
            throw new NullPointerException("CacheEntryListenerConfiguration can't be null");
        }
        String regId = this.removeListenerLocally(cacheEntryListenerConfiguration);
        if (regId != null) {
            CacheRemoveEntryListenerRequest removeReq = new CacheRemoveEntryListenerRequest(this.nameWithPrefix, regId);
            boolean isDeregistered = this.clientContext.getListenerService().stopListening((BaseClientRemoveListenerRequest)removeReq, regId);
            if (isDeregistered) {
                this.cacheConfig.removeCacheEntryListenerConfiguration(cacheEntryListenerConfiguration);
                this.updateCacheListenerConfigOnOtherNodes(cacheEntryListenerConfiguration, false);
            } else {
                this.addListenerLocally(regId, cacheEntryListenerConfiguration);
            }
        }
    }

    protected void updateCacheListenerConfigOnOtherNodes(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration, boolean isRegister) {
        Collection<Member> members = this.clientContext.getClusterService().getMemberList();
        HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.clientContext.getHazelcastInstance();
        ArrayList<ClientInvocationFuture> futures = new ArrayList<ClientInvocationFuture>();
        for (Member member : members) {
            try {
                Address address = ((AbstractMember)member).getAddress();
                CacheListenerRegistrationRequest request = new CacheListenerRegistrationRequest(this.nameWithPrefix, cacheEntryListenerConfiguration, isRegister, address);
                ClientInvocation invocation = new ClientInvocation(client, (ClientRequest)request, address);
                ClientInvocationFuture future = invocation.invoke();
                futures.add(future);
            }
            catch (Exception e) {
                ExceptionUtil.sneakyThrow((Throwable)e);
            }
        }
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        this.ensureOpen();
        return new ClientClusterWideIterator(this, this.clientContext);
    }
}

