/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.client.BaseClientRemoveListenerRequest;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.Member;
import com.hazelcast.core.MultiMap;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.mapreduce.Collator;
import com.hazelcast.mapreduce.CombinerFactory;
import com.hazelcast.mapreduce.Job;
import com.hazelcast.mapreduce.JobCompletableFuture;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.mapreduce.KeyValueSource;
import com.hazelcast.mapreduce.Mapper;
import com.hazelcast.mapreduce.MappingJob;
import com.hazelcast.mapreduce.ReducerFactory;
import com.hazelcast.mapreduce.ReducingSubmittableJob;
import com.hazelcast.mapreduce.aggregation.Aggregation;
import com.hazelcast.mapreduce.aggregation.Supplier;
import com.hazelcast.monitor.LocalMultiMapStats;
import com.hazelcast.multimap.impl.operations.client.AddEntryListenerRequest;
import com.hazelcast.multimap.impl.operations.client.ClearRequest;
import com.hazelcast.multimap.impl.operations.client.ContainsRequest;
import com.hazelcast.multimap.impl.operations.client.CountRequest;
import com.hazelcast.multimap.impl.operations.client.EntrySetRequest;
import com.hazelcast.multimap.impl.operations.client.GetAllRequest;
import com.hazelcast.multimap.impl.operations.client.KeyBasedContainsRequest;
import com.hazelcast.multimap.impl.operations.client.KeySetRequest;
import com.hazelcast.multimap.impl.operations.client.MultiMapIsLockedRequest;
import com.hazelcast.multimap.impl.operations.client.MultiMapLockRequest;
import com.hazelcast.multimap.impl.operations.client.MultiMapUnlockRequest;
import com.hazelcast.multimap.impl.operations.client.PortableEntrySetResponse;
import com.hazelcast.multimap.impl.operations.client.PutRequest;
import com.hazelcast.multimap.impl.operations.client.RemoveAllRequest;
import com.hazelcast.multimap.impl.operations.client.RemoveEntryListenerRequest;
import com.hazelcast.multimap.impl.operations.client.RemoveRequest;
import com.hazelcast.multimap.impl.operations.client.SizeRequest;
import com.hazelcast.multimap.impl.operations.client.ValuesRequest;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.PortableCollection;
import com.hazelcast.spi.impl.PortableEntryEvent;
import com.hazelcast.util.ThreadUtil;
import com.hazelcast.util.ValidationUtil;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ClientMultiMapProxy<K, V>
extends ClientProxy
implements MultiMap<K, V> {
    private final String name;
    protected static final String NULL_KEY_IS_NOT_ALLOWED = "Null key is not allowed!";
    protected static final String NULL_VALUE_IS_NOT_ALLOWED = "Null value is not allowed!";

    public ClientMultiMapProxy(String serviceName, String name) {
        super(serviceName, name);
        this.name = name;
    }

    public boolean put(K key, V value) {
        ValidationUtil.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        ValidationUtil.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        PutRequest request = new PutRequest(this.name, keyData, valueData, -1, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public Collection<V> get(K key) {
        ValidationUtil.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        GetAllRequest request = new GetAllRequest(this.name, keyData);
        PortableCollection result = (PortableCollection)this.invoke((ClientRequest)request, keyData);
        return this.toObjectCollection(result, true);
    }

    public boolean remove(Object key, Object value) {
        ValidationUtil.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        ValidationUtil.checkNotNull((Object)value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        RemoveRequest request = new RemoveRequest(this.name, keyData, valueData, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public Collection<V> remove(Object key) {
        ValidationUtil.checkNotNull((Object)key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        RemoveAllRequest request = new RemoveAllRequest(this.name, keyData, ThreadUtil.getThreadId());
        PortableCollection result = (PortableCollection)this.invoke((ClientRequest)request, keyData);
        return this.toObjectCollection(result, true);
    }

    public Set<K> localKeySet() {
        throw new UnsupportedOperationException("Locality for client is ambiguous");
    }

    public Set<K> keySet() {
        KeySetRequest request = new KeySetRequest(this.name);
        PortableCollection result = (PortableCollection)this.invoke((ClientRequest)request);
        return (Set)this.toObjectCollection(result, false);
    }

    public Collection<V> values() {
        ValuesRequest request = new ValuesRequest(this.name);
        PortableCollection result = (PortableCollection)this.invoke((ClientRequest)request);
        return this.toObjectCollection(result, true);
    }

    public Set<Map.Entry<K, V>> entrySet() {
        EntrySetRequest request = new EntrySetRequest(this.name);
        PortableEntrySetResponse result = (PortableEntrySetResponse)this.invoke((ClientRequest)request);
        Set dataEntrySet = result.getEntrySet();
        HashSet<Map.Entry<K, V>> entrySet = new HashSet<Map.Entry<K, V>>(dataEntrySet.size());
        for (Map.Entry entry : dataEntrySet) {
            Object key = this.toObject((Data)entry.getKey());
            Object val = this.toObject((Data)entry.getValue());
            entrySet.add(new AbstractMap.SimpleEntry(key, val));
        }
        return entrySet;
    }

    public boolean containsKey(K key) {
        ValidationUtil.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        KeyBasedContainsRequest request = new KeyBasedContainsRequest(this.name, keyData, null);
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public boolean containsValue(Object value) {
        ValidationUtil.checkNotNull((Object)value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data valueData = this.toData(value);
        ContainsRequest request = new ContainsRequest(this.name, valueData);
        Boolean result = (Boolean)this.invoke((ClientRequest)request);
        return result;
    }

    public boolean containsEntry(K key, V value) {
        ValidationUtil.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        ValidationUtil.checkNotNull(value, (String)NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        KeyBasedContainsRequest request = new KeyBasedContainsRequest(this.name, keyData, valueData);
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public int size() {
        SizeRequest request = new SizeRequest(this.name);
        Integer result = (Integer)this.invoke((ClientRequest)request);
        return result;
    }

    public void clear() {
        ClearRequest request = new ClearRequest(this.name);
        this.invoke((ClientRequest)request);
    }

    public int valueCount(K key) {
        ValidationUtil.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        CountRequest request = new CountRequest(this.name, keyData);
        Integer result = (Integer)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public String addLocalEntryListener(EntryListener<K, V> listener) {
        throw new UnsupportedOperationException("Locality for client is ambiguous");
    }

    public String addEntryListener(EntryListener<K, V> listener, boolean includeValue) {
        ValidationUtil.isNotNull(listener, (String)"listener");
        AddEntryListenerRequest request = new AddEntryListenerRequest(this.name, null, includeValue);
        EventHandler<PortableEntryEvent> handler = this.createHandler(listener, includeValue);
        return this.listen((ClientRequest)request, handler);
    }

    public boolean removeEntryListener(String registrationId) {
        RemoveEntryListenerRequest request = new RemoveEntryListenerRequest(this.name, registrationId);
        return this.stopListening((BaseClientRemoveListenerRequest)request, registrationId);
    }

    public String addEntryListener(EntryListener<K, V> listener, K key, boolean includeValue) {
        Data keyData = this.toData(key);
        AddEntryListenerRequest request = new AddEntryListenerRequest(this.name, keyData, includeValue);
        EventHandler<PortableEntryEvent> handler = this.createHandler(listener, includeValue);
        return this.listen((ClientRequest)request, keyData, handler);
    }

    public void lock(K key) {
        ValidationUtil.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MultiMapLockRequest request = new MultiMapLockRequest(keyData, ThreadUtil.getThreadId(), this.name);
        this.invoke((ClientRequest)request, keyData);
    }

    public void lock(K key, long leaseTime, TimeUnit timeUnit) {
        ValidationUtil.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        ValidationUtil.shouldBePositive((long)leaseTime, (String)"leaseTime");
        Data keyData = this.toData(key);
        MultiMapLockRequest request = new MultiMapLockRequest(keyData, ThreadUtil.getThreadId(), this.getTimeInMillis(leaseTime, timeUnit), -1L, this.name);
        this.invoke((ClientRequest)request, keyData);
    }

    public boolean isLocked(K key) {
        ValidationUtil.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MultiMapIsLockedRequest request = new MultiMapIsLockedRequest(keyData, this.name);
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public boolean tryLock(K key) {
        ValidationUtil.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        try {
            return this.tryLock(key, 0L, null);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public boolean tryLock(K key, long time, TimeUnit timeunit) throws InterruptedException {
        ValidationUtil.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MultiMapLockRequest request = new MultiMapLockRequest(keyData, ThreadUtil.getThreadId(), Long.MAX_VALUE, this.getTimeInMillis(time, timeunit), this.name);
        Boolean result = (Boolean)this.invoke((ClientRequest)request, keyData);
        return result;
    }

    public void unlock(K key) {
        ValidationUtil.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MultiMapUnlockRequest request = new MultiMapUnlockRequest(keyData, ThreadUtil.getThreadId(), this.name);
        this.invoke((ClientRequest)request, keyData);
    }

    public void forceUnlock(K key) {
        ValidationUtil.checkNotNull(key, (String)NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        MultiMapUnlockRequest request = new MultiMapUnlockRequest(keyData, ThreadUtil.getThreadId(), true, this.name);
        this.invoke((ClientRequest)request, keyData);
    }

    public LocalMultiMapStats getLocalMultiMapStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation) {
        HazelcastInstance hazelcastInstance = this.getContext().getHazelcastInstance();
        JobTracker jobTracker = hazelcastInstance.getJobTracker("hz::aggregation-multimap-" + this.getName());
        return this.aggregate(supplier, aggregation, jobTracker);
    }

    public <SuppliedValue, Result> Result aggregate(Supplier<K, V, SuppliedValue> supplier, Aggregation<K, SuppliedValue, Result> aggregation, JobTracker jobTracker) {
        try {
            ValidationUtil.isNotNull((Object)jobTracker, (String)"jobTracker");
            KeyValueSource keyValueSource = KeyValueSource.fromMultiMap((MultiMap)this);
            Job job = jobTracker.newJob(keyValueSource);
            Mapper mapper = aggregation.getMapper(supplier);
            CombinerFactory combinerFactory = aggregation.getCombinerFactory();
            ReducerFactory reducerFactory = aggregation.getReducerFactory();
            Collator collator = aggregation.getCollator();
            MappingJob mappingJob = job.mapper(mapper);
            ReducingSubmittableJob reducingJob = combinerFactory != null ? mappingJob.combiner(combinerFactory).reducer(reducerFactory) : mappingJob.reducer(reducerFactory);
            JobCompletableFuture future = reducingJob.submit(collator);
            return (Result)future.get();
        }
        catch (Exception e) {
            throw new HazelcastException((Throwable)e);
        }
    }

    @Override
    protected void onDestroy() {
    }

    private Collection toObjectCollection(PortableCollection result, boolean list) {
        Collection coll = result.getCollection();
        AbstractCollection collection = list ? new ArrayList(coll == null ? 0 : coll.size()) : new HashSet(coll == null ? 0 : coll.size());
        if (coll == null) {
            return collection;
        }
        for (Data data : coll) {
            collection.add(this.toObject(data));
        }
        return collection;
    }

    protected long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    private EventHandler<PortableEntryEvent> createHandler(final EntryListener<K, V> listener, final boolean includeValue) {
        return new EventHandler<PortableEntryEvent>(){

            @Override
            public void handle(PortableEntryEvent event) {
                MemberImpl member = ClientMultiMapProxy.this.getContext().getClusterService().getMember(event.getUuid());
                switch (event.getEventType()) {
                    case ADDED: {
                        listener.entryAdded(this.createEntryEvent(event, (Member)member));
                        break;
                    }
                    case REMOVED: {
                        listener.entryRemoved(this.createEntryEvent(event, (Member)member));
                        break;
                    }
                    case CLEAR_ALL: {
                        listener.mapCleared(this.createMapEvent(event, (Member)member));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Not a known event type " + event.getEventType());
                    }
                }
            }

            private MapEvent createMapEvent(PortableEntryEvent event, Member member) {
                return new MapEvent((Object)ClientMultiMapProxy.this.name, member, event.getEventType().getType(), event.getNumberOfAffectedEntries());
            }

            private EntryEvent<K, V> createEntryEvent(PortableEntryEvent event, Member member) {
                Object value = null;
                Object oldValue = null;
                if (includeValue) {
                    value = ClientMultiMapProxy.this.toObject(event.getValue());
                    oldValue = ClientMultiMapProxy.this.toObject(event.getOldValue());
                }
                Object key = ClientMultiMapProxy.this.toObject(event.getKey());
                return new EntryEvent((Object)ClientMultiMapProxy.this.name, member, event.getEventType().getType(), key, oldValue, value);
            }

            @Override
            public void beforeListenerRegister() {
            }

            @Override
            public void onListenerRegister() {
            }
        };
    }

    public String toString() {
        return "MultiMap{name='" + this.getName() + '\'' + '}';
    }
}

