/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientOutOfMemoryHandler;
import com.hazelcast.client.HazelcastClientManagedContext;
import com.hazelcast.client.HazelcastClientProxy;
import com.hazelcast.client.LifecycleServiceImpl;
import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientProperties;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.client.connection.AddressTranslator;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnectionManagerImpl;
import com.hazelcast.client.impl.client.ClientRequest;
import com.hazelcast.client.impl.client.DistributedObjectInfo;
import com.hazelcast.client.impl.client.GetDistributedObjectsRequest;
import com.hazelcast.client.impl.client.txn.ClientTransactionManager;
import com.hazelcast.client.proxy.ClientClusterProxy;
import com.hazelcast.client.proxy.PartitionServiceProxy;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.ClientListenerService;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.ProxyManager;
import com.hazelcast.client.spi.impl.AwsAddressTranslator;
import com.hazelcast.client.spi.impl.ClientClusterServiceImpl;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocationServiceImpl;
import com.hazelcast.client.spi.impl.ClientListenerServiceImpl;
import com.hazelcast.client.spi.impl.ClientPartitionServiceImpl;
import com.hazelcast.client.spi.impl.DefaultAddressTranslator;
import com.hazelcast.client.util.RoundRobinLB;
import com.hazelcast.concurrent.lock.LockProxy;
import com.hazelcast.config.Config;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.core.Client;
import com.hazelcast.core.ClientService;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.IList;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.IdGenerator;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.OutOfMemoryHandler;
import com.hazelcast.core.PartitionService;
import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.mapreduce.JobTracker;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.nio.serialization.SerializationServiceBuilder;
import com.hazelcast.nio.serialization.SerializationServiceImpl;
import com.hazelcast.partition.strategy.DefaultPartitioningStrategy;
import com.hazelcast.spi.impl.SerializableCollection;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.ExceptionUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public final class HazelcastClient
implements HazelcastInstance {
    private static final AtomicInteger CLIENT_ID;
    private static final ConcurrentMap<Integer, HazelcastClientProxy> CLIENTS;
    private static final ILogger LOGGER;
    private final ClientProperties clientProperties;
    private final int id = CLIENT_ID.getAndIncrement();
    private final String instanceName;
    private final ClientConfig config;
    private final ThreadGroup threadGroup;
    private final LifecycleServiceImpl lifecycleService;
    private final SerializationServiceImpl serializationService;
    private final ClientConnectionManager connectionManager;
    private final ClientClusterServiceImpl clusterService;
    private final ClientPartitionServiceImpl partitionService;
    private final ClientInvocationServiceImpl invocationService;
    private final ClientExecutionServiceImpl executionService;
    private final ClientListenerServiceImpl listenerService;
    private final ClientTransactionManager transactionManager;
    private final ProxyManager proxyManager;
    private final ConcurrentMap<String, Object> userContext;
    private final LoadBalancer loadBalancer;

    private HazelcastClient(ClientConfig config) {
        this.config = config;
        GroupConfig groupConfig = config.getGroupConfig();
        this.instanceName = "hz.client_" + this.id + (groupConfig != null ? "_" + groupConfig.getName() : "");
        this.threadGroup = new ThreadGroup(this.instanceName);
        this.lifecycleService = new LifecycleServiceImpl(this);
        this.clientProperties = new ClientProperties(config);
        this.serializationService = this.initSerializationService(config);
        this.proxyManager = new ProxyManager(this);
        this.executionService = this.initExecutorService();
        this.transactionManager = new ClientTransactionManager(this);
        LoadBalancer lb = config.getLoadBalancer();
        if (lb == null) {
            lb = new RoundRobinLB();
        }
        this.loadBalancer = lb;
        this.connectionManager = this.createClientConnectionManager();
        this.clusterService = new ClientClusterServiceImpl(this);
        this.invocationService = new ClientInvocationServiceImpl(this);
        this.listenerService = this.initListenerService();
        this.userContext = new ConcurrentHashMap<String, Object>();
        this.proxyManager.init(config);
        this.partitionService = new ClientPartitionServiceImpl(this);
    }

    private ClientListenerServiceImpl initListenerService() {
        int eventQueueCapacity = this.clientProperties.getEventQueueCapacity().getInteger();
        int eventThreadCount = this.clientProperties.getEventThreadCount().getInteger();
        return new ClientListenerServiceImpl(this, eventThreadCount, eventQueueCapacity);
    }

    private ClientExecutionServiceImpl initExecutorService() {
        return new ClientExecutionServiceImpl(this.instanceName, this.threadGroup, this.config.getClassLoader(), this.config.getExecutorPoolSize());
    }

    private SerializationServiceImpl initSerializationService(ClientConfig config) {
        SerializationService ss;
        try {
            String partitioningStrategyClassName = System.getProperty("hazelcast.partitioning.strategy.class");
            Object partitioningStrategy = partitioningStrategyClassName != null && partitioningStrategyClassName.length() > 0 ? (PartitioningStrategy)ClassLoaderUtil.newInstance((ClassLoader)config.getClassLoader(), (String)partitioningStrategyClassName) : new DefaultPartitioningStrategy();
            ss = new SerializationServiceBuilder().setManagedContext((ManagedContext)new HazelcastClientManagedContext(this, config.getManagedContext())).setClassLoader(config.getClassLoader()).setConfig(config.getSerializationConfig()).setPartitioningStrategy((PartitioningStrategy)partitioningStrategy).build();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        return (SerializationServiceImpl)ss;
    }

    public static HazelcastInstance newHazelcastClient() {
        return HazelcastClient.newHazelcastClient(new XmlClientConfigBuilder().build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HazelcastInstance newHazelcastClient(ClientConfig config) {
        HazelcastClientProxy proxy;
        if (config == null) {
            config = new XmlClientConfigBuilder().build();
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(HazelcastClient.class.getClassLoader());
            HazelcastClient client = new HazelcastClient(config);
            client.start();
            OutOfMemoryErrorDispatcher.register((HazelcastInstance)client);
            proxy = new HazelcastClientProxy(client);
            CLIENTS.put(client.id, proxy);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        return proxy;
    }

    public static Collection<HazelcastInstance> getAllHazelcastClients() {
        return Collections.unmodifiableCollection(CLIENTS.values());
    }

    public static void shutdownAll() {
        for (HazelcastClientProxy proxy : CLIENTS.values()) {
            try {
                proxy.client.getLifecycleService().shutdown();
            }
            catch (Exception ignored) {
                EmptyStatement.ignore((Throwable)ignored);
            }
            proxy.client = null;
        }
        CLIENTS.clear();
    }

    private void start() {
        this.lifecycleService.setStarted();
        this.connectionManager.start();
        try {
            this.clusterService.start();
        }
        catch (IllegalStateException e) {
            this.lifecycleService.shutdown();
            throw e;
        }
        this.loadBalancer.init(this.getCluster(), this.config);
        this.partitionService.start();
    }

    ClientConnectionManager createClientConnectionManager() {
        AddressTranslator addressTranslator;
        ClientAwsConfig awsConfig = this.config.getNetworkConfig().getAwsConfig();
        if (awsConfig != null && awsConfig.isEnabled()) {
            try {
                addressTranslator = new AwsAddressTranslator(awsConfig);
            }
            catch (NoClassDefFoundError e) {
                LOGGER.log(Level.WARNING, "hazelcast-cloud.jar might be missing!");
                throw e;
            }
        } else {
            addressTranslator = new DefaultAddressTranslator();
        }
        return new ClientConnectionManagerImpl(this, this.loadBalancer, addressTranslator);
    }

    public Config getConfig() {
        throw new UnsupportedOperationException("Client cannot access cluster config!");
    }

    public ClientProperties getClientProperties() {
        return this.clientProperties;
    }

    public String getName() {
        return this.instanceName;
    }

    public <E> IQueue<E> getQueue(String name) {
        return (IQueue)this.getDistributedObject("hz:impl:queueService", name);
    }

    public <E> ITopic<E> getTopic(String name) {
        return (ITopic)this.getDistributedObject("hz:impl:topicService", name);
    }

    public <E> ISet<E> getSet(String name) {
        return (ISet)this.getDistributedObject("hz:impl:setService", name);
    }

    public <E> IList<E> getList(String name) {
        return (IList)this.getDistributedObject("hz:impl:listService", name);
    }

    public <K, V> IMap<K, V> getMap(String name) {
        return (IMap)this.getDistributedObject("hz:impl:mapService", name);
    }

    public <K, V> MultiMap<K, V> getMultiMap(String name) {
        return (MultiMap)this.getDistributedObject("hz:impl:multiMapService", name);
    }

    public <K, V> ReplicatedMap<K, V> getReplicatedMap(String name) {
        return (ReplicatedMap)this.getDistributedObject("hz:impl:replicatedMapService", name);
    }

    public JobTracker getJobTracker(String name) {
        return (JobTracker)this.getDistributedObject("hz:impl:mapReduceService", name);
    }

    public ILock getLock(String key) {
        return (ILock)this.getDistributedObject("hz:impl:lockService", key);
    }

    @Deprecated
    public ILock getLock(Object key) {
        String name = LockProxy.convertToStringKey((Object)key, (SerializationService)this.serializationService);
        return (ILock)this.getDistributedObject("hz:impl:lockService", name);
    }

    public Cluster getCluster() {
        return new ClientClusterProxy(this.clusterService);
    }

    public Client getLocalEndpoint() {
        return this.clusterService.getLocalClient();
    }

    public IExecutorService getExecutorService(String name) {
        return (IExecutorService)this.getDistributedObject("hz:impl:executorService", name);
    }

    public <T> T executeTransaction(TransactionalTask<T> task) throws TransactionException {
        return this.transactionManager.executeTransaction(task);
    }

    public <T> T executeTransaction(TransactionOptions options, TransactionalTask<T> task) throws TransactionException {
        return this.transactionManager.executeTransaction(options, task);
    }

    public TransactionContext newTransactionContext() {
        return this.transactionManager.newTransactionContext();
    }

    public TransactionContext newTransactionContext(TransactionOptions options) {
        return this.transactionManager.newTransactionContext(options);
    }

    public IdGenerator getIdGenerator(String name) {
        return (IdGenerator)this.getDistributedObject("hz:impl:idGeneratorService", name);
    }

    public IAtomicLong getAtomicLong(String name) {
        return (IAtomicLong)this.getDistributedObject("hz:impl:atomicLongService", name);
    }

    public <E> IAtomicReference<E> getAtomicReference(String name) {
        return (IAtomicReference)this.getDistributedObject("hz:impl:atomicReferenceService", name);
    }

    public ICountDownLatch getCountDownLatch(String name) {
        return (ICountDownLatch)this.getDistributedObject("hz:impl:countDownLatchService", name);
    }

    public ISemaphore getSemaphore(String name) {
        return (ISemaphore)this.getDistributedObject("hz:impl:semaphoreService", name);
    }

    public Collection<DistributedObject> getDistributedObjects() {
        try {
            GetDistributedObjectsRequest request = new GetDistributedObjectsRequest();
            ICompletableFuture future = this.invocationService.invokeOnRandomTarget((ClientRequest)request);
            SerializableCollection serializableCollection = (SerializableCollection)this.serializationService.toObject(future.get());
            for (Data data : serializableCollection) {
                DistributedObjectInfo o = (DistributedObjectInfo)this.serializationService.toObject((Object)data);
                this.getDistributedObject(o.getServiceName(), o.getName());
            }
            return this.proxyManager.getDistributedObjects();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
    }

    public String addDistributedObjectListener(DistributedObjectListener distributedObjectListener) {
        return this.proxyManager.addDistributedObjectListener(distributedObjectListener);
    }

    public boolean removeDistributedObjectListener(String registrationId) {
        return this.proxyManager.removeDistributedObjectListener(registrationId);
    }

    public PartitionService getPartitionService() {
        return new PartitionServiceProxy(this.partitionService);
    }

    public ClientService getClientService() {
        throw new UnsupportedOperationException();
    }

    public LoggingService getLoggingService() {
        throw new UnsupportedOperationException();
    }

    public LifecycleService getLifecycleService() {
        return this.lifecycleService;
    }

    @Deprecated
    public <T extends DistributedObject> T getDistributedObject(String serviceName, Object id) {
        if (id instanceof String) {
            return (T)this.proxyManager.getOrCreateProxy(serviceName, (String)id);
        }
        throw new IllegalArgumentException("'id' must be type of String!");
    }

    public <T extends DistributedObject> T getDistributedObject(String serviceName, String name) {
        return (T)this.proxyManager.getOrCreateProxy(serviceName, name);
    }

    public ConcurrentMap<String, Object> getUserContext() {
        return this.userContext;
    }

    public ClientConfig getClientConfig() {
        return this.config;
    }

    public SerializationService getSerializationService() {
        return this.serializationService;
    }

    public ClientConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public ClientClusterService getClientClusterService() {
        return this.clusterService;
    }

    public ClientExecutionService getClientExecutionService() {
        return this.executionService;
    }

    public ClientPartitionService getClientPartitionService() {
        return this.partitionService;
    }

    public ClientInvocationService getInvocationService() {
        return this.invocationService;
    }

    public ClientListenerService getListenerService() {
        return this.listenerService;
    }

    public ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public void shutdown() {
        this.getLifecycleService().shutdown();
    }

    void doShutdown() {
        CLIENTS.remove(this.id);
        this.proxyManager.destroy();
        this.executionService.shutdown();
        this.partitionService.stop();
        this.clusterService.stop();
        this.transactionManager.shutdown();
        this.connectionManager.shutdown();
        this.invocationService.shutdown();
        this.listenerService.shutdown();
        this.serializationService.destroy();
    }

    static {
        OutOfMemoryErrorDispatcher.setClientHandler((OutOfMemoryHandler)new ClientOutOfMemoryHandler());
        CLIENT_ID = new AtomicInteger();
        CLIENTS = new ConcurrentHashMap<Integer, HazelcastClientProxy>(5);
        LOGGER = Logger.getLogger(HazelcastClient.class);
    }
}

